#ifndef LIBACP_LIBACPERR_H_
#define LIBACP_LIBACPERR_H_

#define ACP_ERR_SUCCESS 0x0  // No error.

// 1-100之间用于表示一些连接的状态信息
// 通讯状态的变化  0x00 00 20 00
#define ACP_ERR_CONN_SUCCESS 0x0001
#define ACP_ERR_CONN_PENDING 0x0002     // 正在连接
#define ACP_ERR_NO_CONN 0x0003          // 未连接
#define ACP_ERR_CONN_REFUSED 0x0004     // 拒绝连接
#define ACP_ERR_CONN_LOST 0x0005        // 断开连接
#define ACP_ERR_CONN_TIMEOUT 0x0006     // 连接超时
#define ACP_ERR_HOSTUNREACHABLE 0x0007  // Host unreachable
#define ACP_ERR_AUTH_CONTINUE 0x0008    // 需要权限认证

// 参数或者配置信息错误   0x00 00 10 00
#define ACP_ERR_INVALID_ACPDEVICEID 0x1001    // 无效的AcpDeviceId
#define ACP_ERR_INVAILD_HANDLER 0x1002        // 无效的句柄
#define ACP_ERR_INVAILD_NETADAPTER 0x1003     // 无效的网络适配器
#define ACP_ERR_INIT_RESOURCE_ERROR 0x104     // 初始化资源错误
#define ACP_ERR_PORT_ALREADY_REGISTER 0x1005  // port号已经被注册了
#define ACP_ERR_INVAILD_PORT 0x1006           // 无效的port号,port号1-65535
#define ACP_ERR_NOSUPPORT_PROTOCOL 0x1007     // 不支持的协议
#define ACP_ERR_MESSAGE_FORMAT_ERROR 0X1008   // ACP消息格式错粗
#define ACP_ERR_INVAILD_IDGROUP 0X1009        // 无效的id group
#define ACP_ERR_INVAILD_IDOFFSET 0X1010       // 无效的id offset
#define ACP_ERR_MESSAGE_TIMEOUT 0X1011        // 消息超时
#define ACP_ERR_INVAILD_INPUT_PARAM 0X1012    // 无效的输入参数
#define ACP_ERR_SERVER_NOT_RUNING 0X1013      // ACP服务未运行
#define ACP_ERR_INVAILD_UNSUB_TOPIC 0X1014    // 未订阅的topic
#define ACP_ERR_INVAILD_REQ_CMD 0X1015        // 无效的请求命令

// 组件相关的错误码
#define ACP_ERR_CMP_UNREGISTER 0X2001              // 组件未注册的
#define ACP_ERR_CMP_CONN_ACPSERVER_TIMEOUT 0X2002  // 连接ACP服务超时
#define ACP_ERR_CMP_ALREADY_REGISTER 0X2003        // 组件已经注册了

#endif  // LIBACP_LIBACPERR_H_
