#ifndef LIBACP_LIBACPDEF_H_
#define LIBACP_LIBACPDEF_H_

#include <stdint.h>

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#pragma pack(push, 1)

#define CONN_TYPE_TCP 0         // TCP通讯
#define CONN_TYPE_UDP 1         // UDP通讯
#define CONN_TYPE_LINUXSHM 2    // Linux使用共享内存通讯
#define CONN_TYPE_WINSHM 3      // 双域下的共享内存
#define CONN_TYPE_UNIXDOMAIN 4  // domain的socket的域

#define MIN_ROUTER_PORT 1      // 最小路由端口
#define MAX_ROUTER_PORT 65535  // 最大路由端口

// ACP PORT 1~300之间为ACP系统服务保留的路由port
#define ACPPORT_R0_ECHO 100
#define ACPPORT_R0_PLC_DEV 101
#define ACPPORT_R0_PLC_REGISTER 102  // 插件注册
#define ACPPORT_R0_PUBSUB 103        // 发布订阅系统

// ACP Id group
#define ACPIGRP_SYM_PLCDEVICE 0x1000  // read PLC parameter
#define ACPIGRP_SYM_PLCPSTATUS 0x2000
// ACP Id offset

#define ACPIOFFS_READ_DEVICEID 0x00000001   // 读deviceId
#define ACPIOFFS_WRITE_DEVICEID 0x00000002  // 写deviceId

typedef struct _AcpVersion {
  /** Version number. */
  uint8_t version;
  /** Revision number. */
  uint8_t revision;
  /** patch number */
  uint16_t patch;
} AcpVersion, *pAcpVersion;

typedef struct _AcpDeviceId {
  uint8_t b[6];
} AcpDeviceId, *pAcpDeviceId;

typedef struct _AcpDeviceAddr {
  /** Acp device Id */
  AcpDeviceId deviceId;
  /** Local Port */
  uint16_t port;
} AcpDeviceAddr, *pAcpDeviceAddr;

typedef struct _AcpDevice {
  char szDeviceIp[32];      // 设备的IP地址
  char szProdType[32];      // 设备的产品类型 sx5 sx2
  char szMacAddr[32];       // 设备的mac地址
  char szSerailNumber[32];  // codesys的序列号
  char szSn[32];            // 设备的sn号
  char szAcpDeviceId[32];   // 设备Acp的DeviceId
  char szAcpVersion[32];    // 设备ACP的服务Version
  char szRteVersion[32];    // 机器RTE的版本
} AcpDevice, *pAcpDevice;

#pragma pack(pop)

typedef void* ACP_HANDER;

/*
 *@breif:设置发现的回调函数
 *@param: acpDevice   扫描到服务端的DeviceId
 *@param: data           数据缓冲区起始地址
 *@param: len            数据缓冲区大小
 *@param: lpContext      用户指针
 */
typedef void (*pfnAcpDeviceScanCallback)(AcpDevice acpDevice, void* lpConetext);

/*
 *@breif:连接和断开连接的回调函数
 *@param: acpDeviceId   要连接的deviceId
 *@param: lpContext     设置连接回调的是用户指针数据
 *@param: rc            连接回调的状态
 */
typedef void (*pfnAcpConnCallback)(AcpDeviceId* acpDeviceId, void* lpContext, int rc);

/*
 *@breif:注册路由事件回调函数
 *@param: data      数据缓冲区起始地址
 *@param: dataLen   数据缓冲区大小
 *@param: port      路由的port
 *@param: lpContext 添加路由的时候用户指针
 */
typedef void (*pfnCliRegisetrRouterEvnet)(const char* data, uint32_t len, int port, void* lpContext);

/*
 *@breif:发布订阅回调函数
 *@param: szTopic 订阅的topic
 *@param: data    topic订阅到的数据缓冲区起始地址
 *@param: dataLen topic订阅到的数据缓冲区大小
 *@param: lpContext 订阅的时候传入的用户指针数据
 */
typedef void (*pfnSubscribeCallback)(const char* szTopic, const char* data, uint32_t dataLen, void* lpContext);

#endif  // LIBACP_LIBACPDEF_H_
