#!/bin/bash
# 必须以 root 权限执行此脚本
if [ "$(id -u)" != "0" ]; then
   echo "This script must be run as root" 
   exit 1
fi

# 禁用和停止服务
SERVICES=(
  "xvisual.agent.service"
  "xvisual.server.service"
  "xvisual.comm.service"
  "xvisual.web.service"
)

for service in "${services[@]}"; do
  echo "Disabling ${service}.service..."
  sudo systemctl disable "${service}.service"
  echo "${service}.service has been disabled."
  
  echo "Stopping ${service}.service..."
  sudo systemctl stop "${service}.service"
  echo "${service}.service has been stopped."
done

# 删除守护进程文件
echo "Removing previously added daemon files from /etc/systemd/system..."
sudo rm -f /etc/systemd/system/xvisual.agent.service
sudo rm -f /etc/systemd/system/xvisual.server.service
sudo rm -f /etc/systemd/system/xvisual.comm.service
sudo rm -f /etc/systemd/system/xvisual.web.service
echo "Daemon files removed."

# 删除 /opt/xvisual 目录及其内容
echo "Deleting /opt/xvisual directory with all contents..."
sudo rm -rf /opt/xvisual
echo "/opt/xvisual directory has been deleted."

echo "Uninstall Finished."
