//
//  ESCPrinter.m
//  JXPrinterDemo
//
//  Created by 贾俊伟 on 2022/6/22.
//

#import "ESCPrinter.h"

@implementation ESCPrinter

- (void)printAll {
    [self drawText];
    [self drawGraphic];
    [self drawBarCode];
    [self drawQrCode];
}

//文字
- (void)drawText {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager escPrintText:NSLocalizedString(@"TextDemo", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escAlign:0];
    [manager escPrintText:NSLocalizedString(@"TextLeft", nil)];
    [manager escPrintFormfeed];

    [manager escReset];
    [manager escAlign:1];
    [manager escPrintText:NSLocalizedString(@"TextCenter", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escAlign:2];
    [manager escPrintText:NSLocalizedString(@"TextRight", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escBold:YES];
    [manager escPrintText:NSLocalizedString(@"TextBlod", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escUnderline:2];
    [manager escPrintText:NSLocalizedString(@"TextUnderLine", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escPrintText:[NSString stringWithFormat:@"%@：", NSLocalizedString(@"DifferentHeights", nil)]];
    [manager escPrintFormfeed];
    
    [manager escPrintText:[NSString stringWithFormat:@"1%@", NSLocalizedString(@"Times", nil)]];
    
    [manager escCharacterSize:22];
    [manager escPrintText:[NSString stringWithFormat:@"2%@", NSLocalizedString(@"Times", nil)]];
    
    [manager escCharacterSize:33];
    [manager escPrintText:[NSString stringWithFormat:@"3%@", NSLocalizedString(@"Times", nil)]];
    
    [manager escCharacterSize:44];
    [manager escPrintText:[NSString stringWithFormat:@"4%@", NSLocalizedString(@"Times", nil)]];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escPrintText:NSLocalizedString(@"Zoom1", nil)];
    [manager escPrintFormfeed];
    
    [manager escCharacterSize:22];
    [manager escPrintText:NSLocalizedString(@"Zoom2", nil)];
    [manager escPrintFormfeed];
    
    [manager escCharacterSize:33];
    [manager escPrintText:NSLocalizedString(@"Zoom3", nil)];
    [manager escPrintFormfeed];
    
    [manager escCharacterSize:44];
    [manager escPrintText:NSLocalizedString(@"Zoom4", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escFont:0];
    [manager escPrintText:NSLocalizedString(@"FontA", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escFont:1];
    [manager escPrintText:NSLocalizedString(@"FontB", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escRotate:1];
    [manager escPrintText:NSLocalizedString(@"Rotate90", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escRotate:2];
    [manager escPrintText:NSLocalizedString(@"Rotate180", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escRotate:3];
    [manager escPrintText:NSLocalizedString(@"Rotate270", nil)];
    [manager escPrintFormfeed];
    
    [manager escReset];
    [manager escBlackWhiteReverse:YES];
    [manager escPrintText:NSLocalizedString(@"TextReverse", nil)];
    [manager escPrintFormfeed];
}

//一维条码
- (void)drawBarCode {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager escReset];
    [manager escBarcodeWithHRIPosition:0 HRIFont:1 width:3 height:80 type:8 content:@"123456789012"];
    [manager escPrintFormfeed];
}

//二维码
- (void)drawQrCode {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager escReset];
    [manager escPrintBarcode2dWithSize:4 content:@"1234567890"];
    [manager escPrintFormfeed];
}

//图片
- (void)drawGraphic {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager escReset];
    [manager escBitmapMode:1 image:[UIImage imageNamed:@"logo"]];
    [manager escPrintFormfeed];
}

//TE40打印图片
- (void)drawGraphicTE40 {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager escReset];
    [manager escRasterImage:[UIImage imageNamed:@"logo"]];
    [manager escPrintToLabel];
}

- (void)printSetting {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager escReset];
    [manager escPrintText:NSLocalizedString(@"absolute0", nil)];
    [manager escPrintFormfeed];
    [manager escReset];
    
    [manager escAbsolutePrintPosition:100 nH:0];
    [manager escPrintText:NSLocalizedString(@"absolute100", nil)];
    [manager escPrintFormfeed];
    [manager escReset];
    
    [manager escDefaultLineHeight];
    [manager escPrintText:NSLocalizedString(@"defaultRowHeight", nil)];
    [manager escPrintFormfeed];
    [manager escReset];

    [manager escLineHeight:50];
    [manager escPrintText:NSLocalizedString(@"rowHeight50", nil)];
    [manager escPrintFormfeed];
    [manager escReset];
     
    [manager escRightSpace:0];
    [manager escPrintText:NSLocalizedString(@"characterSpace0", nil)];
    [manager escPrintFormfeed];
    [manager escReset];
    
    [manager escRightSpace:20];
    [manager escPrintText:NSLocalizedString(@"characterSpace20", nil)];
    [manager escPrintFormfeed];
    [manager escReset];

    [manager escLeftMargin:0 nH:0];
    [manager escPrintText:NSLocalizedString(@"leftMargin0", nil)];
    [manager escPrintFormfeed];
    [manager escReset];
    
    [manager escLeftMargin:50 nH:0];
    [manager escPrintText:NSLocalizedString(@"leftMargin50", nil)];
    [manager escPrintFormfeed];
    [manager escReset];
    
    [manager escPrintText:NSLocalizedString(@"feed3", nil)];
    [manager escPrintFormfeedRow:3];
}

@end
