//
//  JXBleInfo.h
//  JXPrinter
//
//  Created by 贾俊伟 on 2021/3/26.
//

#import <Foundation/Foundation.h>
#import "JXBleManager.h"

NS_ASSUME_NONNULL_BEGIN

@interface JXBleInfo : NSObject<NSCoding>

@property (nonatomic, copy) NSString *bleName;
@property (nonatomic, copy) NSString *bleIdentifier;
@property (nonatomic, copy) NSString *bleServiceUUID;
@property (nonatomic, copy) NSString *bleCharUUID;

+ (JXBleInfo *)bleInfoWithName:(NSString *)bleName
                    identifier:(NSString *)bleIdentifier
                   serviceUUID:(NSString *)bleServiceUUID
                      charUUID:(NSString *)bleCharUUID;

@end

@interface JXPrinterUseInfo : NSObject

/// 关机次数
@property (nonatomic, assign) NSInteger totalPowerOffCount;
/// 开机次数
@property (nonatomic, assign) NSInteger totalPowerOnCount;
/// 开盖次数
@property (nonatomic, assign) NSInteger totalCoverOpenCount;
/// 打印长度（米）
@property (nonatomic, assign) float totalPrintLength;

@end

/// 光耦信息
@interface JXPrinterOptocouplerInfo : NSObject

// 缺纸光耦
@property (nonatomic,copy) NSArray<NSNumber *> *noPaperValues;
// 有纸光耦
@property (nonatomic,copy) NSArray<NSNumber *> *paperValues;
// 黑标光耦
@property (nonatomic,copy) NSArray<NSNumber *> *blackValues;

@end

@interface JXPrinterFontLibInfo : NSObject

@property (nonatomic, assign) NSInteger libId;
@property (nonatomic, assign) NSInteger charHeight;
@property (nonatomic,   copy) NSString *libName;

@end


@interface JXPrinterHeadAndBatteryInfo : NSObject

//打印头温度
@property (nonatomic, assign) NSInteger headTemperature;
//电池电压
@property (nonatomic, assign) NSInteger batteryVoltage;
//充电状态  0：未充电     1：正在充电    2：充电已完成    255：没有电池
@property (nonatomic, assign) NSInteger chargingState;
//剩余电量
@property (nonatomic, assign) NSInteger batteryPercent;

@end

NS_ASSUME_NONNULL_END
