//
//  JXProgressHUD.m
//  wificonfig
//
//  Created by 贾俊伟 on 2021/5/11.
//

#import "JXProgressHUD.h"
#import "MBProgressHUD.h"

@implementation JXProgressHUD

+ (void)toast:(NSString *)toast {
    UIView *view = [UIApplication sharedApplication].delegate.window;
    [self toast:toast inView:view];
}

+ (void)toast:(NSString *)toast inView:(UIView *)inView {
    if (!toast.length) {
        return;
    }
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:inView animated:YES];
    hud.mode = MBProgressHUDModeText;
    hud.label.numberOfLines = 0;
    hud.label.text = toast;
    hud.userInteractionEnabled = NO;
    [hud hideAnimated:YES afterDelay:2.f];
}

+ (void)showHUD {
    UIView *view = [UIApplication sharedApplication].delegate.window;
    [MBProgressHUD showHUDAddedTo:view animated:YES];
}

+ (void)hideHUD {
    UIView *view = [UIApplication sharedApplication].delegate.window;
    [MBProgressHUD hideHUDForView:view animated:YES];
}

@end
