//
//  CPCLPrinter.m
//  JXPrinterDemo
//
//  Created by 贾俊伟 on 2022/6/22.
//

#import "CPCLPrinter.h"

@implementation CPCLPrinter

- (instancetype)init {
    if (self = [super init]) {
        self.printWidth = 576;
    }
    return self;
}

- (void)printAll {
    [self drawText];
    [self drawGraphic];
    [self drawBarCode];
    [self drawQrCode];
    [self drawLine];
    [self drawBox];
}

//边框
- (void)drawBox {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager cpclPageSetup:576 pageHeight:400];
    [manager cpclDrawBoxWithLineWidth:2 topLeftX:10 topLeftY:10 bottomRightX:80 bottomRightY:80];
    [manager cpclPrint:0 skip:0];
}

//线条
- (void)drawLine {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager cpclPageSetup:576 pageHeight:400];
    [manager cpclDrawLineWithLineWidth:3 startX:150 startY:30 endX:300 endY:30];
    [manager cpclPrint:0 skip:0];
}

//文字
- (void)drawText {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager cpclPageSetup:self.printWidth pageHeight:800];
    int y = 0;
    [manager cpclDrawTextWithTextX:8 textY:y text:NSLocalizedString(@"TextDemo", nil) fontSize:2 rotate:0 bold:0 reverse:NO underline:NO];
    y += 30;
    [manager cpclDrawTextWithTextX:8 textY:y text:NSLocalizedString(@"TextBlod", nil) fontSize:2 rotate:0 bold:1 reverse:NO underline:NO];
    y += 30;
    [manager cpclDrawTextWithTextX:8 textY:y text:NSLocalizedString(@"TextUnderLine", nil) fontSize:2 rotate:0 bold:0 reverse:NO underline:YES];
    y += 30;
    [manager cpclDrawTextWithTextX:8 textY:y text:NSLocalizedString(@"TextReverse", nil) fontSize:2 rotate:0 bold:0 reverse:YES underline:NO];
    y += 30;
    [manager cpclDrawTextWithTextX:8 textY:y text:NSLocalizedString(@"TextFont", nil) fontSize:2 rotate:0 bold:0 reverse:NO underline:NO];
    y += 30;
    [manager cpclDrawTextWithTextX:8 textY:y text:@"2mm" fontSize:1 rotate:0 bold:0 reverse:NO underline:NO];
    [manager cpclDrawTextWithTextX:56 textY:y text:@"3mm" fontSize:2 rotate:0 bold:0 reverse:NO underline:NO];
    [manager cpclDrawTextWithTextX:128 textY:y text:@"4mm" fontSize:3 rotate:0 bold:0 reverse:NO underline:NO];
    [manager cpclDrawTextWithTextX:224 textY:y text:@"5mm" fontSize:4 rotate:0 bold:0 reverse:NO underline:NO];
    [manager cpclDrawTextWithTextX:344 textY:y text:@"6mm" fontSize:5 rotate:0 bold:0 reverse:NO underline:NO];
    y += 56;
    [manager cpclDrawTextWithTextX:8 textY:y text:@"7mm" fontSize:6 rotate:0 bold:0 reverse:NO underline:NO];
    [manager cpclDrawTextWithTextX:176 textY:y text:@"8mm" fontSize:7 rotate:0 bold:0 reverse:NO underline:NO];
//    [manager cpclDrawTextWithTextX:368 textY:y text:@"9mm" fontSize:72 rotate:0 bold:0 reverse:NO underline:NO];
    y += 80;
    [manager cpclDrawTextWithTextX:8 textY:y text:NSLocalizedString(@"TextRotate", nil) fontSize:2 rotate:0 bold:0 reverse:NO underline:NO];
    y += 30;
    [manager cpclDrawTextWithTextX:8 textY:y text:NSLocalizedString(@"TextRotate0", nil) fontSize:2 rotate:0 bold:0 reverse:NO underline:NO];
    y += 130;
    [manager cpclDrawTextWithTextX:8 textY:y text:NSLocalizedString(@"TextRotate90", nil) fontSize:2 rotate:1 bold:0 reverse:NO underline:NO];
    y += 30;
    [manager cpclDrawTextWithTextX:176 textY:y text:NSLocalizedString(@"TextRotate180", nil) fontSize:2 rotate:2 bold:0 reverse:NO underline:NO];
    y += 30;
    [manager cpclDrawTextWithTextX:30 textY:y text:NSLocalizedString(@"TextRotate270", nil) fontSize:2 rotate:3 bold:0 reverse:NO underline:NO];
    [manager cpclPrint:0 skip:0];
}

//* @param fontSize 字体大小: 1：16点阵； 2：24点阵； 3：32点阵；4：24点阵放大一倍；5：32点阵放大一倍；6：24点阵放大两倍；7：32点阵放大两倍；其他：24点阵

//一维条码
- (void)drawBarCode {
    [self printBarcode1];
    [self printBarcode2];
}

- (void)printBarcode2 {
    int width = self.printWidth;
    NSString *type = NSLocalizedString(@"Category", nil);
    NSString *content = NSLocalizedString(@"Content", nil);
    int lineWidth = 2;
    int height = 80;
    
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager cpclPageSetup:width pageHeight:800];
    int y = 0;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:EAN_8;%@:12345670", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"1234567" type:4 rotate:0 linewidth:lineWidth height:height];
    y += 110;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:EAN_13;%@:1234567890128", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"123456789012" type:5 rotate:0 linewidth:lineWidth height:height];
    y += 110;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:UPC_A %@:123456789012", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"12345678901" type:6 rotate:0 linewidth:lineWidth height:height];
    y += 110;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:UPC_E;%@:04029311", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"0402931" type:7 rotate:0 linewidth:lineWidth height:height];
    y += 110;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:ITF;%@:1234567890", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"1234567890" type:8 rotate:0 linewidth:lineWidth height:height];
    y += 110;
    
    [manager cpclPrint:0 skip:0];
}

- (void)printBarcode1 {
    int width = self.printWidth;
    NSString *type = NSLocalizedString(@"Category", nil);
    NSString *content = NSLocalizedString(@"Content", nil);
    int lineWidth = 2;
    int height = 80;
    
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager cpclPageSetup:width pageHeight:800];
    int y = 0;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:CODE_39;%@:123456789", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"123456789" type:0 rotate:0 linewidth:lineWidth height:height];
    y += 110;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:CODE_128;%@:123456789", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"123456789" type:1 rotate:0 linewidth:lineWidth height:height];
    y += 110;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:CODE93;%@:123456789", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"123456789" type:2 rotate:0 linewidth:lineWidth height:height];
    y += 110;
    
    [self textWithManager:manager x:8 y:y text:[NSString stringWithFormat:@"%@:Codabar;%@:123456789", type, content]];
    y += 35;
    [manager cpclDrawBarCodeWithStartX:8 startY:y text:@"123456789" type:3 rotate:0 linewidth:lineWidth height:height];
    
    [manager cpclPrint:0 skip:0];
}

- (void)textWithManager:(JXPrinterManager *)manager x:(int)x y:(int)y text:(NSString *)text {
    [manager cpclDrawTextWithTextX:x textY:y text:text fontSize:2 rotate:0 bold:0 reverse:NO underline:NO];
}

//二维码
- (void)drawQrCode {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager cpclPageSetup:576 pageHeight:400];
    [manager cpclDrawQrCodeWihtStartX:10 startY:10 text:@"123456" rotate:0 ver:2 lel:3];
    [manager cpclPrint:0 skip:0];
}

//图片
- (void)drawGraphic {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager cpclPageSetup:self.printWidth pageHeight:400];
    [manager cpclDrawGraphicWithStartX:0 startY:0 image:[UIImage imageNamed:@"logo"]];
    [manager cpclPrint:0 skip:0];
}


@end
