//
//  GlobalLinePrinter.m
//  JXPrinterDemo
//
//  Created by 贾俊伟 on 2021/10/19.
//

#import "GlobalLinePrinter.h"

@implementation GlobalLinePrinter

- (instancetype)init {
    if (self = [super init]) {
        self.printWidth = 384;
    }
    return self;
}

- (void)printText {
    // Demonstration of multiple national languages
    [self internationalization];
    
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalLineMaxPrintWidth:self.printWidth];
    
    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"TextDemo", nil)];
    [manager globalLinePrint];

    [manager globalLineAlign:0];
    [manager globalLineDrawText:NSLocalizedString(@"TextLeft", nil)];
    [manager globalLinePrint];

    [manager globalLineReset];
    [manager globalLineAlign:1];
    [manager globalLineDrawText:NSLocalizedString(@"TextCenter", nil)];
    [manager globalLinePrint];

    [manager globalLineAlign:2];
    [manager globalLineDrawText:NSLocalizedString(@"TextRight", nil)];
    [manager globalLinePrint];

    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"LeftMargin", nil)];
    [manager globalLinePrint];
    [manager globalLineLeftMargin:80];
    [manager globalLineDrawText:@"abcDEFJLJGJLLJGKLJGLAJGLJGLJNDHJHGJHSGGUJGLJGlakghk1234"];
    [manager globalLinePrint];

    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"RightMargin", nil)];
    [manager globalLinePrint];
    [manager globalLineReset];
    [manager globalLineRightMargin:80];
    [manager globalLineDrawText:@"abcDEFJLJGJLLJGKLJGLAJGLJGLJNDHJHGJHSGGUJGLJGlakghk1234"];
    [manager globalLinePrint];
    
    NSString *rowSpace = NSLocalizedString(@"SetLineSpace", nil);
    [manager globalLineReset];
    [manager globalLineDrawText:[NSString stringWithFormat:@"%@ 0mm", rowSpace]];
    [manager globalLinePrint];

    [manager globalLineLineSpace:8];
    [manager globalLineDrawText:[NSString stringWithFormat:@"%@ 1mm", rowSpace]];
    [manager globalLinePrint];

    [manager globalLineLineSpace:16];
    [manager globalLineDrawText:[NSString stringWithFormat:@"%@ 2mm", rowSpace]];
    [manager globalLinePrint];

    NSString *letterSpace = NSLocalizedString(@"SetLetterSpace", nil);
    [manager globalLineReset];
    [manager globalLineDrawText:[NSString stringWithFormat:@"%@ 0mm", letterSpace]];
    [manager globalLinePrint];

    [manager globalLineLetterSpace:8];
    [manager globalLineDrawText:[NSString stringWithFormat:@"%@ 1mm", letterSpace]];
    [manager globalLinePrint];

    [manager globalLineLetterSpace:16];
    [manager globalLineDrawText:[NSString stringWithFormat:@"%@ 2mm", letterSpace]];
    [manager globalLinePrint];
    
    [manager globalLineReset];
    [manager globalLineIsBold:YES];
    [manager globalLineDrawText:NSLocalizedString(@"TextBlod", nil)];
    [manager globalLinePrint];

    [manager globalLineReset];
    [manager globalLineIsUnderline:YES];
    [manager globalLineDrawText:NSLocalizedString(@"TextUnderLine", nil)];
    [manager globalLinePrint];

    [manager globalLineReset];
    [manager globalLineIsItaly:YES];
    [manager globalLineDrawText:NSLocalizedString(@"TextItalics", nil)];
    [manager globalLinePrint];

    [manager globalLineReset];
    [manager globalLineIsReverse:YES];
    [manager globalLineDrawText:NSLocalizedString(@"TextReverse", nil)];
    [manager globalLinePrint];

    [manager globalLineReset];
    [manager globalLineIsBold:YES];
    [manager globalLineIsUnderline:YES];
    [manager globalLineIsItaly:YES];
    [manager globalLineIsReverse:YES];
    [manager globalLineDrawText:NSLocalizedString(@"TextAll", nil)];
    [manager globalLinePrint];
    
    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"TextFont", nil)];
    [manager globalLinePrint];
    for (int i = 0; i < 9; i++) {
        [manager globalLineReset];
        [manager globalLineFontSize:(i + 2)*8];
        [manager globalLineDrawText:[NSString stringWithFormat:@"%@mm,", @(i+2)]];
    }
    [manager globalLinePrint];
    
    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"TextScale", nil)];
    [manager globalLinePrint];

    [manager globalLineFontWidthScale:2];
    [manager globalLineDrawText:NSLocalizedString(@"TextDoubleWidth", nil)];
    [manager globalLinePrint];

    [manager globalLineReset];
    [manager globalLineFontHeightScale:2];
    [manager globalLineDrawText:NSLocalizedString(@"TextDoubleHeight", nil)];
    [manager globalLinePrint];
    [[JXPrinterManager printerManagerWithConnectType:self.connectType] globalLineFeed:120];
}

//图片
- (void)drawGraphic {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalLineMaxPrintWidth:self.printWidth];
    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"ImagePrint", nil)];
    [manager globalLinePrint];

    UIImage *image = [UIImage imageNamed:@"logo"];
    [manager globalLineDrawGraphicWithImage:image];
    [manager globalLinePrint];
    
    [manager globalLineAlign:1];
    [manager globalLineDrawGraphicWithImage:image];
    [manager globalLinePrint];

    [manager globalLineAlign:2];
    [manager globalLineDrawGraphicWithImage:image];
    [manager globalLinePrint];
    [[JXPrinterManager printerManagerWithConnectType:self.connectType] globalLineFeed:120];
}

//一维条码
- (void)drawBarCode {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalLineMaxPrintWidth:self.printWidth];
    // 条形码
    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"BarcodeNoText", nil)];
    [manager globalLinePrint];
    [manager globalLineDrawBarCodeWithWidth:200
                                     height:50
                                    content:@"0123456789"
                                     rotate:RotationAngle0
                                     format:BarcodeFormatCode128];
    [manager globalLinePrint];

    [manager globalLineDrawText:NSLocalizedString(@"BarcodeTextBelow", nil)];
    [manager globalLinePrint];
    [manager globalLineSetBarcodeTextWithIsPositionBelow:YES
                                                fontSize:24
                                                  isBold:NO
                                                  margin:0
                                               breakLine:NO];
    [manager globalLineDrawBarCodeWithWidth:200 height:50 content:@"0123456789" rotate:RotationAngle0 format:BarcodeFormatCode128];
    [manager globalLinePrint];
    
    [manager globalLineDrawText:NSLocalizedString(@"BarcodeTextUp", nil)];
    [manager globalLinePrint];
    [manager globalLineSetBarcodeTextWithIsPositionBelow:NO fontSize:24 isBold:YES margin:8 breakLine:NO];
    [manager globalLineDrawBarCodeWithWidth:200 height:50 content:@"0123456789" rotate:RotationAngle0 format:BarcodeFormatCode128];
    [manager globalLinePrint];

    [manager globalLineSetBarcodeTextWithIsPositionBelow:NO fontSize:24 isBold:YES margin:8 breakLine:NO];
    [manager globalLineDrawBarCodeWithWidth:200 height:50 content:@"0123456789" rotate:RotationAngle90 format:BarcodeFormatCode128];
    [manager globalLinePrint];

    [manager globalLineSetBarcodeTextWithIsPositionBelow:NO fontSize:24 isBold:YES margin:8 breakLine:NO];
    [manager globalLineDrawBarCodeWithWidth:200 height:50 content:@"0123456789" rotate:RotationAngle180 format:BarcodeFormatCode128];
    [manager globalLinePrint];

    [manager globalLineSetBarcodeTextWithIsPositionBelow:NO fontSize:24 isBold:YES margin:8 breakLine:NO];
    [manager globalLineDrawBarCodeWithWidth:200 height:50 content:@"0123456789" rotate:RotationAngle270 format:BarcodeFormatCode128];
    [manager globalLinePrint];
    
    NSArray<NSString *> *barcodeTypes = @[@"codabar", @"code39", @"code93", @"code128", @"EAN-8", @"EAN-13", @"ITF", @"UPCA", @"UPCE"];
    for (int i = 0; i < barcodeTypes.count; i++) {
        NSString *contents = @"1234567890";
        if (i == 4 || i == 8) {
            // EAN-8 1D format. Contents should be 7 or 8 digits long
            contents = @"12345670";
        }
        if (i == 5) {
            // EAN-13 1D format. Contents should be 12 or 13 digits long
            contents = @"1234567890128";
        }
        if (i == 7) {
            // The front is automatically filled with 0
            contents = @"123456789012";
        }

        [manager globalLineDrawText:[NSString stringWithFormat:@"%@：%@  %@：%@", NSLocalizedString(@"Category", nil), barcodeTypes[i], NSLocalizedString(@"Content", nil), contents]];
        [manager globalLinePrint];
        [manager globalLineDrawBarCodeWithWidth:300 height:100 content:contents rotate:RotationAngle0 format:i];
        [manager globalLinePrint];
    }
    [[JXPrinterManager printerManagerWithConnectType:self.connectType] globalLineFeed:120];
}

//二维码
- (void)drawQrCode {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalLineMaxPrintWidth:self.printWidth];
    // 二维码
    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"QrcodePrint", nil)];
    NSArray<NSString *> *QRcodeTypes = @[@"QR", @"PDF417", @"Aztec", @"DataMatrix"];
    NSString *contents = @"1234567890";
    for (int i = 0; i < QRcodeTypes.count; i++) {
        [manager globalLineDrawText:[NSString stringWithFormat:@"%@：%@  %@：%@", NSLocalizedString(@"Category", nil), QRcodeTypes[i], NSLocalizedString(@"Content", nil), contents]];
        [manager globalLinePrint];
        if (i == 1) {
            [manager globalLineDrawQrCodeWithWidth:200 height:100 content:contents rotate:RotationAngle0 format:i];
        } else {
            [manager globalLineDrawQrCodeWithWidth:150 height:150 content:contents rotate:RotationAngle0 format:i];
        }
        [manager globalLinePrint];
    }
    [[JXPrinterManager printerManagerWithConnectType:self.connectType] globalLineFeed:120];
}

//线条
- (void)drawLine {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalLineMaxPrintWidth:self.printWidth];
    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"LinePrint", nil)];
    [manager globalLinePrint];
    [manager globalLineDrawLineWithLineLength:2
                                    lineWidth:100
                                      isSolid:YES];
    [manager globalLinePrint];
    [manager globalLineDrawLineWithLineLength:100
                                    lineWidth:2
                                      isSolid:NO];
    [manager globalLinePrint];
    [[JXPrinterManager printerManagerWithConnectType:self.connectType] globalLineFeed:120];
}

- (void)drawLineSegments {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalLineMaxPrintWidth:self.printWidth];
    [manager globalLineReset];
    [manager globalLineDrawText:NSLocalizedString(@"CurvePrint", nil)];
    [manager globalLinePrint];
    
    [manager globalLineDrawLineSegments:@[@30, @230]];
    [manager globalLineDrawLineSegments:@[@130, @130]];
    int x;
    for (int i = 1; i <= 512; i++) {
        x = (int) (sin(M_PI * i / 128) * 100 + 130);
        [manager globalLineDrawLineSegments:@[@130, @130, @(x), @(x)]];
    }
    [[JXPrinterManager printerManagerWithConnectType:self.connectType] globalLineFeed:120];
}

- (void)internationalization {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalLineMaxPrintWidth:self.printWidth];
    [manager globalLineReset];
    //英语
    [manager globalLineDrawText:@"Hello World"];
    [manager globalLinePrint];
    //中文
    [manager globalLineDrawText:@"你好，世界"];
    [manager globalLinePrint];
    //法语
    [manager globalLineDrawText:@"Bonjour, le monde."];
    [manager globalLinePrint];
    //西班牙语
    [manager globalLineDrawText:@"Hola, mundo."];
    [manager globalLinePrint];
    //葡萄牙语
    [manager globalLineDrawText:@"Olá Mundo"];
    [manager globalLinePrint];
    //俄语
    [manager globalLineDrawText:@"Здравствуй, мир"];
    [manager globalLinePrint];
    //韩语
    [manager globalLineDrawText:@"안녕하세요."];
    [manager globalLinePrint];
    //孟加拉语
    [manager globalLineDrawText:@"হ্যালো ওয়া"];
    [manager globalLinePrint];
    //德语
    [manager globalLineDrawText:@"Hallo Welt"];
    [manager globalLinePrint];
    //日语
    [manager globalLineDrawText:@"ハローワールド"];
    [manager globalLinePrint];
    //印地语
    [manager globalLineDrawText:@"हेलो विश्व"];
    [manager globalLinePrint];
    
    //越南语
    [manager globalLineDrawText:@"Chào thế giới"];
    [manager globalLinePrint];
    //丹麦语
    [manager globalLineDrawText:@"Hej, World."];
    [manager globalLinePrint];
    //挪威语
    [manager globalLineDrawText:@"Hallo World"];
    [manager globalLinePrint];
    //意大利语
    [manager globalLineDrawText:@"Ciao, Mondo."];
    [manager globalLinePrint];
}

- (void)printAll {
    [self printText];
    [self drawGraphic];
    [self drawBarCode];
    [self drawQrCode];
    [self drawLine];
    [self drawLineSegments];
}

@end
