//
//  GlobalPagePrinter.m
//  JXPrinterDemo
//
//  Created by 贾俊伟 on 2021/10/19.
//

#import "GlobalPagePrinter.h"

@implementation GlobalPagePrinter

- (instancetype)init {
    if (self = [super init]) {
        self.printWidth = 576;
    }
    return self;
}

- (void)printAll {
    [self drawText];
    [self drawGraphic];
    [self drawBarCode];
    [self drawQrCode];
    [self drawLine];
    [self drawBox];
}

//边框
- (void)drawBox {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:self.printWidth height:400 paperType:0];
    [manager globalDrawTextWithStartX:16 startY:0 endX:self.printWidth endY:30 content:NSLocalizedString(@"BoxPrint", nil)];
    [manager globalDrawBoxWithStartX:0 startY:40 width:510 height:110 lineWidth:2 fullLine:NO];
    [manager globalDrawBoxWithStartX:0 startY:190 width:510 height:110 lineWidth:2 fullLine:YES];
    [manager globalPagePrint:NO times:1];
}

//线条
- (void)drawLine {
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:self.printWidth height:400 paperType:0];
    [manager globalDrawTextWithStartX:8 startY:0 endX:self.printWidth endY:30 content:NSLocalizedString(@"LinePrint", nil)];
    [manager globalDrawLineWithStartX:8 startY:40 endX:200 endY:40 lineWidth:5 fullLine:YES];
    [manager globalDrawLineWithStartX:8 startY:40 endX:8 endY:200 lineWidth:5 fullLine:NO];
    [manager globalPagePrint:NO times:1];
}

//文字
- (void)drawText {
    // Demonstration of multiple national languages
    [self printText1];
    [self printText2];
}

- (void)printText1 {
    int width = self.printWidth;
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:width height:880 paperType:0];
    int y = 0;
    [manager globalTextReset];
    
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Hello World"];
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"你好，世界"];
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Bonjour, le monde"];
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Hola, mundo"];
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Olá Mundo"];
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Здравствуй, мир"];
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"안녕하세요."];
    
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"হ্যালো ওয়া"];
    
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"ハローワールド"];
    
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"हेलो विश्व"];
    
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Chào thế giới"];
    
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Hej, World."];
    
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Hallo World"];
    
    y += 30;
    [manager globalDrawTextWithStartX:16 startY:y endX:width endY:y + 30 content:@"Ciao, Mondo."];
    
    [manager globalPagePrint:NO times:1];
}

- (void)printText2 {
    int width = self.printWidth;
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:width height:880 paperType:0];
    int y = 0;
    [manager globalTextReset];
    [manager globalDrawTextWithStartX:8 startY:y endX:width endY:y+30 content:NSLocalizedString(@"TextDemo", nil)];
    y += 30;
    
    [manager globalTextLineSpace:16];
    NSString *setLineSpace = NSLocalizedString(@"SetLineSpace", nil);
    [manager globalDrawTextWithStartX:8 startY:y endX:width endY:y+100 content:[NSString stringWithFormat:@"%@2mm  first\n%@2mm second",setLineSpace, setLineSpace]];
    y += 80;
    [manager globalTextReset];
    
    NSString *letterSpace = NSLocalizedString(@"SetLetterSpace", nil);
    [manager globalTextLetterSpace:0];
    [manager globalDrawTextWithStartX:8 startY:y endX:270 endY:y + 30 content:[NSString stringWithFormat:@"%@0mm", letterSpace]];
    
    [manager globalTextLetterSpace:8];
    [manager globalDrawTextWithStartX:270 startY:y endX:390 endY:y + 30 content:@"1mm"];
    
    [manager globalTextLetterSpace:16];
    [manager globalDrawTextWithStartX:390 startY:y endX:510 endY:y + 30 content:@"2mm"];
    y += 30;
    [manager globalTextReset];
    
    [manager globalTextIsBold:YES];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextBlod", nil)];
    
    y += 30;
    [manager globalTextReset];
    [manager globalTextIsUnderline:YES];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextUnderLine", nil)];
    y += 30;
    [manager globalTextReset];
    [manager globalTextIsItaly:YES];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextItalics", nil)];
    y += 30;
    [manager globalTextReset];
    [manager globalTextIsReverse:YES];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextReverse", nil)];
    y += 30;
    
    [manager globalTextReset];
    [manager globalTextIsBold:YES];
    [manager globalTextIsUnderline:YES];
    [manager globalTextIsItaly:YES];
    [manager globalTextIsReverse:YES];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextAll", nil)];
    
    y += 30;
    [manager globalTextReset];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextFont", nil)];
    y += 30;
    
    [manager globalTextFontSize:16];
    [manager globalDrawTextWithStartX:8 startY:y + 8 * 4 endX:56 endY:y + 8 * 7 content:@"2mm"];
    
    [manager globalTextFontSize:24];
    [manager globalDrawTextWithStartX:56 startY:y + 8 * 3 endX:128 endY:y + 8 * 7 content:@"3mm"];
    
    [manager globalTextFontSize:32];
    [manager globalDrawTextWithStartX:128 startY:y + 8 * 2 endX:224 endY:y + 8 * 7 content:@"4mm"];
    
    [manager globalTextFontSize:40];
    [manager globalDrawTextWithStartX:224 startY:y + 8 * 1 endX:344 endY:y + 8 * 7 content:@"5mm"];
    
    [manager globalTextFontSize:48];
    [manager globalDrawTextWithStartX:344 startY:y endX:488 endY:y + 8 * 7 content:@"6mm"];
    
    y += 56;
    [manager globalTextFontSize:56];
    [manager globalDrawTextWithStartX:8 startY:y + 8 * 2 endX:176 endY:y + 8 * 10 content:@"7mm"];
    
    [manager globalTextFontSize:64];
    [manager globalDrawTextWithStartX:176 startY:y + 8 * 1 endX:368 endY:y + 8 * 10 content:@"8mm"];
    
    [manager globalTextFontSize:72];
    [manager globalDrawTextWithStartX:368 startY:y endX:584 endY:y + 8 * 10 content:@"9mm"];
    y += 80;
   
    [manager globalTextReset];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextScale", nil)];
    y += 30;
    
    [manager globalTextFontWidthScale:2];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextDoubleWidth", nil)];
    y += 30;
    [manager globalTextReset];
    
    [manager globalTextFontHeightScale:2];
    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 60 content:NSLocalizedString(@"TextDoubleHeight", nil)];
    y += 60;
    [manager globalTextReset];
    

    [manager globalDrawTextWithStartX:8 startY:y endX:350 endY:y + 30 content:NSLocalizedString(@"TextRotate", nil)];
    y += 30;
    
    [manager globalTextRotate:RotationAngle0];
    [manager globalDrawTextWithStartX:8 startY:y endX:168 endY:y + 168 content:NSLocalizedString(@"TextRotate0", nil)];
    [manager globalTextRotate:RotationAngle90];
    [manager globalDrawTextWithStartX:8 startY:y endX:168 endY:y + 168 content:NSLocalizedString(@"TextRotate90", nil)];
    [manager globalTextRotate:RotationAngle180];
    [manager globalDrawTextWithStartX:8 startY:y endX:168 endY:y + 168 content:NSLocalizedString(@"TextRotate180", nil)];
    [manager globalTextRotate:RotationAngle270];
    [manager globalDrawTextWithStartX:8 startY:y endX:168 endY:y + 168 content:NSLocalizedString(@"TextRotate270", nil)];
    [manager globalTextReset];
    
    [manager globalPagePrint:NO times:1];
}

//一维条码
- (void)drawBarCode {
    [self printBarcode1];
    [self printBarcode2];
    [self printBarcode3];
}

- (void)printBarcode2 {
    int width = self.printWidth;
    NSString *type = NSLocalizedString(@"Category", nil);
    NSString *content = NSLocalizedString(@"Content", nil);
    
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:width height:800 paperType:0];
    int y = 0;
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y+30 content:[NSString stringWithFormat:@"%@:UPC_A %@:123456789012", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"123456789012" rotate:RotationAngle0 format:BarcodeFormatUPCA];
    y += 110;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:30 content:[NSString stringWithFormat:@"%@:UPC_E;%@:04029311", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"04029311" rotate:RotationAngle0 format:BarcodeFormatUPCE];
    y += 110;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:EAN_8;%@:12345670", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"12345670" rotate:RotationAngle0 format:BarcodeFormatEan8];
    y += 110;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:EAN_13;%@:1234567890128", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"1234567890128" rotate:RotationAngle0 format:BarcodeFormatEan13];
    y += 110;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:CODE_39;%@:123456789", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"123456789" rotate:RotationAngle0 format:BarcodeFormatCode39];
    
    [manager globalPagePrint:NO times:1];
}
- (void)printBarcode3 {
    int width = self.printWidth;
    NSString *type = NSLocalizedString(@"Category", nil);
    NSString *content = NSLocalizedString(@"Content", nil);
    
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:width height:800 paperType:0];
    int y = 0;
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y+30 content:[NSString stringWithFormat:@"%@:CODE128 %@:123456789", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"123456789" rotate:RotationAngle0 format:BarcodeFormatCode128];
    y += 110;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:CODE_93;%@:123456789", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"123456789" rotate:RotationAngle0 format:BarcodeFormatCode93];
    y += 110;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:CODABAR;%@:123456789", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"123456789" rotate:RotationAngle0 format:BarCodeFormatCodabar];
    y += 110;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:ITF;%@:1234567890", type, content]];
    y += 35;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:300 height:100 content:@"1234567890" rotate:RotationAngle0 format:BarcodeFormatITF];
    
    [manager globalPagePrint:NO times:1];
}

- (void)printBarcode1 {
    int width = self.printWidth;
    NSString *type = NSLocalizedString(@"Category", nil);
    NSString *content = NSLocalizedString(@"Content", nil);
    
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:width height:800 paperType:0];
    int y = 0;
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y+70 content:[NSString stringWithFormat:@"%@:CODE128 %@:0123456789\n%@", type, content, NSLocalizedString(@"BarcodeNoText", nil)]];
    y += 70;
    [manager globalDrawBarCodeWithStartX:8 startY:y width:200 height:50 content:@"0123456789" rotate:RotationAngle0 format:BarcodeFormatCode128];
    y += 90;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y+30 content:NSLocalizedString(@"BarcodeTextBelow", nil)];
    y += 35;
    [manager globalSetBarcodeTextWithIsPositionBelow:YES fontSize:24 isBold:NO margin:0 breakLine:YES];
    [manager globalDrawBarCodeWithStartX:8 startY:y width:200 height:50 content:@"0123456789" rotate:RotationAngle0 format:BarcodeFormatCode128];
    y += 130;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y+30 content:NSLocalizedString(@"BarcodeTextUp", nil)];
    y += 35;
    [manager globalSetBarcodeTextWithIsPositionBelow:NO fontSize:24 isBold:YES margin:0 breakLine:YES];
    [manager globalDrawBarCodeWithStartX:8 startY:y width:200 height:50 content:@"0123456789" rotate:RotationAngle0 format:BarcodeFormatCode128];
    y += 130;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y+60 content:[NSString stringWithFormat:@"%@90，180，270", NSLocalizedString(@"bar_Rotate270", nil)]];
    y += 65;
    [manager globalSetBarcodeTextWithIsPositionBelow:YES fontSize:24 isBold:NO margin:0 breakLine:YES];
    [manager globalDrawBarCodeWithStartX:8 startY:y width:220 height:60 content:@"0123456789" rotate:RotationAngle90 format:BarcodeFormatCode128];
    
    [manager globalSetBarcodeTextWithIsPositionBelow:YES fontSize:24 isBold:NO margin:0 breakLine:YES];
    [manager globalDrawBarCodeWithStartX:110 startY:y width:220 height:60 content:@"0123456789" rotate:RotationAngle180 format:BarcodeFormatCode128];
    
    [manager globalSetBarcodeTextWithIsPositionBelow:YES fontSize:24 isBold:NO margin:0 breakLine:YES];
    [manager globalDrawBarCodeWithStartX:350 startY:y width:220 height:60 content:@"0123456789" rotate:RotationAngle270 format:BarcodeFormatCode128];
    
    [manager globalPagePrint:NO times:1];
}

//二维码
- (void)drawQrCode {
    int width = self.printWidth;
    NSString *type = NSLocalizedString(@"Category", nil);
    NSString *content = NSLocalizedString(@"Content", nil);
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:width height:880 paperType:0];
    int y = 0;
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 60 content:[NSString stringWithFormat:@"%@:QR_CODE;%@:1234567890", type, content]];
    y += 60;
    [manager globalDrawQrCodeWithStartX:8 startY:y width:150 height:150 content:@"1234567890" rotate:RotationAngle0 format:QRCodeFormatQR];
    y += 150;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:PDF_417;%@:1234567890", type, content]];
    y += 30;
    [manager globalDrawQrCodeWithStartX:8 startY:y width:200 height:100 content:@"1234567890" rotate:RotationAngle0 format:QRCodeFormatPDF417];
    y += 150;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:DATA_MATRIX;%@:1234567890", type, content]];
    y += 40;
    [manager globalDrawQrCodeWithStartX:8 startY:y width:150 height:150 content:@"1234567890" rotate:RotationAngle0 format:QRCodeFormatDataMatrix];
    y += 150;
    
    [manager globalDrawTextWithStartX:8 startY:y endX:500 endY:y + 30 content:[NSString stringWithFormat:@"%@:AZTEC;%@:1234567890", type, content]];
    y += 40;
    [manager globalDrawQrCodeWithStartX:8 startY:y width:150 height:150 content:@"1234567890" rotate:RotationAngle0 format:QRCodeFormatAztec];
    
    [manager globalPagePrint:NO times:1];
}

//图片
- (void)drawGraphic {
    int width = self.printWidth;
    JXPrinterManager *manager = [JXPrinterManager printerManagerWithConnectType:self.connectType];
    [manager globalPageSetUpWidth:width height:880 paperType:0];
    [manager globalDrawTextWithStartX:8 startY:0 endX:width endY:30 content:NSLocalizedString(@"ImagePrint", nil)];
    
    UIImage *image = [UIImage imageNamed:@"logo"];
    [manager globalDrawGraphicWithStartX:8 startY:30 image:image];
    [manager globalDrawGraphicWithStartX:(width-image.size.width)/2+8 startY:180 image:image];
    [manager globalDrawGraphicWithStartX:(width-image.size.width)-8 startY:330 image:image];
    [manager globalPagePrint:NO times:1];
}

@end
