//
//  DeviceListController.m
//  JXPrinterDemo
//
//  Created by 贾俊伟 on 2021/10/18.
//

#import "DeviceListController.h"
#import "BluetoothDeviceController.h"
#import "TcpDeviceController.h"

@interface DeviceListController ()

@property (nonatomic, strong) BluetoothDeviceController *bleController;
@property (nonatomic, strong) TcpDeviceController *tcpController;
@end

@implementation DeviceListController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    [self addChildViewController:self.bleController];
    [self.view addSubview:self.bleController.view];
    [self titleView];
    [self.view bringSubviewToFront:self.bleController.view];
}

- (void)titleView {
    UISegmentedControl *titleView = [[UISegmentedControl alloc] initWithItems:@[@"BLE", @"TCP"]];
    titleView.frame = CGRectMake(0, 0, 200, 30);
    titleView.selectedSegmentIndex = 0;
    [titleView addTarget:self action:@selector(segmentSelected:) forControlEvents:UIControlEventValueChanged];
    [self.navigationItem setTitleView:titleView];
}

-(void)segmentSelected:(UISegmentedControl *)sender{
    switch (sender.selectedSegmentIndex) {
        case 0: {
            [self.view bringSubviewToFront:self.bleController.view];
        }
            break;
            
        case 1: {
            if (!_tcpController) {
                [self addChildViewController:self.tcpController];
                [self.view addSubview:self.tcpController.view];
            }
            [self.view bringSubviewToFront:self.tcpController.view];
        }
            break;
    }
}

#pragma mark - Getter

- (BluetoothDeviceController *)bleController {
    if (!_bleController) {
        _bleController = [[BluetoothDeviceController alloc] init];
    }
    return _bleController;
}

- (TcpDeviceController *)tcpController {
    if (!_tcpController) {
        _tcpController = [[TcpDeviceController alloc] init];
    }
    return _tcpController;
}

@end

