//
//  ESCController.m
//  JXPrinterDemo
//
//  Created by 贾俊伟 on 2022/6/22.
//

#import "ESCController.h"
#import <JXPrinter/JXPrinter.h>
#import "DeviceListController.h"
#import "CmdModel.h"
#import "ESCPrinter.h"
#import "JXProgressHUD.h"

@interface ESCController ()<
UITableViewDelegate,
UITableViewDataSource
>

@property (nonatomic, strong) UIButton *rightBarButton;
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray<NSString *> *headerArray;
@property (nonatomic, strong) NSMutableArray<NSArray<CmdModel *> *> *dataArray;
@property (nonatomic, strong) ESCPrinter *esc;
@property (nonatomic, strong) CBPeripheral *peripheral;

@end

@implementation ESCController

static NSString * const itemId = @"item";

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"ESC";
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.rightBarButton];
    [self.view addSubview:self.tableView];
    self.tableView.tableFooterView = [UIView new];
    // show log
    [JXBleManager setLogEnable:YES];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    NSString *title = [JXBleManager bleManager].isConnectBle || [JXSocketManager manager].isConnected ? NSLocalizedString(@"Connected", nil) : NSLocalizedString(@"Scan", nil);
    [self.rightBarButton setTitle:title forState:UIControlStateNormal];
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    self.tableView.frame = CGRectMake(10, 0, [UIScreen mainScreen].bounds.size.width-10, [UIScreen mainScreen].bounds.size.height);
}

#pragma mark - UITableViewDelegate, UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.dataArray.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArray[section].count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:itemId forIndexPath:indexPath];
    cell.textLabel.text = self.dataArray[indexPath.section][indexPath.row].cmdName;
    cell.textLabel.font = [UIFont systemFontOfSize:14];
    cell.textLabel.textColor = [UIColor colorWithWhite:0 alpha:0.7];
    cell.imageView.image = [UIImage imageNamed:self.dataArray[indexPath.section][indexPath.row].imageName];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    // 判断当前是否连接打印机
    if (![JXBleManager bleManager].isConnectBle && ![JXSocketManager manager].isConnected) {
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:NSLocalizedString(@"Warning", nil) message:NSLocalizedString(@"Unconnected", nil) preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction *done = [UIAlertAction actionWithTitle:NSLocalizedString(@"Confirm", nil) style:UIAlertActionStyleDefault handler:nil];
        [alert addAction:done];
        [self presentViewController:alert animated:YES completion:nil];
        return;
    }
    JXConnectType type = [JXSocketManager manager].isConnected ? JXConnectTypeTcp : JXConnectTypeBle;
    self.esc.connectType = type;
    
    CmdModel *model = self.dataArray[indexPath.section][indexPath.row];
    if ([model.target respondsToSelector:model.action]) {
        [model.target performSelector:model.action];
    }
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    UILabel *titleLb = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, 40)];
    titleLb.backgroundColor = [UIColor whiteColor];
    titleLb.text = self.headerArray[section];
    titleLb.textColor = [UIColor blackColor];
    titleLb.font = [UIFont systemFontOfSize:16];
    return titleLb;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    return 40;
}

#pragma mark - Click

- (void)rightBarButtonClick {
    DeviceListController *listVC = [[DeviceListController alloc] init];
    [self.navigationController pushViewController:listVC animated:YES];
}

#pragma mark - Getter

- (UIButton *)rightBarButton {
    if (!_rightBarButton) {
        _rightBarButton = [[UIButton alloc] init];
        _rightBarButton.titleLabel.font = [UIFont systemFontOfSize:14];
        [_rightBarButton setTitle:NSLocalizedString(@"Scan", nil) forState:UIControlStateNormal];
        [_rightBarButton setTitleColor:[UIColor grayColor] forState:UIControlStateNormal];
        [_rightBarButton addTarget:self action:@selector(rightBarButtonClick) forControlEvents:UIControlEventTouchUpInside];
    }
    return _rightBarButton;
}

- (UITableView *)tableView {
    if (!_tableView) {
        _tableView = [[UITableView alloc] init];
        _tableView.delegate = self;
        _tableView.dataSource = self;
        [_tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:itemId];
    }
    return _tableView;
}

- (NSMutableArray<NSString *> *)headerArray {
    if (!_headerArray) {
        _headerArray = [[NSMutableArray alloc] init];
    }
    return _headerArray;
}

- (NSMutableArray<NSArray<CmdModel *> *> *)dataArray {
    if (!_dataArray) {
        _dataArray = [[NSMutableArray alloc] init];
       
        NSString *comprehensive = NSLocalizedString(@"Comprehensive", nil);
        NSString *text = NSLocalizedString(@"Text", nil);
        NSString *barcode = NSLocalizedString(@"Barcode", nil);
        NSString *QRCode = NSLocalizedString(@"QRCode", nil);
        NSString *image = NSLocalizedString(@"image", nil);
        NSString *setting = NSLocalizedString(@"setting", nil);
        
        // image names
        NSString *allImage = @"all";
        NSString *textImage = @"text";
        NSString *barcodeImage = @"barcode";
        NSString *qrcodeImage = @"qrcode";
        NSString *imageImage = @"image";
        NSString *settingImage = @"setting";
        
        NSArray<CmdModel *> *pageCmds = @[
            [CmdModel modelWithCmdName:comprehensive imageName:allImage target:self.esc action:@selector(printAll)],
            [CmdModel modelWithCmdName:text imageName:textImage target:self.esc action:@selector(drawText)],
            [CmdModel modelWithCmdName:image imageName:imageImage target:self.esc action:@selector(drawGraphic)],
            [CmdModel modelWithCmdName:barcode imageName:barcodeImage target:self.esc action:@selector(drawBarCode)],
            [CmdModel modelWithCmdName:QRCode imageName:qrcodeImage target:self.esc action:@selector(drawQrCode)],
            [CmdModel modelWithCmdName:setting imageName:settingImage target:self.esc action:@selector(printSetting)],
        ];
        [_dataArray addObject:pageCmds];
        [self.headerArray addObject:@"ESC"];
    }
    return _dataArray;
}

- (ESCPrinter *)esc {
    if (!_esc) {
        _esc = [[ESCPrinter alloc] init];
    }
    return _esc;
}

@end
