//
//  JXPrinterEnums.h
//  Runner
//
//  Created by 贾俊伟 on 2021/6/17.
//

#ifndef JXPrinterEnums_h
#define JXPrinterEnums_h

typedef NS_ENUM(NSInteger, PrintStatus) {
    PrintStatusNoPaper = 0x01,      // 缺纸
    PrintStatusOverHeat = 0x02,     // 打印头过热
    PrintStatusBatteryLow = 0x04,   // 电量低
    PrintStatusPrinting = 0x08,     // 正在打印中
    PrintStatusCoverOpen = 0x10,    // 纸仓盖未关闭
    PrintStatusNoError,             // 其他值，没有错误
    PrintStatusOk,                  // 打印完毕
};

typedef NS_ENUM(NSInteger, JXPrinterInfoType) {
    //01序列号 “90021905010001”
    JXPrinterInfoTypeSerialCode = 0x01,
    //02生产日期 “2018-12-02”
    JXPrinterInfoTypeProduceDate = 0x02,
    //03宣传网址 “http://www.jiexinit.cn”
    JXPrinterInfoTypeWebsite = 0x03,
    //04产品品牌 “JXIT”
    JXPrinterInfoTypeBrand = 0x04,
    //05产品型号 “X30”
    JXPrinterInfoTypeModel = 0x05,
    //06 屏幕显示语言 0：中文， 1 ：英语
    JXPrinterInfoTypeLanguage = 0x06,
    //0B蓝牙名称 “X30”
    JXPrinterInfoTypeBlueThoothName = 0x0B,
    // 0C 配对密码 “0000”
    JXPrinterInfoTypeBlueThoothPwd = 0x0C,
    // 0D 密码使能 大于0使用配对码，等于 0配对不需要配对码
    JXPrinterInfoTypeBlueThoothPwdEnabled = 0x0D,
    //10 后缀使能，大于0 蓝牙名称加Mac地址后缀，等于 0 不加后缀
    JXPrinterInfoTypeBlueThoothSuffixEnabled = 0x10,
    //11 一对多 0:打开 1:关闭
    JXPrinterInfoTypeBlueThoothOneToManyEnabled = 0x11,
    //12 微信功能 0:关闭 1:打开
    JXPrinterInfoTypeBlueThoothWXEnabled = 0x12,
    //15 打印黑度 0~4
    JXPrinterInfoTypeBlackness = 0x15,
    //16 打印质量 0~2
    JXPrinterInfoTypeQuality = 0x16,
    //1F WiFi名称 “JXIT”
    JXPrinterInfoTypeWifiName = 0x1F,
    //20 WiFi密码 “4000666353”
    JXPrinterInfoTypeWifiPwd = 0x20,
    //21 WiFi静态IP “192.168.1.155”
    JXPrinterInfoTypeWifiIP = 0x21,
    //22 WiFi子网掩码 “255.255.255.0”
    JXPrinterInfoTypeWifiSubnetMask = 0x22,
    //23 WiFi网关 “192.168.1.1”
    JXPrinterInfoTypeWifiGateway = 0x23,
    //24 WiFiNDS “192.168.1.1”
    JXPrinterInfoTypeWifiDNS = 0x24,
    //25 WiFi加密类型 0~2 0：OPEN 1：WAP/WAP2 2WEP
    JXPrinterInfoTypeWifiEncryption = 0x25,
    //26  WiFi自动获取IP 0~1 0：静态IP，需设置静态IP 1：自动获取IP ，无需设置
    JXPrinterInfoTypeWifiIpType = 0x26,
    //27  子网掩码使能 0~1 0：无需设置子网掩码 1：需设置子网掩码
    JXPrinterInfoTypeWifiSubnetMaskEnabled = 0x27,
    //28  网关使能 0~1 0：无需设置网关 1：需设置网关
    JXPrinterInfoTypeWifiGatewayEnabled = 0x28,
    //29  DNS使能 0~1 0：无需设置DNS 1：需设置DNS
    JXPrinterInfoTypeWifiDNSEnabled = 0x29,
    //2A 端口号 0~65535
    JXPrinterInfoTypePortNumber = 0x2A,
};

typedef NS_ENUM(NSInteger, JXConnectType) {
    JXConnectTypeBle = 0, ///< 蓝牙
    JXConnectTypeTcp      ///< Wi-Fi
};

//esc：esc图片指令
//cpcl：cpcl图片指令
//tspl：tspl图片指令
//jxcps:匠辛压缩图片指令
//jxpl:匠辛标签指令，原果酱指令

typedef NS_ENUM(NSInteger, JXCmdType) {
    JXCmdTypeESC = 0,
    JXCmdTypeTSPL,
    JXCmdTypeCPCL,
    JXCmdTypeJXCPS,
    JXCmdTypeJXPL,
};

typedef NS_ENUM(NSInteger, BarCodeFormat) {
    
    /** CODABAR 1D format. */
    BarCodeFormatCodabar = 0,

    /** Code 39 1D format. */
    BarcodeFormatCode39,

    /** Code 93 1D format. */
    BarcodeFormatCode93,

    /** Code 128 1D format. */
    BarcodeFormatCode128,
    
    /** EAN-8 1D format. Contents should be 7 or 8 digits long */
    BarcodeFormatEan8,

    /** EAN-13 1D format. Contents should be 12 or 13 digits long */
    BarcodeFormatEan13,

    /** ITF (Interleaved Two of Five) 1D format. */
    BarcodeFormatITF,
    
    /** UPC-A 1D format. */
    BarcodeFormatUPCA,

    /** UPC-E 1D format. Contents should be 7 or 8 digits long */
    BarcodeFormatUPCE,
};

typedef NS_ENUM(NSInteger, QRCodeFormat) {
    QRCodeFormatQR,
    QRCodeFormatPDF417,
    QRCodeFormatAztec,
    QRCodeFormatDataMatrix,
};

typedef NS_ENUM(NSInteger, RotationAngle) {
    RotationAngle0 = 0,
    RotationAngle90 = 90,
    RotationAngle180 = 180,
    RotationAngle270 = 270,
};

#endif /* JXPrinterEnums_h */
