//
//  PeripheralInfoCell.m
//  JXPrinter
//
//  Created by 贾俊伟 on 2021/3/26.
//

#import "PeripheralInfoCell.h"
#import "PeripheralModel.h"

@interface PeripheralInfoCell ()

@property (weak, nonatomic) IBOutlet UILabel *nameLb;
@property (weak, nonatomic) IBOutlet UILabel *addressLb;
@property (weak, nonatomic) IBOutlet UIButton *statusBtn;

@end

@implementation PeripheralInfoCell

- (void)setModel:(PeripheralModel *)model {
    _model = model;
    self.nameLb.text = model.peripheral.name.length > 0 ? model.peripheral.name: @"name未知";
    self.addressLb.text = model.address;
    self.statusBtn.selected = model.isSelected;
}

- (IBAction)connectBtnClick:(UIButton *)sender {
    if (self.connectBlock) {
        self.connectBlock(self.model.isSelected);
    }
}

@end
