/*
 * Copyright 2014 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#import <Foundation/Foundation.h>

@class ZXBitArray, ZXByteArray;

@interface ZXAztecToken : NSObject

@property (nonatomic, strong, readonly) ZXAztecToken *previous;

- (id)initWithPrevious:(ZXAztecToken *)previous;
+ (ZXAztecToken *)empty;
- (ZXAztecToken *)add:(int)value bitCount:(int)bitCount;
- (ZXAztecToken *)addBinaryShift:(int)start byteCount:(int)byteCount;
- (void)appendTo:(ZXBitArray *)bitArray text:(ZXByteArray *)text;

@end
