//
//  ViewController.m
//  JXPrinterDemo
//
//  Created by 贾俊伟 on 2021/10/18.
//

#import "ViewController.h"
#import <JXPrinter/JXPrinter.h>
#import "GlobalController.h"
#import "CPCLController.h"
#import "ESCController.h"

@interface ViewController ()

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"JXIT SDK Demo";
    if (@available(iOS 15.0, *)) {
        UINavigationBarAppearance *barApp = [UINavigationBarAppearance new];
        barApp.backgroundColor = [UIColor whiteColor];
        barApp.shadowColor = [UIColor whiteColor];
        self.navigationController.navigationBar.scrollEdgeAppearance = barApp;
        self.navigationController.navigationBar.standardAppearance = barApp;
    }
    self.view.backgroundColor = [UIColor whiteColor];

    // 模拟网络请求，以弹窗提示是否使用网络数据，搜索Wi-Fi设备需要使用无线数据权限
    NSURL *url = [NSURL URLWithString:@"https://www.baidu.com"];
    NSURLRequest *request =[NSURLRequest requestWithURL:url];
    NSURLSession *session = [NSURLSession sharedSession];
    NSURLSessionDataTask *sessionDataTask = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        
    }];
    [sessionDataTask resume];
    
    // show log
    [JXBleManager setLogEnable:YES];
    
    CGFloat width = 200;
    CGFloat height = 80;
    CGFloat x = ([UIScreen mainScreen].bounds.size.width - width) / 2.0;
    [self addCmdBtnWithFrame:CGRectMake(x, 150, width, height)
                       title:@"Global"
                      action:@selector(jumpToGlobalController)];
    [self addCmdBtnWithFrame:CGRectMake(x, 300, width, height)
                       title:@"CPCL"
                      action:@selector(jumpToCPCLController)];
    [self addCmdBtnWithFrame:CGRectMake(x, 450, width, height)
                       title:@"ESC"
                      action:@selector(jumpToESCController)];
}

- (void)addCmdBtnWithFrame:(CGRect)frame title:(NSString *)title action:(SEL)action {
    UIButton *cmdBtn = [[UIButton alloc] initWithFrame:frame];
    [self.view addSubview:cmdBtn];
    [cmdBtn setTitle:title forState:UIControlStateNormal];
    [cmdBtn setBackgroundColor:[UIColor colorWithRed:64/255.0 green:142/255.0 blue:245/255.0 alpha:1]];
    [cmdBtn addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
}

- (void)jumpToGlobalController {
    GlobalController *global = [[GlobalController alloc] init];
    [self.navigationController pushViewController:global animated:YES];
}

- (void)jumpToCPCLController {
    CPCLController *cpcl = [[CPCLController alloc] init];
    [self.navigationController pushViewController:cpcl animated:YES];
}

- (void)jumpToESCController {
    ESCController *esc = [[ESCController alloc] init];
    [self.navigationController pushViewController:esc animated:YES];
}

@end
