//
//  JXSocketManager.h
//  JXPrinter
//
//  Created by 贾俊伟 on 2021/8/5.
//

#import <Foundation/Foundation.h>
#import "JXPrinterEnums.h"

NS_ASSUME_NONNULL_BEGIN

typedef void (^JXSocketWriteStatusBlock)(BOOL success);

@class JXSocketManager;
@protocol JXSocketManagerDelegate <NSObject>

@optional

/// 扫描

/// 扫描到的设备信息
/// @param manager JXSocketManager
/// @param ip 设备的ip地址
/// @param port 设备创建的tcp server的端口号
/// @param mfg 设备厂商英文
/// @param model 设备型号英文
/// @param cmd 设备支持的指令 esc：esc图片指令 cpcl：cpcl图片指令 tspl：tspl图片指令 jxcps:匠辛压缩图片指令 jxpl:匠辛标签指令，原果酱指令
- (void)manager:(JXSocketManager *)manager scanDidFindNewIP:(NSString *)ip
           port:(int)port
            mfg:(NSString *)mfg
          model:(NSString *)model
            cmd:(NSString *)cmd;
- (void)scanDidFinish:(JXSocketManager *)manager;

/// 连接、读写
- (void)connectTimeout:(JXSocketManager *)manager;
- (void)manager:(JXSocketManager *)manager didConnectToHost:(NSString *)host port:(uint16_t)port;
- (void)manager:(JXSocketManager *)manager didDisconnectwithError:(nullable NSError *)err;
- (void)manager:(JXSocketManager *)manager didWriteDataWithTag:(long)tag;
- (void)manager:(JXSocketManager *)manager timeoutWriteWithTag:(long)tag;
- (void)manager:(JXSocketManager *)manager didReadData:(NSData *)data withTag:(long)tag;
- (void)manager:(JXSocketManager *)manager timeoutReadWithTag:(long)tag;

@end

@interface JXSocketManager : NSObject

@property (nonatomic, readonly) BOOL isScanning;
@property (nonatomic, readonly) BOOL isConnected;
@property (nonatomic,     weak) id <JXSocketManagerDelegate> delegate;

+ (instancetype)manager;

- (BOOL)WiFiEnable;

/// 扫描
- (void)startScanWithTimeout:(NSTimeInterval)timeout;

- (void)stopScan;

/// 连接、读写
- (BOOL)connectToIPAddress:(NSString*)IPAddress
                    onPort:(uint16_t)port
                   timeout:(NSTimeInterval)timeout;

- (void)disconnect;

- (void)writeData:(NSData *)data
          timeout:(NSTimeInterval)timeout
              tag:(long)tag
      writeStatus:(nullable JXSocketWriteStatusBlock)block;

- (void)readDataWithTimeout:(NSTimeInterval)timeout tag:(long)tag;

- (void)writeData:(NSData *)data
          timeout:(NSTimeInterval)timeout
              tag:(long)tag
         response:(void (^)(NSData *data))response;

- (NSData *)writeData:(NSData *)data
              timeout:(NSTimeInterval)timeout
                  tag:(long)tag;

- (void)flushReadBuffer;

/**
 读取打印机状态
 */
- (void)readPrinterStatus:(NSTimeInterval)timeout success:(void (^)(PrintStatus blePrintStatus))success fail:(void (^)(void))fail;

@end

NS_ASSUME_NONNULL_END
