/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.model;

import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXParser;
import java.util.Arrays;

public class JXPrinterConfigInfo
implements JXParser {
    public static final int ID_SERIAL_CODE = 1;
    public static final int ID_PRODUCE_DATE = 2;
    public static final int ID_WEBSITE = 3;
    public static final int ID_BRAND = 4;
    public static final int ID_MODEL = 5;
    public static final int ID_LANGUAGE = 6;
    public static final int ID_BLUETOOTH_NAME = 11;
    public static final int ID_BLUETOOTH_PAIR_PWD = 12;
    public static final int ID_BLUETOOTH_PAIR_PWD_ENABLED = 13;
    public static final int ID_BLUETOOTH_SUFFIX_ENABLED = 16;
    public static final int ID_ONE_TO_MANY_ENABLED = 17;
    public static final int ID_ONE_TO_WX_ENABLED = 18;
    public static final int ID_PRINT_BLACKNESS = 21;
    public static final int ID_PRINT_QUALITY = 22;
    public static final int ID_WIFI_NAME = 31;
    public static final int ID_WIF_PWD = 32;
    public static final int ID_WIFI_IP = 33;
    public static final int ID_WIFI_SUBNET_MASK = 34;
    public static final int ID_WIFI_GATEWAY = 35;
    public static final int ID_WIFI_DNS = 36;
    public static final int ID_WIFI_ENCRYPTION_TYPE = 37;
    public static final int ID_WIFI_IP_TYPE = 38;
    public static final int ID_WIFI_SUBNET_MASK_ENABLED = 39;
    public static final int ID_WIFI_GATEWAY_ENABLED = 40;
    public static final int ID_WIFI_DNS_ENABLED = 41;
    public static final int ID_PORT_NUMBER = 42;
    public String value;
    static final int[] INT_VALUE_RETURN_IDS = new int[]{6, 13, 16, 17, 18, 21, 22, 37, 38, 39, 40, 41, 42};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean parse(byte[] data) {
        if (data == null || data.length == 0) {
            JXLog.e("JXPrinterConfigInfo", "bad param");
            return false;
        }
        try {
            int lengthIndex = 4;
            int valueOffset = 5;
            int length = this.byte2Int(data[4]);
            int id = this.byte2Int(data[2]);
            if (!this.isIntReturnID(id)) {
                byte[] bytes = Arrays.copyOfRange(data, 5, 5 + length);
                this.value = new String(bytes, "GBK");
                return true;
            }
            if (length == 1) {
                int v = this.byte2Int(data[5]);
                this.value = String.valueOf(v);
                return true;
            }
            if (length != 2 && length != 4) {
                JXLog.e("JXPrinterConfigInfo", "id = " + id + " but response data length is not supported with length " + length);
                return false;
            }
            int v = this.bytes2Int(data, 5, length == 2);
            this.value = String.valueOf(v);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e("JXPrinterConfigInfo", "parse data exception " + e.getMessage());
            return false;
        }
    }

    public byte[] createCommand(int id, String value) {
        try {
            if (this.isIntReturnID(id)) {
                int intValue = Integer.parseInt(value);
                byte[] cmd = new byte[]{16, 2, (byte)id, 87, 4, (byte)(intValue & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 24 & 0xFF)};
                return cmd;
            }
            int cmd_footer_length = 2;
            byte[] vBytes = value.getBytes("GBK");
            byte[] cmd_header = new byte[]{16, 2, (byte)id, 87, (byte)vBytes.length};
            byte[] cmd = Arrays.copyOf(cmd_header, cmd_header.length + vBytes.length + 2);
            System.arraycopy(vBytes, 0, cmd, cmd_header.length, vBytes.length);
            return cmd;
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e("JXPrinterConfigInfo", "createCommand  exception " + e.getMessage());
            return null;
        }
    }

    boolean isIntReturnID(int id) {
        for (int _id : INT_VALUE_RETURN_IDS) {
            if (_id != id) continue;
            return true;
        }
        return false;
    }
}

