/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.model;

import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXParser;
import com.jxit.printer.utils.SDKUtil;
import java.util.Random;

public class JXTransportRate
implements JXParser {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_WRITE_TIMEOUT = 1;
    public static final int ERROR_READ_TIMEOUT = 2;
    public static final int ERROR_PARSE_FAIL = 3;
    public static final int ERROR_EXCEPTION = 4;
    private byte[] randomNum;
    private boolean isRandom = true;

    @Override
    public boolean parse(byte[] data) {
        if (data == null || data.length < 4) {
            JXLog.e("JXCommunicationStability", "bad param");
            return false;
        }
        try {
            byte id = data[2];
            if (id == 0) {
                for (int i = 0; i < this.randomNum.length; ++i) {
                    if (this.randomNum[i] == data[4 + i]) continue;
                    JXLog.d_bytes("JXCommunicationStability", "index=" + i + ",expect " + (this.randomNum[i] & 0xFF) + ",but get " + (data[i + 4] & 0xFF), data);
                    return false;
                }
                return true;
            }
            if (id == 1) {
                if (data[0] == 16 && data[4] != 0) {
                    JXLog.d_bytes("JXCommunicationStability", "expect 1005010100,but get data", data);
                    return false;
                }
                return true;
            }
            if (id == 2) {
                int expectCrc;
                int crc = this.bytes2Int(data, 4, true);
                if (crc != (expectCrc = SDKUtil.crc(this.randomNum))) {
                    JXLog.d_bytes("JXCommunicationStability", "expect crc =" + expectCrc + ",but get crc=" + crc, data);
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e("JXCommunicationStability", "parse exception" + e.getMessage());
            return false;
        }
    }

    public void setDataSourceType(boolean isRandom) {
        this.isRandom = isRandom;
    }

    public byte[] createCommand(int id, int length, JXInterfaceAPI api) {
        byte[] cmd;
        this.randomNum = new byte[length];
        if (this.isRandom) {
            Random r = new Random();
            for (int i = 0; i < this.randomNum.length; ++i) {
                int n = r.nextInt(255);
                this.randomNum[i] = (byte)n;
            }
        } else {
            for (int i = 0; i < this.randomNum.length; ++i) {
                this.randomNum[i] = (byte)i;
            }
        }
        if (id == 1) {
            cmd = new byte[this.randomNum.length + 6 + 1];
            int crc = SDKUtil.crc(this.randomNum);
            cmd[cmd.length - 3] = (byte)(crc & 0xFF);
            cmd[cmd.length - 2] = (byte)(crc >> 8 & 0xFF);
            cmd[cmd.length - 1] = 0;
        } else if (id == 0 || id == 2) {
            cmd = new byte[this.randomNum.length + 4 + 1];
        } else {
            JXLog.e("JXCommunicationStability", "id = " + id + " is not support");
            return null;
        }
        System.arraycopy(this.randomNum, 0, cmd, 4, this.randomNum.length);
        cmd[0] = 16;
        cmd[1] = 5;
        cmd[2] = (byte)id;
        cmd[3] = (byte)(this.randomNum.length + (id == 1 ? 2 : 0));
        cmd[cmd.length - 1] = 0;
        return cmd;
    }
}

