/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxapi;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.jxit.printer.jxapi.DeviceUUID;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxapi.UnlockCmd;
import com.jxit.printer.jxsdk.JXLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@RequiresApi(api=18)
public class JXBleAPI
implements JXInterfaceAPI {
    private static final String TAG = JXBleAPI.class.getSimpleName();
    private Context context;
    public static final int STATE_OFF = 10;
    public static final int STATE_NONE = 200;
    public static final int STATE_CONNECTING = 202;
    public static final int STATE_CONNECTED = 203;
    public static final int STATE_BAD_CONNECT = 133;
    private int connectState;
    private boolean btSupport;
    private BluetoothAdapter btAdapter;
    private BluetoothDevice btDevice;
    private static volatile JXBleAPI mDefault = null;
    public static final int MAX_TIMEOUT = 50000;
    public static final int MIN_TIMEOUT = 200;
    private String mConnectedAddress;
    private BluetoothGatt mGatt;
    private static int maxPacketSize = 20;
    private static int preferMtu = 185;
    public static int sendDelay = 50;
    private BLE_Connection ble_connection = new BLE_Connection();
    private BleDataCache mReader = new BleDataCache();
    private int mUnlockType = 0;
    private LeScanWatchdog mScanWatchdog = new LeScanWatchdog();
    private BluetoothAdapter.LeScanCallback userScanCallback;
    private BluetoothAdapter.LeScanCallback mScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            if (JXBleAPI.this.userScanCallback != null) {
                JXBleAPI.this.userScanCallback.onLeScan(device, rssi, scanRecord);
            }
        }
    };
    @SuppressLint(value={"MissingPermission"})
    private BluetoothGattCallback mCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            JXLog.d(TAG, "onConnectionStateChange status = " + status + "_newState = " + newState);
            if (JXBleAPI.this.mGatt != null && JXBleAPI.this.mGatt.equals(gatt) && newState == 2) {
                JXBleAPI.this.setConnectState(202);
                JXLog.d(TAG, "connect to GATT service.");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                JXBleAPI.this.mGatt.discoverServices();
            } else if (JXBleAPI.this.mGatt != null && JXBleAPI.this.mGatt.equals(gatt) && newState == 0) {
                if (status == 133) {
                    JXBleAPI.this.setConnectState(133);
                } else {
                    JXBleAPI.this.setConnectState(200);
                }
                JXLog.d(TAG, "disconnect to GATT service.");
            } else {
                if (newState == 2 || newState == 0) {
                    JXLog.d(TAG, "close last gatt not closed");
                } else {
                    JXLog.e(TAG, "force stop when otherState = " + newState);
                    JXBleAPI.this.clearCache(gatt);
                }
                JXBleAPI.this.closeConnection(gatt);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            JXLog.d(TAG, "onServicesDiscovered status = " + status);
            if (JXBleAPI.this.mGatt != null && JXBleAPI.this.mGatt.equals(gatt) && status == 0) {
                boolean requestMtu;
                if (Build.VERSION.SDK_INT >= 21 && !(requestMtu = gatt.requestMtu(preferMtu))) {
                    JXLog.e(TAG, "request mtu failed, current mtu = " + maxPacketSize);
                }
            } else {
                JXLog.e(TAG, "onServicesDiscovered received: " + status);
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            super.onMtuChanged(gatt, mtu, status);
            JXLog.d(TAG, "onMtuChanged, mtu = " + mtu + " ,status= " + status);
            if (0 == status) {
                if (mtu > preferMtu) {
                    maxPacketSize = preferMtu - 3;
                } else {
                    maxPacketSize = mtu - 3;
                }
                JXLog.d(TAG, "set mtu success, maxPackageSize = " + maxPacketSize);
                JXBleAPI.this.ble_connection.reset();
                if (JXBleAPI.this.ble_connection.findServices(gatt) && JXBleAPI.this.ble_connection.startNotify()) {
                    JXBleAPI.this.setConnectState(203);
                } else {
                    JXBleAPI.this.closeConnection();
                }
            } else {
                JXLog.e(TAG, "set mtu failed , status = " + status + " mtu = " + mtu);
                maxPacketSize = 20;
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (JXBleAPI.this.mGatt == null) {
                return;
            }
            JXLog.d_bytes(TAG, "onCharacteristicWrite___status= " + status, characteristic.getValue());
            super.onCharacteristicWrite(gatt, characteristic, status);
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            byte[] v = characteristic.getValue();
            JXBleAPI.this.mReader.write(v, 0, v.length);
            JXLog.d_bytes(TAG, "notifyChanged", characteristic.getValue());
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            JXLog.d_bytes(TAG, "onCharacteristicRead", characteristic.getValue());
        }
    };

    JXBleAPI(Context context) {
        this.context = context.getApplicationContext();
        BluetoothManager bm = (BluetoothManager)context.getSystemService("bluetooth");
        this.btAdapter = bm.getAdapter();
        this.btSupport = this.btAdapter != null;
        this.setConnectState(200);
    }

    public void setUserUUID(String serviceUUID, String writeUUID, String notifyUUID) {
        if (serviceUUID != null && writeUUID != null && notifyUUID != null) {
            DeviceUUID userDeviceUUID;
            this.ble_connection.userUUID = userDeviceUUID = new DeviceUUID(serviceUUID, notifyUUID, writeUUID, "00002902-0000-1000-8000-00805f9b34fb");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JXBleAPI getDefault(@NonNull Context context) {
        if (mDefault != null) return mDefault;
        Class<JXBleAPI> clazz = JXBleAPI.class;
        synchronized (JXBleAPI.class) {
            if (mDefault != null) return mDefault;
            mDefault = new JXBleAPI(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mDefault;
        }
    }

    public static boolean setSendDelay(int delayMills) {
        if (delayMills >= 0) {
            sendDelay = delayMills;
            return true;
        }
        return false;
    }

    public static boolean setMTU(int mtu) {
        if (mtu < 0 || mtu > 517) {
            JXLog.e(TAG, "mtu should be in range of 23-517");
            return false;
        }
        preferMtu = mtu;
        return true;
    }

    public static int getMtu() {
        return maxPacketSize + 3;
    }

    public boolean isBTSupport() {
        return this.btSupport;
    }

    @SuppressLint(value={"MissingPermission"})
    public String getAddress() {
        return this.btAdapter != null ? this.btAdapter.getAddress() : null;
    }

    @SuppressLint(value={"MissingPermission"})
    public String getName() {
        return this.btAdapter != null ? this.btAdapter.getName() : null;
    }

    public int getBTState() {
        return this.btAdapter != null ? this.btAdapter.getState() : 10;
    }

    public boolean isBTEnabled() {
        return this.btAdapter != null ? this.btAdapter.isEnabled() : false;
    }

    private void setConnectState(int state) {
        this.connectState = state;
    }

    public int getConnectState() {
        return this.connectState;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean openBluetooth() {
        try {
            if (this.btAdapter == null) {
                return false;
            }
            if (!this.btAdapter.isEnabled()) {
                this.btAdapter.enable();
                return true;
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
            JXLog.e(TAG, "open bluetooth exception: " + var3.getMessage());
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean closeBluetooth() {
        boolean result = true;
        try {
            if (this.btAdapter != null && this.btAdapter.isEnabled()) {
                this.btAdapter.disable();
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
            JXLog.e(TAG, "close bluetooth exception: " + var3.getMessage());
            result = false;
        }
        return result;
    }

    public boolean setDiscoverable(int time) {
        if (time > 0 && time <= 300) {
            boolean result = true;
            if (this.btAdapter != null) {
                Intent discoverableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
                discoverableIntent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", time);
                this.context.startActivity(discoverableIntent);
            } else {
                result = false;
            }
            return result;
        }
        JXLog.e(TAG, "setDiscoverable error time:" + time);
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean startLeScan(UUID[] uuids, BluetoothAdapter.LeScanCallback callback) {
        if (this.btAdapter != null && this.btAdapter.getState() == 12) {
            this.stopLeScan();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.userScanCallback = callback;
            this.mScanWatchdog.startLeScan();
            this.btAdapter.startLeScan(uuids, callback);
            return true;
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean startLeScan(BluetoothAdapter.LeScanCallback callback) {
        if (this.btAdapter != null && this.btAdapter.getState() == 12) {
            this.stopLeScan();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.userScanCallback = callback;
            this.mScanWatchdog.startLeScan();
            this.btAdapter.startLeScan(this.mScanCallback);
            return true;
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public void stopLeScan() {
        this.userScanCallback = null;
        this.btAdapter.stopLeScan(this.mScanCallback);
        this.mScanWatchdog.stopLeScan();
    }

    public BluetoothDevice getRemoteDevice(String scanAddress) {
        return this.btAdapter.getRemoteDevice(scanAddress);
    }

    public boolean openConnection(String macAddress) {
        return this.openConnection(macAddress, false);
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean openConnection(String macAddress, boolean isReconnect) {
        if (this.btAdapter == null) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress((String)macAddress)) {
            JXLog.e(TAG, "bad mac address");
            return false;
        }
        this.btDevice = this.btAdapter.getRemoteDevice(macAddress);
        try {
            if (this.isConnected()) {
                if (macAddress.equals(this.mConnectedAddress)) {
                    JXLog.d(TAG, "already connected");
                    return true;
                }
                this.closeConnection();
                Thread.sleep(50L);
            }
            if (this.isConnecting()) {
                if (macAddress.equals(this.mConnectedAddress)) {
                    JXLog.d(TAG, "connecting just wait");
                    int connectTimeout = 20000;
                    long ts = SystemClock.elapsedRealtime();
                    while (true) {
                        if (this.isConnected()) {
                            JXLog.d(TAG, "old connecting to connected");
                            return true;
                        }
                        if (SystemClock.elapsedRealtime() - ts > 20000L) {
                            JXLog.f(TAG, "connecting timeout");
                            return false;
                        }
                        Thread.sleep(10L);
                    }
                }
                this.closeConnection();
                Thread.sleep(50L);
            }
            if (Build.VERSION.SDK_INT < 21) {
                this.mGatt = this.btDevice.connectGatt(this.context, false, this.mCallback);
            } else {
                Class<BluetoothDevice> cls = BluetoothDevice.class;
                try {
                    Method m = cls.getMethod("connectGatt", Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE);
                    if (m != null) {
                        try {
                            this.mGatt = (BluetoothGatt)m.invoke((Object)this.btDevice, this.context, false, this.mCallback, 2);
                        }
                        catch (IllegalArgumentException var10) {
                            var10.printStackTrace();
                        }
                        catch (IllegalAccessException var11) {
                            var11.printStackTrace();
                        }
                        catch (InvocationTargetException var12) {
                            var12.printStackTrace();
                        }
                    }
                }
                catch (NoSuchMethodException var13) {
                    var13.printStackTrace();
                }
            }
            this.mConnectedAddress = macAddress;
            this.setConnectState(202);
            int connectTimeout = 10000;
            long ts = SystemClock.elapsedRealtime();
            while (true) {
                if (this.isConnected()) {
                    Thread.sleep(100L);
                    JXLog.d(TAG, "new connection is created");
                    if (!UnlockCmd.unlockIfNecessary(this, this.mUnlockType)) {
                        this.closeConnection();
                        return false;
                    }
                    return true;
                }
                if (this.isBadConnect()) {
                    if (isReconnect) {
                        JXLog.d(TAG, "bad connection, connect failed");
                        return false;
                    }
                    JXLog.d(TAG, "bad connection, try to reopenConnection");
                    return this.reopenConnection(10000);
                }
                if (SystemClock.elapsedRealtime() - ts > 10000L) {
                    JXLog.f(TAG, "check connect timeout, connect failed");
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "openConnection exception " + e.getMessage());
            return false;
        }
    }

    private boolean isConnecting() {
        return this.connectState == 202;
    }

    @Override
    public void setUnlockType(int type) {
        this.mUnlockType = type;
    }

    @Override
    public boolean isConnected() {
        return this.connectState == 203;
    }

    private boolean isBadConnect() {
        return this.connectState == 133;
    }

    private boolean clearCache(BluetoothGatt gatt) {
        if (gatt != null) {
            try {
                BluetoothGatt localBluetoothGatt = gatt;
                Method localMethod = localBluetoothGatt.getClass().getMethod("refresh", new Class[0]);
                if (localMethod != null) {
                    boolean bool = (Boolean)localMethod.invoke((Object)localBluetoothGatt, new Object[0]);
                    return bool;
                }
                JXLog.d(TAG, "clear gatt cache");
            }
            catch (Exception localException) {
                localException.printStackTrace();
                JXLog.e(TAG, "An exception occurred while refreshing device");
            }
        }
        return false;
    }

    @Override
    public boolean closeConnection() {
        boolean close = this.closeConnection(this.mGatt);
        this.mGatt = null;
        return close;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean closeConnection(BluetoothGatt gatt) {
        block7: {
            try {
                if (gatt == null) {
                    JXLog.d(TAG, "close and Gatt is null ");
                    break block7;
                }
                if (this.isConnected()) {
                    gatt.disconnect();
                    gatt.close();
                    break block7;
                }
                if (!this.isConnecting() && !this.isBadConnect()) break block7;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (gatt != null) {
                    gatt.disconnect();
                    gatt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JXLog.e(TAG, "exception when closeConnection ,exception=" + e.getMessage());
            }
        }
        this.setConnectState(200);
        return true;
    }

    @Override
    public boolean reopenConnection(int timeout) {
        this.closeConnection();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.openConnection(this.mConnectedAddress, true);
    }

    @Override
    public boolean flushReadBuffer() {
        this.mReader.flush();
        return true;
    }

    @Override
    public boolean writeBuffer(byte[] buffer, int offset, int length) {
        if (!this.isConnected() || this.ble_connection.writeCharacteristic == null) {
            JXLog.e(TAG, "disconnected");
            return false;
        }
        try {
            Thread.sleep(sendDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        JXLog.d_bytes(TAG, "writeBuffer", buffer);
        if (offset != 0 || length != buffer.length) {
            byte[] by = new byte[length];
            System.arraycopy(buffer, offset, by, 0, length);
            buffer = by;
        }
        int packets = 0;
        int length_bytes = buffer.length;
        if (length_bytes > maxPacketSize) {
            int startPoint = 0;
            byte[] bytes = new byte[maxPacketSize];
            while (length_bytes >= maxPacketSize) {
                System.arraycopy(buffer, startPoint, bytes, 0, maxPacketSize);
                if (this.writeBytesWithRetry(this.ble_connection, bytes)) {
                    startPoint += maxPacketSize;
                    length_bytes -= maxPacketSize;
                    ++packets;
                } else {
                    JXLog.f(TAG, "write packet failed current packet index=" + packets);
                    return false;
                }
                try {
                    Thread.sleep(sendDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (length_bytes > 0) {
                byte[] bytes_tail = new byte[length_bytes];
                System.arraycopy(buffer, startPoint, bytes_tail, 0, length_bytes);
                if (this.writeBytesWithRetry(this.ble_connection, bytes_tail)) {
                    ++packets;
                } else {
                    JXLog.f(TAG, "write packet failed current packet index=" + packets);
                    return false;
                }
            }
            JXLog.d(TAG, "write finished total packets = " + packets);
            return true;
        }
        if (this.writeBytesWithRetry(this.ble_connection, buffer)) {
            JXLog.d(TAG, "write finished total packets = 1");
            return true;
        }
        JXLog.f(TAG, "write packet failed current packet index=0");
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean writeBytesWithRetry(BLE_Connection connection, byte[] bytes) {
        int maxRetryCount = 3;
        if (this.mGatt != null) {
            int retry = 0;
            while (retry++ < 3) {
                connection.writeCharacteristic.setValue(bytes);
                if (this.mGatt.writeCharacteristic(connection.writeCharacteristic)) {
                    return true;
                }
                if (retry >= 3) {
                    return false;
                }
                try {
                    Thread.sleep(500 * retry);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (retry <= 1) continue;
                JXLog.d(TAG, "write packet Bytes retry " + (retry - 1) + " \u6b21");
            }
        }
        return false;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean readBuffer(byte[] buffer, int offset, int length, int timeout) {
        if (!this.isConnected() || this.ble_connection.notifyCharacteristic == null) {
            JXLog.e(TAG, "disconnected");
            return false;
        }
        if (timeout < 200) {
            timeout = 200;
        }
        if (timeout > 50000) {
            timeout = 50000;
        }
        this.mGatt.readCharacteristic(this.ble_connection.notifyCharacteristic);
        if (offset >= 0) {
            return this.readFixLengthBytes(buffer, offset, length, timeout);
        }
        return this.readVariableLengthBytes(buffer, ~offset, timeout);
    }

    private boolean readFixLengthBytes(byte[] buffer, int offset, int length, int timeout) {
        try {
            long start_time = SystemClock.elapsedRealtime();
            int need_read = length;
            int index = 0;
            while (true) {
                int available = this.mReader.available();
                int read = 0;
                if (available > 0) {
                    int n;
                    while ((n = this.mReader.read()) != -1) {
                        buffer[index++] = (byte)n;
                        ++read;
                        if (index >= length + offset) {
                            JXLog.d("readFixLengthBytes", "index = " + index + "_length = " + length + " break this read while");
                            break;
                        }
                        if (read < available) continue;
                        JXLog.d("readFixLengthBytes", "available = " + available + "_read = " + read + " break this read while");
                        break;
                    }
                    need_read -= read;
                    start_time = SystemClock.elapsedRealtime();
                }
                if (need_read <= 0) {
                    JXLog.d_bytes("readFixLengthBytes", "read", buffer);
                    return true;
                }
                if (SystemClock.elapsedRealtime() - start_time > (long)timeout) {
                    JXLog.e(TAG, "readFixLengthBytes timeout");
                    JXLog.d_bytes("readFixLengthBytes", "read", buffer);
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception var11) {
            JXLog.e(TAG, "read exception " + var11.getMessage());
            this.closeConnection();
            return false;
        }
    }

    private boolean readVariableLengthBytes(byte[] buffer, int nIndex, int timeout) {
        try {
            long start_time = SystemClock.elapsedRealtime();
            int need_read = nIndex + 1;
            int index = 0;
            while (true) {
                if (this.mReader.available() > 0) {
                    int n;
                    while ((n = this.mReader.read()) != -1) {
                        buffer[index] = (byte)n;
                        --need_read;
                        if (index == nIndex) {
                            need_read = buffer[index];
                        }
                        if (need_read == 0) {
                            JXLog.d_bytes("readVariableLengthBytes", "read", buffer);
                            return true;
                        }
                        ++index;
                    }
                    start_time = SystemClock.elapsedRealtime();
                }
                if (SystemClock.elapsedRealtime() - start_time > (long)timeout) {
                    JXLog.e(TAG, "readVariableLengthBytes timeout");
                    JXLog.d_bytes("readVariableLengthBytes", "read", buffer);
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception var11) {
            JXLog.e(TAG, "read exception " + var11.getMessage());
            this.closeConnection();
            return false;
        }
    }

    @Override
    public boolean readBuffer(byte[] buffer1, byte[] buffer2, long[] receiveTS, int timeout) {
        if (!this.isConnected() || this.ble_connection.notifyCharacteristic == null) {
            JXLog.e(TAG, "disconnected");
            return false;
        }
        if (timeout < 200) {
            timeout = 200;
        }
        if (timeout > 50000) {
            timeout = 50000;
        }
        long ts = SystemClock.elapsedRealtime();
        boolean readBuffer2 = false;
        block2: while (true) {
            try {
                while (true) {
                    if (!readBuffer2) {
                        if (this.mReader.available() >= buffer1.length) {
                            receiveTS[0] = System.currentTimeMillis();
                            this.mReader.read(buffer1, 0, buffer1.length);
                            JXLog.d_bytes(TAG, "read buffer1 ", buffer1);
                            readBuffer2 = true;
                        }
                    } else if (this.mReader.available() >= buffer2.length) {
                        receiveTS[1] = System.currentTimeMillis();
                        this.mReader.read(buffer2, 0, buffer2.length);
                        JXLog.d_bytes(TAG, "read buffer2 ", buffer2);
                        return true;
                    }
                    if (SystemClock.elapsedRealtime() - ts > (long)timeout) {
                        JXLog.e(TAG, "readBuffer timeout " + timeout);
                        break block2;
                    }
                    Thread.sleep(20L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JXLog.e(TAG, "readBuffer exception " + e.getMessage());
                continue;
            }
            break;
        }
        return false;
    }

    @Override
    public boolean isUnlock() {
        if (!UnlockCmd.unlockIfNecessary(this, 2)) {
            this.closeConnection();
            return false;
        }
        return true;
    }

    class BleDataCache {
        private static final String TAG = "BlBuffer";
        public static final int MAX_BUFFER_SIZE = 4096;
        public byte[] mBuffer = new byte[4096];
        private volatile int ret = 0;
        private volatile int pos = 0;

        BleDataCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int write(byte[] b, int offset, int length) {
            byte[] byArray = this.mBuffer;
            synchronized (this.mBuffer) {
                if (this.ret + length > 4096) {
                    JXLog.e(TAG, "the sum of ret and length can't larger than 2048");
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return -1;
                }
                System.arraycopy(b, offset, this.mBuffer, this.ret, length);
                this.ret += length;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int read(byte[] b, int offset, int length) {
            if (this.available() < length) {
                JXLog.e(TAG, "read length must smaller than length can read");
                return -1;
            }
            byte[] byArray = this.mBuffer;
            synchronized (this.mBuffer) {
                System.arraycopy(this.mBuffer, this.pos, b, offset, length);
                this.pos += length;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int read() {
            byte[] byArray = this.mBuffer;
            synchronized (this.mBuffer) {
                if (this.pos > this.ret) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return -1;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.mBuffer[this.pos++] & 0xFF;
            }
        }

        public int available() {
            return this.ret - this.pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flush() {
            byte[] byArray = this.mBuffer;
            synchronized (this.mBuffer) {
                this.ret = 0;
                this.pos = 0;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private class BLE_Connection {
        public BluetoothGattCharacteristic notifyCharacteristic;
        public BluetoothGattCharacteristic writeCharacteristic;
        public BluetoothGattService bleService;
        public final List<DeviceUUID> DEVICE_UUID_LIST = Arrays.asList(new DeviceUUID("49535343-FE7D-4AE5-8FA9-9FAFD205E455", "49535343-1E4D-4BD9-BA61-23C647249616", "49535343-8841-43F4-A8D4-ECBE34729BB3", "00002902-0000-1000-8000-00805f9b34fb"), new DeviceUUID("0000ff00-0000-1000-8000-00805f9b34fb", "0000ff01-0000-1000-8000-00805f9b34fb", "0000ff02-0000-1000-8000-00805f9b34fb", "00002902-0000-1000-8000-00805f9b34fb"), new DeviceUUID("49535343-FE7D-4AE5-8FA9-9FAFD205E455", "49535343-1E4D-4BD9-BA61-23C647249616", "49535343-8841-43F4-A8D4-ECBE34729BB3", "00002902-0000-1000-8000-00805f9b34fb"), new DeviceUUID("0000ff20-0000-1000-8000-00805f9b34fb", "0000ff21-0000-1000-8000-00805f9b34fb", "0000ff22-0000-1000-8000-00805f9b34fb", "00002902-0000-1000-8000-00805f9b34fb"), new DeviceUUID("000018f0-0000-1000-8000-00805f9b34fb", "00002af0-0000-1000-8000-00805f9b34fb", "00002af1-0000-1000-8000-00805f9b34fb", "00002902-0000-1000-8000-00805f9b34fb"), new DeviceUUID("0000ffb0-0000-1000-8000-00805f9b34fb", "0000ffb2-0000-1000-8000-00805f9b34fb", "0000ffb1-0000-1000-8000-00805f9b34fb", "00002902-0000-1000-8000-00805f9b34fb"));
        public DeviceUUID userUUID;
        private static final String DEFAULT_GATT_SERVICE_UUID = "49535343-FE7D-4AE5-8FA9-9FAFD205E455";
        private static final String DEFAULT_GATT_WRITE_CHARC_UUID = "49535343-8841-43F4-A8D4-ECBE34729BB3";
        private static final String DEFAULT_GATT_NOTIFY_CHARC_UUID = "49535343-1E4D-4BD9-BA61-23C647249616";
        private static final String DEFAULT_CHARACTERISTIC_UPDATE_NOTIFICATION_DESCRIPTOR_UUID = "00002902-0000-1000-8000-00805f9b34fb";
        private static final String E1_GATT_SERVICE_UUID = "000018f0-0000-1000-8000-00805f9b34fb";
        private static final String E1_GATT_NOTIFY_CHARC_UUID = "00002af0-0000-1000-8000-00805f9b34fb";
        private static final String E1_GATT_WRITE_CHARC_UUID = "00002af1-0000-1000-8000-00805f9b34fb";
        private static final String E2_GATT_SERVICE_UUID = "0000ffb0-0000-1000-8000-00805f9b34fb";
        private static final String E2_GATT_NOTIFY_CHARC_UUID = "0000ffb2-0000-1000-8000-00805f9b34fb";
        private static final String E2_GATT_WRITE_CHARC_UUID = "0000ffb1-0000-1000-8000-00805f9b34fb";
        private static final String IVT_GATT_SERVICE_UUID = "0000ff00-0000-1000-8000-00805f9b34fb";
        private static final String IVT_GATT_NOTIFY_CHARC_UUID = "0000ff01-0000-1000-8000-00805f9b34fb";
        private static final String IVT_GATT_WRITE_CHARC_UUID = "0000ff02-0000-1000-8000-00805f9b34fb";
        private static final String ISSC_GATT_SERVICE_UUID = "49535343-FE7D-4AE5-8FA9-9FAFD205E455";
        private static final String ISSC_GATT_NOTIFY_CHARC_UUID = "49535343-1E4D-4BD9-BA61-23C647249616";
        private static final String ISSC_GATT_WRITE_CHARC_UUID = "49535343-8841-43F4-A8D4-ECBE34729BB3";
        private static final String IVT_I81_WIFI_SERVICE_UUID = "0000ff20-0000-1000-8000-00805f9b34fb";
        private static final String IVT_I81_WIFI_NOTIFY_CHARC_UUID = "0000ff21-0000-1000-8000-00805f9b34fb";
        private static final String IVT_I81_WIFI_WRITE_CHARC_UUID = "0000ff22-0000-1000-8000-00805f9b34fb";

        public void reset() {
            this.bleService = null;
            this.notifyCharacteristic = null;
            this.writeCharacteristic = null;
        }

        @SuppressLint(value={"MissingPermission"})
        public boolean startNotify() {
            if (this.writeCharacteristic == null || this.notifyCharacteristic == null) {
                return false;
            }
            this.writeCharacteristic.setWriteType(1);
            boolean setNotify = JXBleAPI.this.mGatt.setCharacteristicNotification(this.notifyCharacteristic, true);
            if (!setNotify) {
                JXLog.e(TAG, "setNotify failed");
                return false;
            }
            BluetoothGattDescriptor descriptor = ((JXBleAPI)JXBleAPI.this).ble_connection.notifyCharacteristic.getDescriptor(UUID.fromString(DEFAULT_CHARACTERISTIC_UPDATE_NOTIFICATION_DESCRIPTOR_UUID));
            if (descriptor != null) {
                descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                JXBleAPI.this.mGatt.writeDescriptor(descriptor);
                JXLog.i(TAG, "setDescriptor:00002902-0000-1000-8000-00805f9b34fb");
            }
            return true;
        }

        public boolean findServices(BluetoothGatt gatt) {
            ArrayList<DeviceUUID> uuids = new ArrayList<DeviceUUID>();
            if (this.userUUID != null) {
                uuids.add(this.userUUID);
                this.userUUID = null;
            }
            uuids.addAll(this.DEVICE_UUID_LIST);
            for (DeviceUUID deviceUUID : uuids) {
                try {
                    UUID uuid = UUID.fromString(deviceUUID.serviceId);
                    BluetoothGattService service = gatt.getService(uuid);
                    if (service != null) {
                        if (!this.findCharacteristic(service, deviceUUID)) continue;
                        return true;
                    }
                    JXLog.d(TAG, deviceUUID.serviceId + " not found");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.bleService == null) {
                this.reset();
                JXLog.e(TAG, "no available characteristic, close connection");
            }
            return false;
        }

        private boolean findCharacteristic(BluetoothGattService service, DeviceUUID uuid) {
            BluetoothGattCharacteristic writeChar = service.getCharacteristic(UUID.fromString(uuid.writeId));
            BluetoothGattCharacteristic notifyChar = service.getCharacteristic(UUID.fromString(uuid.notifyId));
            if (writeChar != null && notifyChar != null) {
                JXLog.d(TAG, "found characteristics write=" + uuid.writeId + "\n notify=" + uuid.notifyId);
                this.bleService = service;
                this.writeCharacteristic = writeChar;
                this.notifyCharacteristic = notifyChar;
                JXLog.d("BLE_CONNECT", "uuid-->Service=" + UUID.fromString(uuid.serviceId));
                return true;
            }
            return false;
        }
    }

    private class LeScanWatchdog {
        private Handler mHandler;
        private Runnable mRunnable = new Runnable(){

            @Override
            public void run() {
                JXLog.d(TAG, "LeScanWatchdog leScan timeout 10s, force stop");
                if (JXBleAPI.this.userScanCallback != null) {
                    JXBleAPI.this.stopLeScan();
                }
            }
        };

        LeScanWatchdog() {
            this.mHandler = new Handler(Looper.getMainLooper());
        }

        public void startLeScan() {
            this.stopLeScan();
            JXLog.d(TAG, "LeScanWatchdog wang wang");
            this.mHandler.postDelayed(this.mRunnable, 10000L);
        }

        public void stopLeScan() {
            JXLog.d(TAG, "LeScanWatchdog exit");
            this.mHandler.removeCallbacks(this.mRunnable);
        }
    }
}

