/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.graphics.Bitmap;
import androidx.annotation.Nullable;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.JXCommand;
import com.jxit.printer.model.JXPrinterStatus;
import com.jxit.printer.utils.BitmapTools;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

class CPCL_CMD
extends JXCommand {
    private boolean isUnification = false;
    private List<String> cmdList;
    private int Times = -1;

    public CPCL_CMD(JXInterfaceAPI api) {
        super(api);
    }

    public boolean portSend(String cmd) {
        if (this.isUnification) {
            if (this.cmdList == null) {
                this.cmdList = new ArrayList<String>();
            }
            this.cmdList.add(cmd);
            return true;
        }
        return this.portSendCmd(cmd);
    }

    public boolean readSendCmdResult(int timeout) {
        if (this.mAPI.isConnected()) {
            byte[] bytes = new byte[2];
            if (this.mAPI.readBuffer(bytes, 0, 2, timeout)) {
                try {
                    String value = new String(bytes, "GBK");
                    if (value.startsWith("OK")) {
                        return true;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            this.mAPI.flushReadBuffer();
        }
        return false;
    }

    public boolean portSendCmd(String cmd) {
        int itemLen = 100;
        if (this.mAPI.isConnected()) {
            cmd = cmd + "\r\n";
            byte[] data = null;
            try {
                data = cmd.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                return false;
            }
            int Len = data.length;
            while (true) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (Len <= itemLen) break;
                if (!this.mAPI.writeBuffer(data, data.length - Len, itemLen)) {
                    return false;
                }
                Len -= itemLen;
            }
            return this.mAPI.writeBuffer(data, data.length - Len, Len);
        }
        return false;
    }

    public boolean print(int horizontal, int skip) {
        String cmd;
        String form;
        if (skip > 0 && !this.portSendCmd(form = "FORM")) {
            return false;
        }
        if (horizontal == 0 ? !this.portSendCmd(cmd = "PRINT") : !this.portSendCmd(cmd = "POPRINT")) {
            return false;
        }
        --this.Times;
        return true;
    }

    public boolean pageSetup(int pageWidth, int pageHeight) {
        if (this.isUnification) {
            this.cmdList = new ArrayList<String>();
        }
        ++this.Times;
        String cmd = "! 0 200 200 " + pageHeight + " 1";
        if (!this.portSendCmd(cmd)) {
            return false;
        }
        cmd = "PAGE-WIDTH " + pageWidth;
        return this.portSendCmd(cmd);
    }

    public boolean pageSetup(int pageWidth, int pageHeight, int times) {
        if (this.isUnification) {
            this.cmdList = new ArrayList<String>();
        }
        ++this.Times;
        String cmd = "! 0 200 200 " + pageHeight + " " + times;
        if (!this.portSendCmd(cmd)) {
            return false;
        }
        cmd = "PAGE-WIDTH " + pageWidth;
        return this.portSendCmd(cmd);
    }

    public boolean drawBox(int lineWidth, int top_left_x, int top_left_y, int bottom_right_x, int bottom_right_y) {
        if (top_left_x > 575) {
            top_left_x = 575;
        }
        if (bottom_right_x > 575) {
            bottom_right_x = 575;
        }
        String CPCLCmd = "BOX " + top_left_x + " " + top_left_y + " " + bottom_right_x + " " + bottom_right_y + " " + lineWidth;
        return this.portSendCmd(CPCLCmd);
    }

    private String getFontSetting(int fontSize, int[] targetFontSize) {
        int size;
        int font;
        if (fontSize <= 16) {
            font = 55;
            size = 55;
            fontSize = 16;
        } else if (fontSize <= 20) {
            font = 3;
            size = 1;
            fontSize = 20;
        } else if (fontSize <= 24) {
            font = 24;
            size = 0;
            fontSize = 24;
        } else if (fontSize <= 28) {
            font = 8;
            size = 0;
            fontSize = 28;
        } else if (fontSize <= 32) {
            font = 55;
            size = 1;
            fontSize = 32;
        } else if (fontSize <= 40) {
            font = 4;
            size = 1;
            fontSize = 40;
        } else if (fontSize <= 48) {
            font = 4;
            size = 2;
            fontSize = 48;
        } else if (fontSize <= 56) {
            font = 4;
            size = 3;
            fontSize = 56;
        } else if (fontSize <= 64) {
            font = 24;
            size = 4;
            fontSize = 64;
        } else {
            font = 24;
            size = 0;
            fontSize = 72;
        }
        targetFontSize[0] = fontSize;
        if (fontSize < 72) {
            String CPCLCmd = "SETMAG 0 0";
            this.portSendCmd(CPCLCmd);
        }
        return font + " " + size;
    }

    public boolean drawLine(int lineWidth, int start_x, int start_y, int end_x, int end_y) {
        if (start_x > 575) {
            start_x = 575;
        }
        if (end_x > 575) {
            end_x = 575;
        }
        String CPCLCmd = "LINE " + start_x + " " + start_y + " " + end_x + " " + end_y + " " + lineWidth;
        return this.portSendCmd(CPCLCmd);
    }

    public boolean drawText(int text_x, int text_y, String text, int fontSize, int rotate, int bold, boolean reverse, boolean underline) {
        String CPCLCmd = underline ? "UNDERLINE ON" : "UNDERLINE OFF";
        if (!this.portSendCmd(CPCLCmd)) {
            return false;
        }
        CPCLCmd = "SETBOLD " + bold;
        if (!this.portSendCmd(CPCLCmd)) {
            return false;
        }
        int[] targetSize = new int[1];
        String fontSetting = this.getFontSetting(fontSize, targetSize);
        if (targetSize[0] == 72 && !this.portSendCmd(CPCLCmd = "SETMAG 3 3")) {
            return false;
        }
        switch (rotate) {
            case 1: {
                if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR90 " + fontSetting + " " + text_x + " " + text_y + " " + text) : !this.portSendCmd(CPCLCmd = "T90 " + fontSetting + " " + text_x + " " + text_y + " " + text))) break;
                return false;
            }
            case 2: {
                if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR180 " + fontSetting + " " + text_x + " " + text_y + " " + text) : !this.portSendCmd(CPCLCmd = "T180 " + fontSetting + " " + text_x + " " + text_y + " " + text))) break;
                return false;
            }
            case 3: {
                if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR270 " + fontSetting + " " + text_x + " " + text_y + " " + text) : !this.portSendCmd(CPCLCmd = "T270 " + fontSetting + " " + text_x + " " + text_y + " " + text))) break;
                return false;
            }
            default: {
                if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR " + fontSetting + " " + text_x + " " + text_y + " " + text) : !this.portSendCmd(CPCLCmd = "TEXT " + fontSetting + " " + text_x + " " + text_y + " " + text))) break;
                return false;
            }
        }
        return true;
    }

    public boolean drawMultipleLineText(String text, int fontSize, int start_x, int start_y, int end_x, int lineSpace, int bold, boolean reverse, boolean underline) {
        String CPCLCmd = underline ? "UNDERLINE ON" : "UNDERLINE OFF";
        if (!this.portSendCmd(CPCLCmd)) {
            return false;
        }
        CPCLCmd = "SETBOLD " + bold;
        if (!this.portSendCmd(CPCLCmd)) {
            return false;
        }
        int[] targetSize = new int[1];
        String fontSetting = this.getFontSetting(fontSize, targetSize);
        if (targetSize[0] == 72 && !this.portSendCmd(CPCLCmd = "SETMAG 3 3")) {
            return false;
        }
        int targetFontSize = targetSize[0];
        ArrayList<String> multipleTexts = this.wrapMultipleText(text, targetFontSize, end_x - start_x);
        int startX = start_x;
        int startY = start_y;
        for (int i = 0; i < multipleTexts.size(); ++i) {
            String subText = multipleTexts.get(i);
            if (i > 0) {
                startY += targetFontSize + lineSpace;
            }
            if (this.portSendCmd(CPCLCmd = String.format("%s %s %d %d %s", reverse ? "TR" : "T", fontSetting, startX, startY, subText))) continue;
            return false;
        }
        return true;
    }

    private ArrayList<String> wrapMultipleText(String text, int fontSize, int maxWidth) {
        ArrayList<String> textSlices = new ArrayList<String>();
        int chineseCharLen = fontSize;
        int otherCharLen = fontSize / 2;
        int totalLen = 0;
        int start = 0;
        for (int i = 0; i < text.length(); ++i) {
            int charLen;
            char c = text.charAt(i);
            boolean isChinese = c >= '\u4e00' && c <= '\u29fa5';
            int n = charLen = isChinese ? chineseCharLen : otherCharLen;
            if ((totalLen += charLen) <= maxWidth) continue;
            textSlices.add(text.substring(start, i));
            start = i;
            totalLen = charLen;
        }
        textSlices.add(text.substring(start));
        return textSlices;
    }

    public boolean drawText(int text_x, int text_y, int width, int height, String str, int fontsize, int rotate, int bold, boolean underline, boolean reverse) {
        String CPCLCmd = underline ? "UNDERLINE ON" : "UNDERLINE OFF";
        if (!this.portSendCmd(CPCLCmd)) {
            return false;
        }
        CPCLCmd = "SETBOLD " + bold;
        if (!this.portSendCmd(CPCLCmd)) {
            return false;
        }
        int Height = 0;
        int Width = 0;
        int[] targetSize = new int[1];
        String fontSetting = this.getFontSetting(fontsize, targetSize);
        if (targetSize[0] == 72 && !this.portSendCmd(CPCLCmd = "SETMAG 3 3")) {
            return false;
        }
        Height = targetSize[0];
        char[] array = str.toCharArray();
        str = "";
        for (int i = 0; i < array.length; ++i) {
            if ((char)array[i] != array[i]) {
                if ((Width += Height) > width) {
                    switch (rotate) {
                        case 1: {
                            if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR90 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T90 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                            return false;
                        }
                        case 2: {
                            if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR180 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T180 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                            return false;
                        }
                        case 3: {
                            if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR270 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T270 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                            return false;
                        }
                        default: {
                            if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "TEXT " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                            return false;
                        }
                    }
                    text_y += Height;
                    Width = Height;
                    str = String.valueOf(array[i]);
                    continue;
                }
                str = str + String.valueOf(array[i]);
                continue;
            }
            if ((Width += Height / 2) > width) {
                switch (rotate) {
                    case 1: {
                        if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR90 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T90 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                        return false;
                    }
                    case 2: {
                        if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR180 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T180 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                        return false;
                    }
                    case 3: {
                        if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR270 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T270 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                        return false;
                    }
                    default: {
                        if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "TEXT " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                        return false;
                    }
                }
                text_y += Height;
                Width = Height / 2;
                str = String.valueOf(array[i]);
                continue;
            }
            str = str + String.valueOf(array[i]);
        }
        switch (rotate) {
            case 1: {
                if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR90 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T90 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                return false;
            }
            case 2: {
                if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR180 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T180 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                return false;
            }
            case 3: {
                if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR270 " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "T270 " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                return false;
            }
            default: {
                if (!(reverse ? !this.portSendCmd(CPCLCmd = "TR " + fontSetting + " " + text_x + " " + text_y + " " + str) : !this.portSendCmd(CPCLCmd = "TEXT " + fontSetting + " " + text_x + " " + text_y + " " + str))) break;
                return false;
            }
        }
        return true;
    }

    public boolean drawWatermark(int text_x, int text_y, String text, int fontSize, @Nullable Integer density) {
        String CPCLCmd;
        if (density != null) {
            if (density <= 0) {
                density = 10;
            }
            if (density > 100) {
                density = 100;
            }
            if (!this.portSendCmd(CPCLCmd = "BACKGROUND " + density)) {
                return false;
            }
        }
        int[] targetSize = new int[1];
        String fontSetting = this.getFontSetting(fontSize, targetSize);
        if (targetSize[0] == 72 && !this.portSendCmd(CPCLCmd = "SETMAG 3 3")) {
            return false;
        }
        CPCLCmd = "BKT " + fontSetting + " " + text_x + " " + text_y + " " + text;
        return this.portSendCmd(CPCLCmd);
    }

    public boolean drawBarCode(int start_x, int start_y, String text, int type, int rotate, int lineWidth, int height) {
        int ratio = 2;
        String CPCLCmd = "";
        String barcodeType = "128";
        if (type == 0) {
            barcodeType = "39";
        } else if (type == 1) {
            barcodeType = "128";
        } else if (type == 2) {
            barcodeType = "93";
        } else if (type == 3) {
            barcodeType = "CODABAR";
        } else if (type == 4) {
            barcodeType = "EAN8";
        } else if (type == 5) {
            barcodeType = "EAN13";
        } else if (type == 6) {
            barcodeType = "UPCA";
        } else if (type == 7) {
            barcodeType = "UPCE";
        }
        CPCLCmd = rotate != 0 ? "VBARCODE  " + barcodeType + " " + (lineWidth - 1) + " " + ratio + " " + height + " " + start_x + " " + start_y + " " + text : "BARCODE " + barcodeType + " " + (lineWidth - 1) + " " + ratio + " " + height + " " + start_x + " " + start_y + " " + text;
        return this.portSendCmd(CPCLCmd);
    }

    public boolean drawBarCode(int start_x, int start_y, String text, int type, int rotate, int lineWidth, int height, int fontSize, int topMargin) {
        String CPCLCmd;
        int[] targetSize = new int[1];
        String fontSetting = this.getFontSetting(fontSize, targetSize);
        if (targetSize[0] == 72 && !this.portSendCmd(CPCLCmd = "SETMAG 3 3")) {
            return false;
        }
        String CPCLCmdBegin = String.format("BARCODE-TEXT %s %d", fontSetting, topMargin);
        String CPCLCmdEnd = "BARCODE-TEXT OFF";
        return this.portSendCmd(CPCLCmdBegin) && this.drawBarCode(start_x, start_y, text, type, rotate, lineWidth, height) && this.portSendCmd(CPCLCmdEnd);
    }

    public boolean drawQrCode(int start_x, int start_y, String text, int ver, int unitSize) {
        String CPCLCmd = "SETQRVER " + ver;
        if (!this.portSendCmd(CPCLCmd)) {
            return false;
        }
        CPCLCmd = "BARCODE QR " + start_x + " " + start_y + " M 2 U " + unitSize + "\r\nMA," + text + "\r\nENDQR";
        return this.portSendCmd(CPCLCmd);
    }

    private String printHexString(byte[] b) {
        String a = "";
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            a = a + hex;
        }
        return a;
    }

    public boolean drawGraphic(int start_x, int start_y, int bmp_size_x, int bmp_size_y, Bitmap bmp) {
        int byteWidth = (bmp_size_x - 1) / 8 + 1;
        int byteHeight = bmp_size_y;
        if (byteWidth <= 0) {
            return false;
        }
        if (byteHeight <= 0) {
            return false;
        }
        int unitHeight = 496 / byteWidth;
        int unitCount = (byteHeight - 1) / unitHeight + 1;
        for (int n = 0; n < unitCount; ++n) {
            int startY = n * unitHeight;
            int endY = startY + unitHeight > bmp_size_y ? bmp_size_y : startY + unitHeight;
            int byteLen = (endY - startY) * byteWidth;
            byte[] dataByte = new byte[byteLen];
            for (int y = startY; y < endY; ++y) {
                for (int x = 0; x < bmp_size_x; ++x) {
                    int color = bmp.getPixel(x, y);
                    int A = color >> 24 & 0xFF;
                    int R = color >> 16 & 0xFF;
                    int G = color >> 8 & 0xFF;
                    int B = color & 0xFF;
                    if (A <= 0 || !((double)R * 0.3 + (double)G * 0.59 + (double)B * 0.11 < 180.0)) continue;
                    int n2 = (y - startY) * byteWidth + x / 8;
                    dataByte[n2] = (byte)(dataByte[n2] | 128 >> x % 8);
                }
            }
            String dataStr = this.printHexString(dataByte);
            String CPCLCmd = "EG " + byteWidth + " " + (endY - startY) + " " + start_x + " " + (start_y + startY) + " " + dataStr;
            if (this.portSendCmd(CPCLCmd)) continue;
            return false;
        }
        return true;
    }

    public JXPrinterStatus printerStatus() {
        if (this.mAPI.isConnected()) {
            JXPrinterStatus status = new JXPrinterStatus();
            byte[] Cmd = new byte[3];
            byte[] Rep = new byte[2];
            this.mAPI.flushReadBuffer();
            Cmd[0] = 16;
            Cmd[1] = 4;
            Cmd[2] = 5;
            if (this.mAPI.writeBuffer(Cmd, 0, 3) && this.mAPI.readBuffer(Rep, 0, 2, 3000)) {
                status.parse(Rep);
                return status;
            }
        }
        return null;
    }

    public String printerType() {
        return "QR";
    }

    public boolean feed() {
        if (this.mAPI.isConnected()) {
            byte[] Data = new byte[]{14};
            return this.mAPI.writeBuffer(Data, 0, 1);
        }
        return false;
    }

    public boolean drawBarCode(int start_x, int start_y, int end_x, int end_y, String text, int type, int rotate, int linewidth, int height, int direction) {
        BarcodeFormat barcodeFormat;
        int radio = 2;
        String CPCLCmd = "";
        String barcodeType = "128";
        switch (type) {
            case 0: {
                barcodeFormat = BarcodeFormat.CODE_39;
                barcodeType = "39";
                break;
            }
            case 1: {
                barcodeFormat = BarcodeFormat.CODE_128;
                barcodeType = "128";
                break;
            }
            case 2: {
                barcodeFormat = BarcodeFormat.CODE_93;
                barcodeType = "93";
                break;
            }
            case 3: {
                barcodeFormat = BarcodeFormat.CODABAR;
                barcodeType = "CODABAR";
                break;
            }
            case 4: {
                barcodeFormat = BarcodeFormat.EAN_8;
                barcodeType = "EAN8";
                break;
            }
            case 5: {
                barcodeFormat = BarcodeFormat.EAN_13;
                barcodeType = "EAN13";
                break;
            }
            case 6: {
                barcodeFormat = BarcodeFormat.UPC_A;
                barcodeType = "UPCA";
                break;
            }
            case 7: {
                barcodeFormat = BarcodeFormat.UPC_E;
                barcodeType = "UPCE";
                break;
            }
            default: {
                barcodeFormat = BarcodeFormat.CODE_128;
            }
        }
        try {
            int Width = this.barcodeWidth(text, barcodeFormat, linewidth, height);
            int MaxWidth = end_x - start_x;
            int MaxHeight = end_y - start_y;
            switch (direction) {
                case 1: {
                    if (rotate == 0) {
                        if (Width >= MaxWidth) break;
                        start_x += (MaxWidth - Width) / 2;
                        break;
                    }
                    if (Width >= MaxHeight) break;
                    start_y += (MaxHeight - Width) / 2;
                    break;
                }
                case 2: {
                    if (rotate == 0) {
                        if (Width >= MaxWidth) break;
                        start_x += MaxWidth - Width;
                        break;
                    }
                    if (Width >= MaxWidth) break;
                    start_y += MaxHeight - Width;
                    break;
                }
            }
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        CPCLCmd = rotate != 0 ? "VBARCODE " + barcodeType + " " + (linewidth - 1) + " " + radio + " " + height + " " + start_x + " " + start_y + " " + text : "BARCODE " + barcodeType + " " + (linewidth - 1) + " " + radio + " " + height + " " + start_x + " " + start_y + " " + text;
        return this.portSendCmd(CPCLCmd);
    }

    private int barcodeWidth(String text, BarcodeFormat format, int Width, int Height) throws WriterException {
        int x;
        MultiFormatWriter writer = new MultiFormatWriter();
        BitMatrix temp = writer.encode(text, format, 1, 1);
        BitMatrix result = writer.encode(text, format, temp.getWidth() * Width, Height);
        int width = result.getWidth();
        int height = result.getHeight();
        int AAA = 0;
        int BBB = 0;
        for (x = 0; x < width; ++x) {
            if (!result.get(x, 0)) continue;
            AAA = x;
            break;
        }
        for (x = 0; x < width; ++x) {
            if (!result.get(width - 1 - x, 0)) continue;
            BBB = x;
            break;
        }
        return width -= AAA + BBB;
    }

    public Bitmap compress(Bitmap bitmap, int width) {
        return BitmapTools.compress(bitmap, width);
    }

    public Bitmap binaryzation(Bitmap bitmap) {
        return BitmapTools.getSinglePic(bitmap, BitmapTools.otsu(bitmap));
    }

    public Bitmap binaryzation(Bitmap bitmap, int threshold) {
        return BitmapTools.getSinglePic(bitmap, threshold);
    }
}

