/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.BarcodeFormat;
import com.jxit.printer.jxsdk.CPCL_CMD;
import com.jxit.printer.jxsdk.ESC_CMD;
import com.jxit.printer.jxsdk.Global_Page_CMD;
import com.jxit.printer.jxsdk.GuoJiang_CMD;
import com.jxit.printer.jxsdk.JXExecutors;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.jxsdk.JXUpgradeListener;
import com.jxit.printer.jxsdk.JXUpgradeService;
import com.jxit.printer.jxsdk.LowMemory_CMD;
import com.jxit.printer.jxsdk.PrinterDPI;
import com.jxit.printer.jxsdk.TSPL_CMD;
import com.jxit.printer.model.JXBTTransferResult;
import com.jxit.printer.model.JXCommunicationError;
import com.jxit.printer.model.JXFontLibInfo;
import com.jxit.printer.model.JXHeadAndBatteryInfo;
import com.jxit.printer.model.JXOptocouplerInfo;
import com.jxit.printer.model.JXOptocouplerTestResult;
import com.jxit.printer.model.JXPrinterStatus;
import com.jxit.printer.model.JXSupportInfo;
import com.jxit.printer.model.JXUsageDataInfo;
import com.jxit.printer.utils.JXJNISDK;

public final class JXPrinter {
    private static final String TAG = "JXPrinter";
    private GuoJiang_CMD gj;
    private ESC_CMD esc;
    private CPCL_CMD cpcl;
    private Global_Page_CMD global;
    private TSPL_CMD tspl;
    private LowMemory_CMD lowM;
    public static final int CONNECT_TYPE_BLUETOOTH = 1;
    public static final int CONNECT_TYPE_USB = 2;
    private JXInterfaceAPI mAPI;

    public JXPrinter(JXInterfaceAPI interfaceAPI) {
        if (interfaceAPI == null) {
            JXLog.e(TAG, "interfaceApi must not be null!");
            throw new IllegalArgumentException("interfaceApi must not be null");
        }
        this.mAPI = interfaceAPI;
        this.gj = new GuoJiang_CMD(interfaceAPI);
        this.esc = new ESC_CMD(interfaceAPI);
        this.cpcl = new CPCL_CMD(interfaceAPI);
        this.global = new Global_Page_CMD(interfaceAPI);
        this.tspl = new TSPL_CMD(interfaceAPI);
        this.lowM = new LowMemory_CMD(interfaceAPI);
    }

    public static void init(Context context, boolean showLog) {
        JXJNISDK.init();
    }

    public JXInterfaceAPI getInterfaceAPI() {
        return this.mAPI;
    }

    public boolean cpcl_writeCmd(String cmd) {
        try {
            JXLog.d_method(TAG, "cpcl_writeCmd", cmd);
            return JXExecutors.printer().execute(() -> this.cpcl.portSendCmd(cmd)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_readCmdResult(int timeout) {
        try {
            JXLog.d_method(TAG, "cpcl_readCmdResult", timeout);
            return JXExecutors.printer().execute(() -> this.cpcl.readSendCmdResult(timeout)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_pageSetup(int pageWidth, int pageHeight) {
        try {
            JXLog.d_method(TAG, "cpcl_pageSetup", pageWidth, pageHeight);
            return JXExecutors.printer().execute(() -> this.cpcl.pageSetup(pageWidth, pageHeight)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_pageSetup(int pageWidth, int pageHeight, int times) {
        try {
            JXLog.d_method(TAG, "cpcl_pageSetup", pageWidth, pageHeight, times);
            return JXExecutors.printer().execute(() -> this.cpcl.pageSetup(pageWidth, pageHeight, times)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_print(int horizontal, int skip) {
        try {
            JXLog.d_method(TAG, "cpcl_print", horizontal, skip);
            return JXExecutors.printer().execute(() -> this.cpcl.print(horizontal, skip)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawBox(int lineWidth, int top_left_x, int top_left_y, int bottom_right_x, int bottom_right_y) {
        try {
            JXLog.d_method(TAG, "cpcl_drawBox", lineWidth, top_left_x, top_left_y, bottom_right_x, bottom_right_y);
            return JXExecutors.printer().execute(() -> this.cpcl.drawBox(lineWidth, top_left_x, top_left_y, bottom_right_x, bottom_right_y)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawLine(int lineWidth, int start_x, int start_y, int end_x, int end_y) {
        try {
            JXLog.d_method(TAG, "cpcl_drawLine", lineWidth, start_x, start_y, end_x, end_y);
            return JXExecutors.printer().execute(() -> this.cpcl.drawLine(lineWidth, start_x, start_y, end_x, end_y)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawMultipleLineText(String text, int fontSize, int start_x, int start_y, int end_x, int lineSpace, int bold, boolean reverse, boolean underline) {
        try {
            JXLog.d_method(TAG, "drawMultipleLineText", text, fontSize, start_x, start_y, end_x, lineSpace, bold, reverse, underline);
            return JXExecutors.printer().execute(() -> this.cpcl.drawMultipleLineText(text, fontSize, start_x, start_y, end_x, lineSpace, bold, reverse, underline)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawText(int text_x, int text_y, String text, int fontSize, int rotate, int bold, boolean reverse, boolean underline) {
        try {
            JXLog.d_method(TAG, "cpcl_drawText", text_x, text_y, text, fontSize, rotate, bold, reverse, underline);
            return JXExecutors.printer().execute(() -> this.cpcl.drawText(text_x, text_y, text, fontSize, rotate, bold, reverse, underline)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawText(int text_x, int text_y, int width, int height, String text, int fontSize, int rotate, int bold, boolean underline, boolean reverse) {
        try {
            JXLog.d_method(TAG, "cpcl_drawText", text_x, text_y, width, height, text, fontSize, rotate, bold, underline, reverse);
            return JXExecutors.printer().execute(() -> this.cpcl.drawText(text_x, text_y, width, height, text, fontSize, rotate, bold, underline, reverse)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawWatermark(int text_x, int text_y, String text, int fontSize, @Nullable Integer density) {
        try {
            JXLog.d_method(TAG, "cpcl_drawWatermark", text_x, text_y, text, fontSize, density);
            return JXExecutors.printer().execute(() -> this.cpcl.drawWatermark(text_x, text_y, text, fontSize, density)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawBarCode(int start_x, int start_y, String text, int type, int rotate, int lineWidth, int height) {
        try {
            JXLog.d_method(TAG, "cpcl_drawBarCode", start_x, start_y, text, type, rotate, lineWidth, height);
            return JXExecutors.printer().execute(() -> this.cpcl.drawBarCode(start_x, start_y, text, type, rotate, lineWidth, height)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawBarCode(int start_x, int start_y, String text, int type, int rotate, int lineWidth, int height, int fontSize, int topMargin) {
        try {
            JXLog.d_method(TAG, "cpcl_drawBarCode", start_x, start_y, text, type, rotate, lineWidth, height, fontSize, topMargin);
            return JXExecutors.printer().execute(() -> this.cpcl.drawBarCode(start_x, start_y, text, type, rotate, lineWidth, height, fontSize, topMargin)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawQrCode(int start_x, int start_y, String text, int ver, int lel) {
        try {
            JXLog.d_method(TAG, "cpcl_drawQrCode", start_x, start_y, text, ver, lel);
            return JXExecutors.printer().execute(() -> this.cpcl.drawQrCode(start_x, start_y, text, ver, lel)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawGraphic(int start_x, int start_y, int bmp_size_x, int bmp_size_y, Bitmap bmp) {
        try {
            JXLog.d_method(TAG, "cpcl_drawGraphic", start_x, start_y, bmp_size_x, bmp_size_y, bmp);
            return JXExecutors.printer().execute(() -> this.cpcl.drawGraphic(start_x, start_y, bmp_size_x, bmp_size_y, bmp)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public JXPrinterStatus cpcl_printerStatus() {
        try {
            JXLog.d_method(TAG, "cpcl_info_printer_status", new Object[0]);
            return JXExecutors.printer().execute(() -> this.cpcl.printerStatus()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean cpcl_feed() {
        try {
            JXLog.d_method(TAG, "cpcl_feed", new Object[0]);
            return JXExecutors.printer().execute(() -> this.cpcl.feed()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean cpcl_drawBarCode(int start_x, int start_y, int end_x, int end_y, String text, int type, int rotate, int lineWidth, int height, int direction) {
        try {
            JXLog.d_method(TAG, "cpcl_drawBarCode", start_x, start_y, end_x, end_y, text, type, rotate, lineWidth, height, direction);
            return JXExecutors.printer().execute(() -> this.cpcl.drawBarCode(start_x, start_y, end_x, end_y, text, type, rotate, lineWidth, height, direction)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_reset() {
        try {
            JXLog.d_method(TAG, "esc_reset", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_reset()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_write_bytes(byte[] bytes) {
        try {
            JXLog.d_method(TAG, "esc_write_bytes", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_write_bytes(bytes)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_read_bytes(byte[] bytes) {
        try {
            JXLog.d_method(TAG, "esc_read_bytes", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_read_bytes(bytes)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_clear() {
        try {
            JXLog.d_method(TAG, "esc_clear", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_clear()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_text(@NonNull String text) {
        try {
            JXLog.d_method(TAG, "esc_write_text ", text);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_text(text)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_bold(boolean isBold) {
        try {
            JXLog.d_method(TAG, "esc_write_text ", isBold);
            return JXExecutors.printer().execute(() -> this.esc.esc_bold(isBold)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_underline(int n) {
        try {
            JXLog.d_method(TAG, "esc_underline ", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_underline(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_formfeed() {
        try {
            JXLog.d_method(TAG, "esc_print_formfeed ", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_formfeed()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_label() {
        try {
            JXLog.d_method(TAG, "esc_print_label", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_label()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_next_horizontal_tab() {
        try {
            JXLog.d_method(TAG, "esc_next_horizontal_tab ", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_next_horizontal_tab()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_left_black_label() {
        try {
            JXLog.d_method(TAG, "esc_left_black_label", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_left_black_label()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_formfeed(int n) {
        try {
            JXLog.d_method(TAG, "esc_print_formfeed", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_formfeed(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_formfeed_row(int n) {
        try {
            JXLog.d_method(TAG, "esc_print_formfeed_row", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_formfeed_row(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_character_code_page(int n) {
        try {
            JXLog.d_method(TAG, "esc_character_code_page", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_character_code_page(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_enter() {
        try {
            JXLog.d_method(TAG, "esc_print_enter", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_enter()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_right_spacing(int n) {
        try {
            JXLog.d_method(TAG, "esc_right_spacing", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_right_spacing(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_mode(int n) {
        try {
            JXLog.d_method(TAG, "esc_print_mode", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_mode(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_absolute_print_position(int position) {
        try {
            int nL = position & 0xFF;
            int nH = position >> 8 & 0xFF;
            JXLog.d_method(TAG, "esc_absolute_print_position", nL, nH);
            return JXExecutors.printer().execute(() -> this.esc.esc_absolute_print_position(nL, nH)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_bitmap_mode(int m, Bitmap bitmap) {
        try {
            JXLog.d_method(TAG, "esc_bitmap_mode", m, bitmap);
            return JXExecutors.printer().execute(() -> this.esc.esc_bitmap_mode(m, bitmap)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_raster_image(Bitmap bitmap) {
        try {
            JXLog.d_method(TAG, "esc_raster_image", bitmap);
            return JXExecutors.printer().execute(() -> this.esc.esc_raster_image(bitmap)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_align(int n) {
        try {
            JXLog.d_method(TAG, "esc_align", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_align(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_character_size(int n) {
        try {
            JXLog.d_method(TAG, "esc_character_size", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_character_size(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_font(int n) {
        try {
            JXLog.d_method(TAG, "esc_font", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_font(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_national_character_set(int n) {
        try {
            JXLog.d_method(TAG, "esc_national_character_set", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_national_character_set(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_rotate(int n) {
        try {
            JXLog.d_method(TAG, "esc_rotate", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_rotate(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_relative_print_position(int n) {
        try {
            int nL = n & 0xFF;
            int nH = n >> 8 & 0xFF;
            JXLog.d_method(TAG, "esc_relative_print_position", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_relative_print_position(nL, nH)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_black_white_reverse(boolean enable) {
        try {
            JXLog.d_method(TAG, "esc_black_white_reverse", enable);
            return JXExecutors.printer().execute(() -> this.esc.esc_black_white_reverse(enable)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_barcode_1d(int HRI_position, int HRI_font, int width, int height, int type, String content) {
        try {
            JXLog.d_method(TAG, "esc_barcode_1d", HRI_position, HRI_font, width, height, type, content);
            return JXExecutors.printer().execute(() -> this.esc.esc_barcode_1d(HRI_position, HRI_font, width, height, type, content)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_barcode_2d(int size, String content) {
        try {
            JXLog.d_method(TAG, "esc_print_barcode_2d", size, content);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_barcode_2d(size, content)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_barcode_2d(int size, int qrVersion, int level, String content) {
        try {
            JXLog.d_method(TAG, "esc_print_barcode_2d", size, qrVersion, level, content);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_barcode_2d(size, qrVersion, level, content)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_default_line_height() {
        try {
            JXLog.d_method(TAG, "esc_default_line_height", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_default_line_height()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_line_height(int n) {
        try {
            JXLog.d_method(TAG, "esc_line_height", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_line_height(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_horizontal_tab_position(int[] n) {
        try {
            JXLog.d_method(TAG, "esc_horizontal_tab_position", new Object[]{n});
            return JXExecutors.printer().execute(() -> this.esc.esc_horizontal_tab_position(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_left_margin(int n) {
        try {
            int nL = n & 0xFF;
            int nH = n >> 8 & 0xFF;
            JXLog.d_method(TAG, "esc_left_margin", nL, nH);
            return JXExecutors.printer().execute(() -> this.esc.esc_left_margin(nL, nH)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_move_unit(int x, int y) {
        try {
            JXLog.d_method(TAG, "esc_move_unit", x, y);
            return JXExecutors.printer().execute(() -> this.esc.esc_move_unit(x, y)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_select_cutting_mode() {
        try {
            JXLog.d_method(TAG, "esc_select_cutting_mode", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_select_cutting_mode()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_chinese_mode(boolean b) {
        try {
            JXLog.d_method(TAG, "esc_chinese_mode", b);
            return JXExecutors.printer().execute(() -> this.esc.esc_chinese_mode(b)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_chinese_character_mode(int n) {
        try {
            JXLog.d_method(TAG, "esc_chinese_character_mode", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_chinese_character_mode(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_chinese_character_underline_mode(int n) {
        try {
            JXLog.d_method(TAG, "esc_chinese_character_underline_mode", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_chinese_character_underline_mode(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_define_chinese_character(int c2, byte[] data) {
        try {
            JXLog.d_method(TAG, "esc_define_chinese_character", c2);
            return JXExecutors.printer().execute(() -> this.esc.esc_define_chinese_character(c2, data)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_chinese_character_twice_height_width(boolean b) {
        try {
            JXLog.d_method(TAG, "esc_chinese_character_twice_height_width", b);
            return JXExecutors.printer().execute(() -> this.esc.esc_chinese_character_twice_height_width(b)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_to_right_black_label() {
        try {
            JXLog.d_method(TAG, "esc_print_to_right_black_label", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_to_right_black_label()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_to_label() {
        try {
            JXLog.d_method(TAG, "esc_print_to_label", new Object[0]);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_to_label()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_select_cutting_mode(int n) {
        try {
            JXLog.d_method(TAG, "esc_select_cutting_mode", n);
            return JXExecutors.printer().execute(() -> this.esc.esc_select_cutting_mode(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_print_grating_bitmap(int m, Bitmap bitmap) {
        try {
            JXLog.d_method(TAG, "esc_print_grating_bitmap", m, bitmap);
            return JXExecutors.printer().execute(() -> this.esc.esc_print_grating_bitmap(m, bitmap)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean esc_define_print_download_bitmap(int x, int y, byte[] data, int m) {
        try {
            JXLog.d_method(TAG, "esc_define_print_download_bitmap", x, y, data, m);
            return JXExecutors.printer().execute(() -> this.esc.esc_define_print_download_bitmap(x, y, data, m)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public JXPrinterStatus gj_info_printer_status() {
        JXLog.d_method(TAG, "info_printer_status", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_printer_status(0)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public JXPrinterStatus gj_info_printer_status(int resOffset) {
        JXLog.d_method(TAG, "info_printer_status", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_printer_status(resOffset)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public JXHeadAndBatteryInfo gj_info_head_temperature_voltage() {
        JXLog.d_method(TAG, "gj_info_head_temperature_voltage", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_head_temperature_voltage()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public JXSupportInfo gj_info_support() {
        JXLog.d_method(TAG, "gj_info_support", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_support()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean gj_test_device_legality() {
        JXLog.d_method(TAG, "gj_test_device_legality", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_device_legality()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public String gj_info_firmware_version() {
        JXLog.d_method(TAG, "gj_info_firmware_version", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_firmware_version()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public JXUsageDataInfo gj_info_usage_data() {
        JXLog.d_method(TAG, "gj_info_usage_data", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_usage_data()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public String gj_info_configuration(int id) {
        JXLog.d_method(TAG, "gj_info_usage_data", id);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_configuration(id)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean gj_set_configuration(int id, String value) {
        JXLog.d_method(TAG, "gj_set_configuration", value);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_configuration(id, value)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_set_save_configuration() {
        JXLog.d_method(TAG, "gj_set_save_configuration", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_save_configuration()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_set_power_off() {
        JXLog.d_method(TAG, "gj_set_power_off", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_power_off()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_print_x301_qr() {
        JXLog.d_method(TAG, "gj_print_x301_qr", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_print_x301_qr()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_print_self_check_page() {
        JXLog.d_method(TAG, "gj_print_self_check_page", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_print_self_check_page()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public int gj_test_print_speed() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_print_speed()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return -1;
        }
    }

    public JXOptocouplerTestResult gj_test_optocoupler(int pageLength) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_optocoupler(pageLength, 0)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public int gj_test_feed_speed() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_feed_speed()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return -1;
        }
    }

    public boolean gj_test_paper_feed_accuracy() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_paper_feed_accuracy()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_test_print_accuracy() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_print_accuracy()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_test_print_quality_blackness() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_print_quality_blackness()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public int gj_info_single_byte_font_lib_count() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_single_byte_font_lib_count()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return -1;
        }
    }

    public int gj_info_double_byte_font_lib_count() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_double_byte_font_lib_count()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return -1;
        }
    }

    public JXFontLibInfo gj_info_single_byte_font_lib(int index) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_single_byte_font_lib(index)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public JXFontLibInfo gj_info_double_byte_font_lib(int index) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_double_byte_font_lib(index)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean gj_set_label_size(int widthMM, int height, int paperType) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_label_size(widthMM, height, paperType)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_print_dot_matrix(int widthMM, int height, float density) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_print_dot_matrix(widthMM, height, density)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_test_print_line(int widthMM, int count, int interval, int startMarginMM, int endMarginMM) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_print_line(widthMM, count, interval, startMarginMM, endMarginMM)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_print_repeat_forward(int n) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_print_forward_repeat(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_print_repeat_backward(int n) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_print_backward_repeat(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_set_mode_bluetooth_upgrade() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_mode_bluetooth_upgrade()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean gj_set_mode_usb_upgrade() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_mode_usb_upgrade()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public JXOptocouplerInfo gj_info_optocoupler_volume() {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_optocoupler_volume()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean gj_motor_control(int cmdId, int k, int p) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_motor_control(cmdId, k, p)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public JXBTTransferResult gj_test_bluetooth_transfer_speed(int testId, int length, boolean isRandom, int timeout) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_bluetooth_transfer_speed(testId, length, isRandom, timeout)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean gj_test_communication(int testId, int length) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_communication(testId, length)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public JXCommunicationError gj_test_communication_continuously(int cmdType, int packageSize, int packageCount, boolean isRandomData, int intervalMills) {
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_test_communication_continuously(cmdType, packageSize, packageCount, isRandomData, intervalMills)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return new JXCommunicationError(0, null);
        }
    }

    public JXUpgradeService gj_upgrade_firmware(int connectType, byte[] file, JXUpgradeListener listener) {
        if (file != null && file.length > 0 && listener != null) {
            JXUpgradeService service = new JXUpgradeService("JXFirmwareUpgrade");
            service.upgradeFirmware(connectType, this.gj, file, listener);
            return service;
        }
        return null;
    }

    public JXUpgradeService gj_upgrade_font(int connectType, byte[] file, JXUpgradeListener listener) {
        if (file != null && file.length > 0 && listener != null) {
            JXUpgradeService service = new JXUpgradeService("JXFirmwareUpgrade");
            service.upgradeFont(connectType, this.gj, file, listener);
            return service;
        }
        return null;
    }

    @Deprecated
    public boolean global_page_setup(int width, int height, int paperType) {
        try {
            return JXExecutors.printer().execute(() -> this.global.pageSetup(width, height, (byte)paperType)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public void global_set_white_bg_mode(boolean isWhiteBG) {
        this.global.setWhiteBGMode(isWhiteBG);
    }

    @Deprecated
    public boolean global_page_print() {
        try {
            return JXExecutors.printer().execute(() -> this.global.pagePrint()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    @Deprecated
    public boolean global_page_print(boolean isUpsideDown, int times) {
        try {
            return JXExecutors.printer().execute(() -> this.global.pagePrint(isUpsideDown, times)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean global_x35_page_print(boolean isUpsideDown) {
        try {
            return JXExecutors.printer().execute(() -> this.global.x35_pagePrint(isUpsideDown)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean global_x35_unwind_before_print(int line) {
        try {
            return JXExecutors.printer().execute(() -> this.global.x35_unwind_before_print(line)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean global_x35_unwind_before_print() {
        try {
            return JXExecutors.printer().execute(() -> this.global.x35_unwind_before_print()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean global_x35_feed_after_print(int line) {
        try {
            return JXExecutors.printer().execute(() -> this.global.x35_feed_after_print(line)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean global_x35_feed_after_print() {
        try {
            return JXExecutors.printer().execute(() -> this.global.x35_feed_after_print()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean global_x35_set_position_type_after_print(int positionType) {
        try {
            return JXExecutors.printer().execute(() -> this.global.x35_set_position_type_after_print(positionType)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    @Deprecated
    public boolean global_draw_box(int start_x, int start_y, int width, int height, int lineWidth, boolean fullLine) {
        try {
            return JXExecutors.printer().execute(() -> this.global.drawBox(start_x, start_y, width, height, lineWidth, fullLine)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    @Deprecated
    public boolean global_draw_line(int start_x, int start_y, int end_x, int end_y, int lineWidth, boolean fullLine) {
        try {
            return JXExecutors.printer().execute(() -> this.global.drawLine(start_x, start_y, end_x, end_y, lineWidth, fullLine)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    @Deprecated
    public boolean global_draw_text(int start_x, int start_y, int end_x, int end_y, int fontSize, int rotate, boolean bold, boolean reverse, boolean underline, boolean singleLine, String content) {
        try {
            return JXExecutors.printer().execute(() -> this.global.drawText(start_x, start_y, end_x, end_y, content, fontSize, rotate, bold, reverse, underline, singleLine)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean global_draw_graphic(int start_x, int start_y, Bitmap bmp) {
        try {
            return JXExecutors.printer().execute(() -> this.global.drawGraphic(start_x, start_y, bmp)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    @Deprecated
    public boolean global_draw_barcode(int start_x, int start_y, int width, int height, int rotate, String content) {
        try {
            return JXExecutors.printer().execute(() -> this.global.drawBarcode1D(start_x, start_y, width, height, content, rotate, BarcodeFormat.CODE_128)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    @Deprecated
    public boolean global_draw_qrcode(int start_x, int start_y, int size, int rotate, String content) {
        try {
            return JXExecutors.printer().execute(() -> this.global.drawQrCode(start_x, start_y, size, content, rotate)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean global_feed() {
        try {
            return JXExecutors.printer().execute(() -> this.global.feed()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public void tspl_setDPI(PrinterDPI dpi) {
        this.tspl.tspl_setDPI(dpi);
    }

    public void tspl_expandMaxPrintSize(int widthInMM, int heightInMM) {
        this.tspl.tspl_expandMaxPrintSize(widthInMM, heightInMM);
    }

    public boolean tspl_writeCmd(String cmd) {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_writeCmd(cmd, true)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public JXPrinterStatus tspl_status() {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_status()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean tspl_pageSetup(int widthInMM, int heightInMM, int gapInMM) {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_pageSetup(widthInMM, heightInMM, gapInMM)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean tspl_drawGraphic(int start_x, int start_y, Bitmap bmp) {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_drawGraphic(start_x, start_y, bmp)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean tspl_print(int count, boolean isReverse) {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_print(count, isReverse)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean tspl_feed(int line) {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_feed(line)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean tspl_formFeed() {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_formFeed()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean tspl_speed(int speed) {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_speed(speed)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean tspl_home() {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_home()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean tspl_density(int density) {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_density(density)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean tspl_clear() {
        try {
            return JXExecutors.printer().execute(() -> this.tspl.tspl_clear()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean compress_print(Bitmap bitmap, boolean compress, @Nullable String printerModel) {
        try {
            return JXExecutors.printer().execute(() -> this.lowM.checkMaxPrintWidth(this.gj) && this.lowM.print_graphic(bitmap, compress, true, printerModel)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public void clear() {
        JXLog.d(TAG, "reset all tasks");
        try {
            JXExecutors.shutdown();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "reset exception " + e.getMessage());
        }
    }

    public JXPrinterStatus info_printer_status() {
        return this.gj_info_printer_status();
    }

    public boolean set_print_quality(String value) {
        JXLog.d_method(TAG, "set_print_darkness", value);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_config(22, value)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public String get_print_darkness() {
        JXLog.d_method(TAG, "get_print_darkness", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_configuration(21)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public String get_print_quality() {
        JXLog.d_method(TAG, "get_print_quality", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_configuration(22)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean set_print_darkness(String value) {
        JXLog.d_method(TAG, "set_print_darkness", value);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_config(21, value)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean set_print_unlock() {
        JXLog.d_method(TAG, "set_print_darkness", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.mAPI.isUnlock()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }
}

