/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.graphics.Bitmap;
import android.text.TextUtils;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.JXCommand;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.jxsdk.PrinterDPI;
import com.jxit.printer.model.JXPrinterStatus;

public class TSPL_CMD
extends JXCommand {
    private static final int MAX_PRINT_WIDTH_MM = 108;
    private static final int MAX_PRINT_HEIGHT_MM = 180;
    private int maxWidthInMM = 108;
    private int maxHeightInMM = 180;
    private PrinterDPI printerDPI = PrinterDPI.DPI200;

    public TSPL_CMD(JXInterfaceAPI api) {
        super(api);
    }

    public void tspl_setDPI(PrinterDPI dpi) {
        this.printerDPI = dpi;
    }

    public void tspl_expandMaxPrintSize(int widthInMM, int heightInMM) {
        if (widthInMM > 0 && widthInMM > this.maxWidthInMM) {
            this.maxWidthInMM = widthInMM;
        }
        if (heightInMM > 0 && heightInMM > this.maxHeightInMM) {
            this.maxHeightInMM = heightInMM;
        }
    }

    public boolean tspl_pageSetup(int widthInMM, int heightInMM, int gapInMM) {
        if (widthInMM <= 0 || heightInMM <= 0) {
            return false;
        }
        if (widthInMM > this.maxWidthInMM) {
            widthInMM = this.maxWidthInMM;
        }
        if (heightInMM > this.maxHeightInMM) {
            heightInMM = this.maxHeightInMM;
        }
        String cmd = String.format("SIZE %d mm, %d mm", widthInMM, heightInMM);
        this.tspl_writeCmd(cmd, true);
        this.tspl_writeCmd(String.format("GAP %d mm,0", gapInMM), true);
        return true;
    }

    public boolean tspl_writeCmd(String cmd, boolean end) {
        byte[] data;
        if (TextUtils.isEmpty((CharSequence)cmd)) {
            return false;
        }
        cmd = end ? cmd + "\r\n" : cmd;
        JXLog.d(this.TAG, "tspl_writeCmd: " + cmd);
        try {
            data = cmd.getBytes();
        }
        catch (Exception var4) {
            JXLog.e(this.TAG, "String getBytes('GBK') failed");
            return false;
        }
        return this.mAPI.isConnected() && this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(data, 0, data.length);
    }

    public JXPrinterStatus tspl_status() {
        byte[] cmd = new byte[]{27, 33, 63};
        byte[] rep = new byte[1];
        if (this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.readBuffer(rep, 0, rep.length, 5000)) {
            JXPrinterStatus status = new JXPrinterStatus();
            if (rep[0] == 0) {
                status.isReady = true;
            } else if ((rep[0] ^ 0x111111) == 0x111111) {
                status.isUnknownError = true;
            } else {
                if ((rep[0] & 1) == 1) {
                    status.isCoverOpened = true;
                }
                if ((rep[0] >> 1 & 1) == 1) {
                    status.isUnknownError = true;
                }
                if ((rep[0] >> 2 & 1) == 1) {
                    status.isNoPaper = true;
                }
                if ((rep[0] >> 3 & 1) == 1) {
                    status.isUnknownError = true;
                }
                if ((rep[0] >> 4 & 1) == 1) {
                    status.isReady = true;
                }
                if ((rep[0] >> 5 & 1) == 1) {
                    status.isPrinting = true;
                }
                if ((rep[0] >> 7 & 1) == 1) {
                    status.isUnknownError = true;
                    status.isReady = false;
                }
            }
            return status;
        }
        return null;
    }

    public boolean tspl_drawGraphic(int start_x, int start_y, Bitmap bmp) {
        int bmp_size_x = bmp.getWidth();
        int bmp_size_y = bmp.getHeight();
        int byteWidth = (bmp_size_x - 1) / 8 + 1;
        int byteHeight = bmp_size_y;
        if (byteWidth <= 0) {
            return false;
        }
        if (byteHeight <= 0) {
            return false;
        }
        int unitHeight = 2048 / byteWidth;
        int unitCount = (byteHeight - 1) / unitHeight + 1;
        for (int n = 0; n < unitCount; ++n) {
            boolean success;
            int startY = n * unitHeight;
            int endY = startY + unitHeight > bmp_size_y ? bmp_size_y : startY + unitHeight;
            int byteLen = (endY - startY) * byteWidth;
            byte[] dataByte = new byte[byteLen];
            for (int y = startY; y < endY; ++y) {
                for (int x = 0; x < byteWidth * 8; ++x) {
                    boolean isWhite;
                    if (x < bmp_size_x) {
                        int color = bmp.getPixel(x, y);
                        int A = color >> 24 & 0xFF;
                        int R = color >> 16 & 0xFF;
                        int G = color >> 8 & 0xFF;
                        int B = color & 0xFF;
                        isWhite = A == 0 || (double)R * 0.3 + (double)G * 0.59 + (double)B * 0.11 > 127.0;
                    } else {
                        isWhite = true;
                    }
                    if (!isWhite) continue;
                    int n2 = (y - startY) * byteWidth + x / 8;
                    dataByte[n2] = (byte)(dataByte[n2] | 128 >> x % 8);
                }
            }
            int curUnitHeight = n == unitCount - 1 ? byteHeight - n * unitHeight : unitHeight;
            String cmdHeader = "BITMAP " + start_x + "," + (start_y + startY) + "," + byteWidth + "," + curUnitHeight + "," + 0 + ",";
            boolean bl = success = this.tspl_writeCmd(cmdHeader, false) && this.mAPI.writeBuffer(dataByte, 0, dataByte.length);
            if (!success) {
                return false;
            }
            this.mAPI.writeBuffer(new byte[]{13, 10}, 0, 2);
        }
        return true;
    }

    public boolean tspl_print(int count, boolean isReverse) {
        if (count < 0) {
            count = 1;
        }
        if (count > 65535) {
            count = 65535;
        }
        String cmd = String.format("PRINT %d,1", count);
        return this.tspl_direction(isReverse) && this.tspl_writeCmd(cmd, true);
    }

    public boolean tspl_feed(int line) {
        if (line > 0) {
            String cmd = "FEED " + line;
            return this.tspl_writeCmd(cmd, true);
        }
        return false;
    }

    public boolean tspl_formFeed() {
        String cmd = "FORMFEED";
        return this.tspl_writeCmd(cmd, true);
    }

    public boolean tspl_speed(int speed) {
        String _speed = speed <= 1 ? "1.5" : (speed == 2 ? "2.0" : (speed == 3 ? "3.0" : "4.0"));
        String cmd = "SPEED " + _speed;
        return this.tspl_writeCmd(cmd, true);
    }

    public boolean tspl_home() {
        String cmd = "HOME";
        return this.tspl_writeCmd(cmd, true);
    }

    public boolean tspl_density(int density) {
        if (density < 0) {
            density = 0;
        }
        if (density > 15) {
            density = 15;
        }
        String cmd = "DENSITY " + density;
        return this.tspl_writeCmd(cmd, true);
    }

    private boolean tspl_direction(boolean isReverse) {
        String cmd = "DIRECTION " + (isReverse ? 1 : 0);
        return this.tspl_writeCmd(cmd, true);
    }

    public boolean tspl_clear() {
        String cmd = "CLS";
        return this.tspl_writeCmd(cmd, true);
    }
}

