package com.jxit.sdkdemo.fragment;

import static java.lang.Math.sin;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.BarcodeFormat;
import com.jxit.printer.jxsdk.JXPrinter;
import com.jxit.printer.model.JXPrinterStatus;
import com.jxit.printer.utils.BitmapTools;
import com.jxit.sdkdemo.BaseActivity;
import com.jxit.sdkdemo.HomeActivity;
import com.jxit.sdkdemo.MainActivity;
import com.jxit.sdkdemo.PrinterManager;
import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.databinding.FragmentCpclBinding;

import java.io.IOException;
import java.io.InputStream;

@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
public class CPCLFragment extends Fragment implements View.OnClickListener {
    private FragmentCpclBinding bd;
    private static final String TAG = "CPCLFragment";

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (bd == null) {
            bd = FragmentCpclBinding.inflate(inflater, container, false);
        }
        bd.setClickHandler(this);
        return bd.getRoot();
    }

    void drawText(JXPrinter printer) {
        int y = 0;
        int maxWidth = HomeActivity.selectMaxPrinterWidth;
        printer.cpcl_pageSetup(maxWidth, 800, 0);
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.TextDemo), 24,0,0,false,false );
        y += 30;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.TextBlod), 24,0,1,false,false );
        y += 30;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.TextUnderLine), 24,0,0,false,true );
        y += 30;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.TextReverse), 24,0,0,true,false );
        y += 30;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.TextDemo), 24,0,1,true,true );
        y += 30;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.TextFont), 24,0,0,false,false );
        y += 30;
        printer.cpcl_drawText(8, y, "2mm", 16,0,0,false,false );
        printer.cpcl_drawText(56, y, "3mm", 24,0,0,false,false );
        printer.cpcl_drawText(128, y, "4mm", 32,0,0,false,false );
        printer.cpcl_drawText(224, y, "5mm", 40,0,0,false,false );
        printer.cpcl_drawText(344, y, "6mm", 48,0,0,false,false );
        y += 56;
        printer.cpcl_drawText(8, y, "7mm", 56,0,0,false,false );
        printer.cpcl_drawText(176, y, "8mm", 64,0,0,false,false );
        printer.cpcl_drawText(368, y, "9mm", 72,0,0,false,false );
        y += 80;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.TextRotate), 24,0,0,false,false );
        y += 30;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.TextRotate0), 24,0,0,false,false );
        y += 80;
        printer.cpcl_drawText(176, y, getActivity().getString(R.string.TextRotate90), 24,1,0,false,false );
        y += 30;
        printer.cpcl_drawText(176, y, getActivity().getString(R.string.TextRotate180), 24,2,0,false,false );
        y += 80;
        printer.cpcl_drawText(176, y, getActivity().getString(R.string.TextRotate270), 24,3,0,false,false );
        printer.cpcl_print(0, 0);
    }
    void drawGraphic(JXPrinter printer) {
        int maxWidth = HomeActivity.selectMaxPrinterWidth;
        printer.cpcl_pageSetup(maxWidth, 800, 0);
        printer.cpcl_drawText(8, 0, getActivity().getString(R.string.ImagePrint), 24,0,0,false,false );
        try {
            InputStream is = getResources().getAssets().open("logo.jpeg");
            Bitmap bmp = BitmapFactory.decodeStream(is);
            printer.cpcl_drawGraphic(8, 30,bmp.getWidth(),bmp.getHeight(), bmp);
        } catch (Exception e) {
            e.printStackTrace();
        }
        printer.cpcl_print(0, 0);
    }
    void drawBarcode1D(JXPrinter printer) {
        int maxWidth = HomeActivity.selectMaxPrinterWidth;
        printer.cpcl_pageSetup(maxWidth, 800, 0);
        String type = getActivity().getString(R.string.Category);
        String content = getActivity().getString(R.string.Content);
        int y = 0;
        printer.cpcl_drawText(8, y, type+"：CODE128; "+content+"：0123456789\n"+getActivity().getString(R.string.BarcodeNoText)+":", 24,0,0,false,false );
        y += 70;
        printer.cpcl_drawBarCode(8, y, "0123456789",1, 0,  3,80);
        y += 100;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.BarcodeTextBelow)+":\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "0123456789",1, 0,  3,80,24,0);
        y += 130;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.bar_Rotate270)+" 90，180，270\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "123456789",1, 1,  3,80,24,0);
        printer.cpcl_drawBarCode(8, y, "123456789",1, 2,  3,80,24,0);
        printer.cpcl_drawBarCode(8, y, "123456789",1, 3,  3,80,24,0);
        printer.cpcl_print(0, 0);
    }
    void drawBarcode1D2(JXPrinter printer){
        int maxWidth = HomeActivity.selectMaxPrinterWidth;
        printer.cpcl_pageSetup(maxWidth, 800, 0);
        String type = getActivity().getString(R.string.Category);
        String content = getActivity().getString(R.string.Content);
        int y = 0;
        printer.cpcl_drawText(8, y, type+"：UPC_A; "+content+"：123456789012", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "12345678901",6, 0,  3,100);
        y += 110;
        printer.cpcl_drawText(8, y, type+"：UPC_E;" +content+"：04029311\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "0402931",7, 0,  3,100);
        y += 110;
        printer.cpcl_drawText(8, y, type+"：EAN_8; " +content+"：12345670\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "1234567",4, 0,  3,100);
        y += 110;
        printer.cpcl_drawText(8, y, type+"：EAN_13; " +content+"：1234567890128\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "123456789012",5, 0,  3,100);
        y += 110;
        printer.cpcl_drawText(8, y, type+"：CODE_39; " +content+"：123456789\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "123456789",0, 0,  3,100);
        printer.cpcl_print(0, 0);
    }
    void drawBarcode1D3(JXPrinter printer){
        int maxWidth = HomeActivity.selectMaxPrinterWidth;
        printer.cpcl_pageSetup(maxWidth, 800, 0);
        String type = getActivity().getString(R.string.Category);
        String content = getActivity().getString(R.string.Content);
        int y = 0;
        printer.cpcl_drawText(8, y, type+"：CODE128; " +content+"：123456789\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "123456789",1, 0,  3,100);
        y += 110;
        printer.cpcl_drawText(8, y, type+"：CODE_93; " +content+"：123456789\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "123456789",2, 0,  3,100);
        y += 110;
        printer.cpcl_drawText(8, y, type+"：CODABAR; " +content+"：123456789\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "123456789",3, 0,  3,100);
        y += 110;
        printer.cpcl_drawText(8, y, type+"：ITF; " +content+"：1234567890\n", 24,0,0,false,false );
        y += 40;
        printer.cpcl_drawBarCode(8, y, "1234567890",8, 0,  3,100);
        printer.cpcl_print(0, 0);
    }
    void drawBarcode2D(JXPrinter printer) {
        int maxWidth = HomeActivity.selectMaxPrinterWidth;
        printer.cpcl_pageSetup(maxWidth, 800, 0);
        String type = getActivity().getString(R.string.Category);
        String content = getActivity().getString(R.string.Content);

        int y = 0;
        printer.cpcl_drawText(8, y, getActivity().getString(R.string.QrcodePrint)+"：\n"+type+"：QR_CODE; "+content+"：1234567890\n", 24,0,0,false,false );
        y += 60;
        printer.cpcl_drawQrCode(8, y, "1234567890",  1, 9);
        printer.cpcl_print(0, 0);
    }
    void drawLine(JXPrinter printer) {
        int maxWidth = HomeActivity.selectMaxPrinterWidth;
        printer.cpcl_pageSetup(maxWidth, 400, 0);
        printer.cpcl_drawText(8, 0, getActivity().getString(R.string.LinePrint), 24,0,0,false,false );
        printer.cpcl_drawLine(5,8, 40, 200, 40);
        printer.cpcl_drawLine(5,8, 50, 8, 200);
        printer.cpcl_print(0, 0);
    }
    void  drawBox(JXPrinter printer){
        int maxWidth = HomeActivity.selectMaxPrinterWidth;
        printer.cpcl_pageSetup(maxWidth, 400, 0);
        printer.cpcl_drawText(8, 0, getActivity().getString(R.string.BoxPrint), 24,0,0,false,false );
        printer.cpcl_drawBox( 2,0, 40, 310, 110  );
        printer.cpcl_print(0, 0);
    }


    @Override
    public void onClick(View v) {
        JXInterfaceAPI api = PrinterManager.getInstance().getApi();
        if (api == null || !api.isConnected()) {
            ((BaseActivity) getActivity()).toast(R.string.warn_connect_printer);
            return;
        }
        JXPrinter printer = new JXPrinter(api);
        if (bd.btnPageAllCmd.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
//                drawText1(printer);
                drawText(printer);
                drawGraphic(printer);
                drawBarcode1D(printer);
                drawBarcode1D2(printer);
                drawBarcode1D3(printer);
                drawBarcode2D(printer);
                drawLine(printer);
                drawBox(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageText.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);

                drawText(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageGraphic.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                drawGraphic(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageBox.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                drawBox(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        }else if (bd.btnPageBarcode1D.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
//                drawBarcode1D(printer);
                drawBarcode1D2(printer);
//                drawBarcode1D3(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageBarcode2D.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                drawBarcode2D(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageLine.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                drawLine(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        }else if (bd.btnTest.equals(v)) {
//            draw();
        }
    }
}
