package com.jxit.sdkdemo.fragment;

import android.app.Activity;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.jxit.printer.jxapi.JXBluetoothAPI;
import com.jxit.printer.jxapi.JXTcpAPI;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.jxsdk.JXTcpListener;
import com.jxit.sdkdemo.BaseActivity;
import com.jxit.sdkdemo.PrinterActivity;
import com.jxit.sdkdemo.PrinterManager;
import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.TcpDevice;
import com.jxit.sdkdemo.adapter.BluetoothDeviceAdapter;
import com.jxit.sdkdemo.adapter.TcpDeviceAdapter;
import com.jxit.sdkdemo.databinding.FragmentBtConnectBinding;
import com.jxit.sdkdemo.databinding.FragmentTcpConnectBinding;

import java.util.Set;

public class TcpFragment extends Fragment implements JXTcpListener {
    private FragmentTcpConnectBinding bd;
    private JXTcpAPI mApi;
    private TcpDeviceAdapter mNewAdapter;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (bd == null) {
            bd = FragmentTcpConnectBinding.inflate(inflater, container, false);
            setLayout();
        }
        refreshLayout();
        return bd.getRoot();
    }

    private void setLayout() {
        mNewAdapter = new TcpDeviceAdapter(getContext());
        mNewAdapter.setOnItemClickListener((parent, view, position, id) -> {
            mApi.cancelDiscovery();
            mApi.closeConnection();
            TcpDevice device = mNewAdapter.getItem(position);
            new Thread(() -> {
                //连接打印机
                int  port = Integer.parseInt(bd.tcpEditPort.getText().toString());
                ((PrinterActivity) getActivity()).showProgress(R.string.bt_connecting);
                boolean connected =  mApi.openConnection(device.getIp(),port,2000);
                ((PrinterActivity) getActivity()).hideProgress();
                if (connected) {
                    PrinterManager.getInstance().setAPI(mApi, device);
                    getActivity().setResult(Activity.RESULT_OK);
                    getActivity().finish();
                    ((BaseActivity) getActivity()).toast(R.string.connect_success);
                } else {
                    ((BaseActivity) getActivity()).toast(R.string.connect_fail);
                }

                //listen bond broadcast
            }).start();
        });
        bd.lvNew.setAdapter(mNewAdapter);
        bd.lvNew.setLayoutManager(new LinearLayoutManager(getContext()));
        bd.ibDiscover.setOnClickListener(v -> {
            if (mApi.isWifiConnected()){
                mNewAdapter.setDataAndNotify(null);
                mApi.setOnScanListener(this);
                ((BaseActivity) getActivity()).toast(R.string.bt_start_discovery);
                mApi.startDiscovery(false);
            }else{
                ((BaseActivity) getActivity()).toast("请先连接wifi");
            }

        });


    }

    private void refreshLayout() {
        mApi = JXTcpAPI.getDefault(getContext());
        mApi.setOnScanListener(this);
        mApi.startDiscovery(false);
        if (PrinterManager.getInstance().isConnected(PrinterManager.CONNECT_WIFI)) {
            TcpDevice device = PrinterManager.getInstance().getConnectTcpDevice();
            if (device != null) {
                String title = getString(R.string.device_connected);
                bd.tvConnectedDevice.setText(String.format("%s: %s", title, device.getIp()));
            } else {
                bd.tvConnectedDevice.setText(R.string.no_device_connected);
            }
        }
    }
    @Override
    public void onReceive(String mfg,String model,String cmd,String ip,int port) {

    }

    @Override
    public void onAllReceive(String ip) {
        TcpDevice device = new TcpDevice();
        device.setIp(ip);
        if (mNewAdapter != null) {
            ((BaseActivity) getActivity()).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mNewAdapter.appendDataAndNotify(device);
                }
            });

        }

    }

    @Override
    public void onScanEnd() {
        mApi.cancelDiscovery();

    }
}
