/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxapi;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxapi.UnlockCmd;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.jxsdk.JXTcpListener;
import com.jxit.printer.model.JXPingIP;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JXTcpAPI
implements JXInterfaceAPI {
    private static final String TAG = JXTcpAPI.class.getSimpleName();
    private Context context;
    private static volatile JXTcpAPI mDefault;
    private WifiManager wifiManager;
    private ConnectivityManager connectivityManager;
    private JXTcpListener listener;
    private Boolean starScan = false;
    private String ip = "";
    private int port = 0;
    public static final int MAX_TIMEOUT = 50000;
    public static final int MIN_TIMEOUT = 200;
    public static final int Local_Port = 7300;
    public static final int Print_Port = 7200;
    private Socket ipSocket;
    private InputStream is = null;
    private OutputStream os = null;
    private DatagramSocket udpSocket;
    private Boolean socketConnected = false;
    private ThreadPoolExecutor threadPool;

    JXTcpAPI(Context context) {
        this.context = context;
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.wifiManager = (WifiManager)context.getSystemService("wifi");
        this.threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JXTcpAPI getDefault(@NonNull Context context) {
        if (mDefault != null) return mDefault;
        Class<JXTcpAPI> clazz = JXTcpAPI.class;
        synchronized (JXTcpAPI.class) {
            if (mDefault != null) return mDefault;
            mDefault = new JXTcpAPI(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mDefault;
        }
    }

    public boolean isWifiConnected() {
        if (this.connectivityManager == null) {
            this.connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        }
        NetworkInfo wifiNetworkInfo = this.connectivityManager.getNetworkInfo(1);
        return wifiNetworkInfo.isConnected();
    }

    public boolean isNotOccupied() {
        if (this.udpSocket != null) {
            JXLog.d(TAG, "isOccupied   udpSocket is not null");
            return false;
        }
        try {
            this.udpSocket = new DatagramSocket(7300);
            this.udpSocket.close();
            this.udpSocket = null;
            return true;
        }
        catch (SocketException e) {
            e.printStackTrace();
            JXLog.e(TAG, "isOccupied  Exception" + e.getMessage());
            return false;
        }
    }

    public void setOnScanListener(JXTcpListener listener) {
        this.listener = listener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean startDiscovery(Boolean sendBroadcast) {
        if (this.listener != null) {
            if (sendBroadcast.booleanValue()) {
                if (!this.isNotOccupied()) return false;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JXTcpAPI.this.startScan(10000);
                    }
                }).start();
                return true;
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JXTcpAPI.this.startScan();
                    }
                }).start();
            }
            return true;
        }
        JXLog.d(TAG, "startDiscovery   JXTcpListener is null");
        return false;
    }

    public boolean cancelDiscovery() {
        this.starScan = false;
        this.listener = null;
        return this.starScan == false;
    }

    public boolean openConnection(String ip, int port, int timeout) {
        try {
            if (timeout < 200) {
                timeout = 200;
            }
            if (timeout > 50000) {
                timeout = 50000;
            }
            JXLog.d(TAG, "openConnection   ip = " + ip + "  port = " + port);
            if (this.ipSocket != null) {
                this.ipSocket.close();
            }
            this.ip = ip;
            this.port = port;
            this.ipSocket = new Socket();
            InetSocketAddress socAddress = new InetSocketAddress(ip, port);
            this.ipSocket.connect(socAddress, timeout);
            this.ipSocket.setSendBufferSize(81920);
            JXLog.e(TAG, "openConnection  size =  " + this.ipSocket.getSendBufferSize());
            if (this.ipSocketConnected()) {
                this.ipSocket.setSoTimeout(5000);
                this.ipSocket.setTcpNoDelay(true);
                this.is = this.ipSocket.getInputStream();
                this.os = this.ipSocket.getOutputStream();
                JXLog.d(TAG, "openConnection ipSocketConnected()= true");
                return true;
            }
            this.closeConnection();
            return false;
        }
        catch (IOException var3) {
            var3.printStackTrace();
            JXLog.e(TAG, "openConnection exception: " + var3.getMessage());
            this.closeConnection();
            return false;
        }
    }

    private void startScan(int timeout) {
        try {
            long start_time = SystemClock.elapsedRealtime();
            if (this.udpSocket != null) {
                this.udpSocket.close();
                this.udpSocket = null;
            }
            this.udpSocket = new DatagramSocket(7300);
            this.responseUdp();
            byte[] buf = "mfg;model;cmd;ip;port;".getBytes("GBK");
            JXLog.d_bytes(TAG, "startScan  send cmd", buf);
            DatagramPacket send = new DatagramPacket(buf, 0, buf.length);
            send.setPort(7200);
            send.setAddress(InetAddress.getByName("255.255.255.255"));
            while (SystemClock.elapsedRealtime() - start_time < (long)timeout) {
                this.udpSocket.send(send);
                Thread.sleep(1000L);
            }
            this.udpSocket.close();
            this.udpSocket = null;
            if (this.listener != null) {
                this.listener.onScanEnd();
            }
        }
        catch (IOException | InterruptedException e) {
            if (this.listener != null) {
                this.listener.onScanEnd();
            }
            JXLog.e(TAG, "startScan  Exception" + e.getMessage());
        }
    }

    private void startScan() {
        if (this.starScan.booleanValue()) {
            this.starScan = false;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.starScan = true;
        String hostIP = this.getLocalIPAddress();
        int lastIndexOf = hostIP.lastIndexOf(".");
        final String substring = hostIP.substring(0, lastIndexOf + 1);
        JXLog.d(TAG, "startScan  dev ip  = " + hostIP);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int position = 2; position < 255 && JXTcpAPI.this.starScan.booleanValue(); ++position) {
                        String ip = substring + String.valueOf(position);
                        JXPingIP pingIP = new JXPingIP(ip, JXTcpAPI.this.listener);
                        JXTcpAPI.this.threadPool.execute(pingIP);
                        Thread.sleep(10L);
                    }
                    Thread.sleep(100L);
                    if (JXTcpAPI.this.listener != null) {
                        JXTcpAPI.this.listener.onScanEnd();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private String getLocalIPAddress() {
        if (this.wifiManager == null) {
            this.wifiManager = (WifiManager)this.context.getSystemService("wifi");
        }
        WifiInfo wifiInfo = this.wifiManager.getConnectionInfo();
        return this.intIP2StringIP(wifiInfo.getIpAddress());
    }

    private String intIP2StringIP(int ipAddress) {
        String ipString = "";
        if (ipAddress != 0) {
            ipString = (ipAddress & 0xFF) + "." + (ipAddress >> 8 & 0xFF) + "." + (ipAddress >> 16 & 0xFF) + "." + (ipAddress >> 24 & 0xFF);
        }
        return ipString;
    }

    private void responseUdp() {
        if (this.udpSocket == null) {
            return;
        }
        this.starScan = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    while (true) {
                        JXTcpAPI.this.udpSocket.receive(packet);
                        int length = packet.getLength();
                        String msg = new String(buf, 0, length);
                        int lastIndexOf = msg.lastIndexOf(";");
                        String[] response = (msg = msg.substring(0, lastIndexOf + 1)).split(";");
                        if (response.length < 5) continue;
                        String mfg = response[0];
                        String model = response[1];
                        String cmd = response[2].toUpperCase();
                        String tempIp = response[3];
                        int tempPort = Integer.parseInt(response[4]);
                        if (JXTcpAPI.this.listener == null) continue;
                        JXTcpAPI.this.listener.onReceive(mfg, model, cmd, tempIp, tempPort);
                    }
                }
                catch (IOException e) {
                    if (JXTcpAPI.this.udpSocket != null) {
                        JXTcpAPI.this.udpSocket.close();
                        JXTcpAPI.this.udpSocket = null;
                        JXLog.e(TAG, "startScan  responseUdp" + e.getMessage());
                    } else if (JXTcpAPI.this.listener != null) {
                        JXTcpAPI.this.listener.onScanEnd();
                    }
                    JXTcpAPI.this.starScan = false;
                    return;
                }
            }
        }).start();
    }

    @Override
    public void setUnlockType(int type) {
    }

    @Override
    public boolean isConnected() {
        if (this.ipSocket != null) {
            return this.socketConnected;
        }
        return false;
    }

    private boolean ipSocketConnected() {
        this.socketConnected = true;
        if (this.ipSocket != null) {
            try {
                this.ipSocket.setSoTimeout(300);
                byte[] bytes = new byte[1];
                int value = this.ipSocket.getInputStream().read(bytes);
                JXLog.e(TAG, "ipSocketConnected  value = " + value);
                if (value == -1) {
                    JXLog.d(TAG, "ipSocketConnected  \u8fde\u63a5\u5931\u8d25");
                    this.closeConnection();
                }
            }
            catch (SocketTimeoutException e) {
                JXLog.d(TAG, "ipSocketConnected  \u8fde\u63a5\u6210\u529f" + e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.closeConnection();
                JXLog.e(TAG, "ipSocketConnected  \u8fde\u63a5\u5931\u8d25 Exception" + e.getMessage());
            }
        } else {
            this.socketConnected = false;
        }
        return this.socketConnected;
    }

    @Override
    public boolean closeConnection() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException ioException) {
                JXLog.d(TAG, "closeConnection  ioException = " + ioException.getMessage());
            }
            this.os = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException ioException) {
                JXLog.d(TAG, "closeConnection  ioException = " + ioException.getMessage());
            }
            this.is = null;
        }
        if (this.ipSocket != null) {
            try {
                this.ipSocket.close();
            }
            catch (IOException ioException) {
                JXLog.d(TAG, "closeConnection  ioException = " + ioException.getMessage());
            }
            this.ipSocket = null;
        }
        this.socketConnected = false;
        JXLog.d(TAG, "closeConnection  ");
        return true;
    }

    @Override
    public boolean reopenConnection(int timeout) {
        this.closeConnection();
        JXLog.e(TAG, "reopenConnection");
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            JXLog.e(TAG, "reopenConnection exception: " + e.getMessage());
        }
        return this.openConnection(this.ip, this.port, timeout);
    }

    @Override
    public boolean flushReadBuffer() {
        byte[] buffer = new byte[64];
        if (!this.isConnected()) {
            return false;
        }
        if (this.is == null) {
            JXLog.e(TAG, " is is null when flushReadBuffer");
            return false;
        }
        while (true) {
            try {
                int availableBuffer = this.is.available();
                if (availableBuffer == 0) {
                    return true;
                }
                if (availableBuffer > 0) {
                    if (availableBuffer > 64) {
                        availableBuffer = 64;
                    }
                    this.is.read(buffer, 0, availableBuffer);
                    JXLog.d_bytes(TAG, "flush Reader ", buffer);
                }
            }
            catch (IOException var5) {
                var5.printStackTrace();
                JXLog.e(TAG, "io exception when flushReadBuffer");
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException var4) {
                var4.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean writeBuffer(byte[] buffer, int offset, int length) {
        JXLog.d_bytes(TAG, "write buffer", buffer);
        return this.writeBuffer(buffer, offset, length, false);
    }

    private boolean writeBuffer(byte[] buffer, int offset, int length, boolean retry) {
        if (!this.isConnected()) {
            JXLog.e(TAG, "disconnected");
            return false;
        }
        if (this.ipSocket == null) {
            JXLog.e(TAG, "socket is null");
            return false;
        }
        if (this.os == null) {
            JXLog.e(TAG, "osSocket is null");
            return false;
        }
        JXLog.d_bytes(TAG, "writeBuffer", buffer);
        try {
            this.os.write(buffer, offset, length);
            this.os.flush();
            Thread.sleep(1L);
            return true;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            JXLog.e(TAG, "writeBuffer exception: " + var5.getMessage());
            if (retry) {
                this.closeConnection();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.reopenConnection(10000)) {
                    return this.writeBuffer(buffer, offset, length, false);
                }
                this.closeConnection();
                return false;
            }
            this.closeConnection();
            return false;
        }
    }

    @Override
    public boolean readBuffer(byte[] buffer, int offset, int length, int timeout) {
        if (!this.isConnected()) {
            return false;
        }
        if (this.ipSocket == null) {
            JXLog.e(TAG, "ipSocket is null");
            return false;
        }
        if (this.is == null) {
            JXLog.e(TAG, "is is null");
            return false;
        }
        if (timeout < 200) {
            timeout = 200;
        }
        if (timeout > 50000) {
            timeout = 50000;
        }
        if (offset >= 0) {
            return this.readFixLengthBytes(buffer, offset, length, timeout);
        }
        return this.readVariableLengthBytes(buffer, ~offset, timeout);
    }

    private boolean readFixLengthBytes(byte[] buffer, int offset, int length, int timeout) {
        try {
            long start_time = SystemClock.elapsedRealtime();
            int need_read = length;
            int index = 0;
            while (true) {
                int available = this.is.available();
                int read = 0;
                if (available > 0) {
                    int n;
                    while ((n = this.is.read()) != -1) {
                        buffer[index++] = (byte)n;
                        ++read;
                        if (index >= length + offset) {
                            JXLog.d("readFixLengthBytes", "index = " + index + "_length = " + length + " break this read while");
                            break;
                        }
                        if (read < available) continue;
                        JXLog.d("readFixLengthBytes", "available = " + available + "_read = " + read + " break this read while");
                        break;
                    }
                    need_read -= read;
                    start_time = SystemClock.elapsedRealtime();
                }
                if (need_read <= 0) {
                    JXLog.d_bytes("readFixLengthBytes", "read", buffer);
                    return true;
                }
                if (SystemClock.elapsedRealtime() - start_time > (long)timeout) {
                    JXLog.e(TAG, "readFixLengthBytes timeout");
                    JXLog.d_bytes("readFixLengthBytes", "read timeout", buffer);
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception var11) {
            JXLog.e(TAG, "read exception " + var11.getMessage());
            this.closeConnection();
            return false;
        }
    }

    private boolean readVariableLengthBytes(byte[] buffer, int nIndex, int timeout) {
        try {
            long start_time = SystemClock.elapsedRealtime();
            int need_read = nIndex + 1;
            int index = 0;
            while (true) {
                if (this.is.available() > 0) {
                    int n;
                    while ((n = this.is.read()) != -1) {
                        buffer[index] = (byte)n;
                        --need_read;
                        if (index == nIndex) {
                            need_read = buffer[index];
                        }
                        if (need_read == 0) {
                            JXLog.d_bytes("readVariableLengthBytes", "read", buffer);
                            return true;
                        }
                        ++index;
                    }
                    start_time = SystemClock.elapsedRealtime();
                }
                if (SystemClock.elapsedRealtime() - start_time > (long)timeout) {
                    JXLog.e(TAG, "readVariableLengthBytes timeout");
                    JXLog.d_bytes("readVariableLengthBytes", "read", buffer);
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception var11) {
            JXLog.e(TAG, "read exception " + var11.getMessage());
            this.closeConnection();
            return false;
        }
    }

    @Override
    public boolean readBuffer(byte[] buffer1, byte[] buffer2, long[] receiveTS, int timeout) {
        JXLog.d_bytes(TAG, "read buffer1", buffer1);
        JXLog.d_bytes(TAG, "read buffer2", buffer2);
        if (!this.isConnected()) {
            return false;
        }
        if (this.ipSocket == null) {
            JXLog.e(TAG, "btSocket is null");
            return false;
        }
        if (this.is == null) {
            JXLog.e(TAG, "is is null");
            return false;
        }
        if (timeout < 200) {
            timeout = 200;
        }
        if (timeout > 20000) {
            timeout = 20000;
        }
        try {
            long start_time = SystemClock.elapsedRealtime();
            int totalLength = buffer1.length + buffer2.length;
            int index = 0;
            boolean isReceiveBuffer1 = true;
            while (true) {
                if (this.is.available() > 0) {
                    int n;
                    while (index < totalLength && (n = this.is.read()) != -1) {
                        if (index == 0) {
                            isReceiveBuffer1 = true;
                        } else if (index == buffer1.length - 1) {
                            receiveTS[0] = SystemClock.elapsedRealtime();
                        } else if (index == buffer1.length) {
                            isReceiveBuffer1 = false;
                        } else if (index == totalLength - 1) {
                            receiveTS[1] = SystemClock.elapsedRealtime();
                        }
                        if (isReceiveBuffer1) {
                            buffer1[index] = (byte)n;
                        } else {
                            buffer2[index - buffer1.length] = (byte)n;
                        }
                        ++index;
                    }
                }
                if (index == totalLength) {
                    return true;
                }
                long cur_time = SystemClock.elapsedRealtime();
                if (cur_time - start_time > (long)timeout) {
                    JXLog.e(TAG, "read timeout and read index is " + index);
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception var11) {
            JXLog.e(TAG, "read exception " + var11.getMessage());
            this.closeConnection();
            return false;
        }
    }

    @Override
    public boolean isUnlock() {
        if (!UnlockCmd.unlockIfNecessary(this, 2)) {
            this.closeConnection();
            return false;
        }
        return true;
    }
}

