/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxapi;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxapi.UnlockCmd;
import com.jxit.printer.jxsdk.JXLog;
import java.util.ArrayList;
import java.util.List;

public class JXUsbAPI
implements JXInterfaceAPI {
    private static final String TAG = JXUsbAPI.class.getSimpleName();
    private Context context;
    private UsbManager mManager;
    private static volatile JXUsbAPI mDefault;
    private boolean usbSupport;
    private UsbDevice mConnectedDevice;
    private UsbEndpoint epIn;
    private UsbEndpoint epOut;
    private UsbInterface mUsbInterface;
    private UsbDeviceConnection mConnection;
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private int connectState;
    public static final int STATE_NONE = 200;
    public static final int STATE_CONNECTED = 203;
    public static final int WRITE_TIME_OUT = 10000;
    private static final int MAX_WRITE_CHUNK_SIZE = 2048;
    public static final int MAX_READ_CHUNK_SIZE = 64;
    private byte[] mChunkBuffer = new byte[2048];

    private void setConnectState(int state) {
        this.connectState = state;
    }

    private JXUsbAPI(Context context) {
        this.context = context;
        this.mManager = (UsbManager)context.getSystemService("usb");
        this.usbSupport = this.mManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JXUsbAPI getDefault(@NonNull Context context) {
        if (mDefault != null) return mDefault;
        Class<JXUsbAPI> clazz = JXUsbAPI.class;
        synchronized (JXUsbAPI.class) {
            if (mDefault != null) return mDefault;
            mDefault = new JXUsbAPI(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mDefault;
        }
    }

    public List<UsbDevice> getDevices() {
        return new ArrayList<UsbDevice>(this.mManager.getDeviceList().values());
    }

    @Override
    public void setUnlockType(int type) {
    }

    @Override
    public boolean isConnected() {
        return this.connectState == 203;
    }

    @Override
    public boolean reopenConnection(int timeout) {
        JXLog.d(TAG, "reopenConnection");
        return this.openConnection(this.mConnectedDevice);
    }

    public boolean openConnection(UsbDevice device) {
        if (device == null) {
            return false;
        }
        this.mConnectedDevice = device;
        this.closeConnection();
        JXLog.d(TAG, "open connection");
        if (!this.mManager.hasPermission(this.mConnectedDevice)) {
            JXLog.e(TAG, "permission denied");
            return false;
        }
        this.mConnection = this.mManager.openDevice(this.mConnectedDevice);
        if (this.mConnection == null) {
            JXLog.e(TAG, "usb open device failed");
            return false;
        }
        if (device.getInterfaceCount() < 1) {
            JXLog.e(TAG, "no usb device found");
            return false;
        }
        this.mUsbInterface = device.getInterface(0);
        if (!this.mConnection.claimInterface(this.mUsbInterface, true)) {
            JXLog.e(TAG, "claimInterface failed");
            return false;
        }
        for (int i = 0; i < this.mUsbInterface.getEndpointCount(); ++i) {
            UsbEndpoint ep = this.mUsbInterface.getEndpoint(i);
            if (ep.getDirection() == 128) {
                this.epIn = ep;
                continue;
            }
            if (ep.getDirection() != 0) continue;
            this.epOut = ep;
        }
        this.setConnectState(203);
        JXLog.d(TAG, "connection opened");
        return this.epIn != null && this.epOut != null;
    }

    @Override
    public boolean closeConnection() {
        if (this.mConnection != null) {
            this.mConnection.releaseInterface(this.mUsbInterface);
            this.mConnection.close();
            this.mConnection = null;
            this.epIn = null;
            this.epOut = null;
        }
        this.setConnectState(200);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        JXLog.d(TAG, "connection closed");
        return true;
    }

    @Override
    public boolean flushReadBuffer() {
        if (!this.isConnected()) {
            return false;
        }
        if (this.mConnection == null) {
            JXLog.e(TAG, "mUSBConnection is null");
            return false;
        }
        if (this.epIn == null) {
            JXLog.e(TAG, "epIn is null");
            return false;
        }
        byte[] temp = new byte[64];
        try {
            int len = this.mConnection.bulkTransfer(this.epIn, temp, temp.length, 100);
            JXLog.d(TAG, "flushReadBuffer len= " + len);
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "flushReadBuffer exception " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean writeBuffer(byte[] buffer, int offset, int length) {
        JXLog.d_bytes(TAG, "writeBuffer", buffer);
        if (!this.isConnected()) {
            return false;
        }
        if (this.mConnection == null) {
            JXLog.e(TAG, "mUSBConnection is null");
            return false;
        }
        if (this.epOut == null) {
            JXLog.e(TAG, "epOut is null");
            return false;
        }
        if (!this.mConnection.claimInterface(this.mUsbInterface, true)) {
            JXLog.e(TAG, "claimInterface failed");
            return false;
        }
        try {
            if (length <= 2048) {
                byte[] temp = new byte[length];
                System.arraycopy(buffer, offset, temp, 0, length);
                int len = this.mConnection.bulkTransfer(this.epOut, temp, temp.length, 10000);
                if (len < length) {
                    JXLog.e(TAG, "write buffer failed expect write " + temp.length + " but write " + len);
                    return false;
                }
            } else {
                int len;
                int mod = length / 2048;
                int reminder = length % 2048;
                for (int i = 0; i < mod; ++i) {
                    System.arraycopy(buffer, offset + i * 2048, this.mChunkBuffer, 0, 2048);
                    len = this.mConnection.bulkTransfer(this.epOut, this.mChunkBuffer, this.mChunkBuffer.length, 10000);
                    if (len < this.mChunkBuffer.length) {
                        JXLog.e(TAG, "write buffer failed expect write " + this.mChunkBuffer.length + " but write " + len);
                        return false;
                    }
                    Thread.sleep(5L);
                }
                if (reminder > 0) {
                    byte[] temp = new byte[reminder];
                    System.arraycopy(buffer, offset + mod * 2048, temp, 0, reminder);
                    len = this.mConnection.bulkTransfer(this.epOut, temp, temp.length, 10000);
                    if (len < temp.length) {
                        JXLog.e(TAG, "write buffer failed expect write " + temp.length + " but write " + len);
                        return false;
                    }
                }
            }
            Thread.sleep(5L);
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "write buffer exception " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean readBuffer(byte[] buffer, int offset, int length, int timeout) {
        if (!this.isConnected()) {
            return false;
        }
        if (this.mConnection == null) {
            JXLog.e(TAG, "mUSBConnection is null");
            return false;
        }
        if (this.epIn == null) {
            JXLog.e(TAG, "epIn is null");
            return false;
        }
        if (length > 64) {
            length = 64;
            JXLog.e(TAG, "usb read length can not bigger than 64,try to set length to 64");
        }
        byte[] temp = new byte[length];
        try {
            int len = this.mConnection.bulkTransfer(this.epIn, temp, temp.length, timeout);
            if (len < 0) {
                JXLog.f(TAG, "read buffer failed");
                return false;
            }
            System.arraycopy(temp, 0, buffer, 0, len);
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "read buffer exception " + e.getMessage());
            return false;
        }
        JXLog.d_bytes(TAG, "read buffer succeed", buffer);
        return true;
    }

    @Override
    public boolean readBuffer(byte[] buffer1, byte[] buffer2, long[] receiveTS, int timeout) {
        if (!this.isConnected()) {
            return false;
        }
        if (this.mConnection == null) {
            JXLog.e(TAG, "mUSBConnection is null");
            return false;
        }
        if (this.epIn == null) {
            JXLog.e(TAG, "epIn is null");
            return false;
        }
        receiveTS[0] = SystemClock.elapsedRealtime();
        byte[] temp = new byte[buffer1.length + buffer2.length];
        int len = this.mConnection.bulkTransfer(this.epIn, temp, temp.length, timeout);
        if (len > 0) {
            JXLog.d_bytes(TAG, "readBuffer", temp);
            receiveTS[1] = SystemClock.elapsedRealtime();
            System.arraycopy(temp, 0, buffer1, 0, buffer1.length);
            System.arraycopy(temp, buffer1.length, buffer2, 0, buffer2.length);
            return true;
        }
        JXLog.f(TAG, "failed to readBuffer");
        return false;
    }

    @Override
    public boolean isUnlock() {
        if (!UnlockCmd.unlockIfNecessary(this, 2)) {
            this.closeConnection();
            return false;
        }
        return true;
    }
}

