/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.jxit.printer.jxsdk.GuoJiang_CMD;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.jxsdk.JXUpgradeListener;
import com.jxit.printer.model.JXFirmwareFontUpgrade;

public class JXUpgradeService
extends HandlerThread {
    private static final String TAG = JXUpgradeService.class.getSimpleName();
    private static final int FILE_TYPE_FIRMWARE = 1;
    private static final int FILE_TYPE_FONT = 2;
    public static final int TASK_SET_MODE_UPGRADE = 10;
    public static final int TASK_CHECK_MODE_UPGRADE = 20;
    public static final int TASK_CHECK_FONT_FILE_SIZE_LEGALITY = 30;
    public static final int TASK_CHECK_FIRMWARE_FILE_SIZE_LEGALITY = 31;
    public static final int TASK_UPLOAD_FILE = 40;
    public static final int TASK_RESTART_DEVICE = 50;
    private static final long CHECK_MODE_SET_RESULT_INTERVAL = 5000L;
    private static final long RETRY_INTERVAL = 2000L;
    private static final int MAX_RETRY_TIMES = 10;
    private static final int CHUNK_SIZE = 2048;
    private GuoJiang_CMD mCommand;
    private byte[] mLib;
    private JXUpgradeListener mListener;
    private int mFileType;
    private int curLength;
    private int mConnectType = 1;
    private Handler mUpgradeHandler;

    public JXUpgradeService(String name) {
        super(name);
    }

    public void upgradeFont(int connectType, GuoJiang_CMD cmd, byte[] lib, JXUpgradeListener listener) {
        this.upgrade(2, connectType, cmd, lib, listener);
    }

    public void upgradeFirmware(int connectType, GuoJiang_CMD cmd, byte[] lib, JXUpgradeListener listener) {
        this.upgrade(1, connectType, cmd, lib, listener);
    }

    private void upgrade(int fileType, int connectType, GuoJiang_CMD cmd, byte[] lib, JXUpgradeListener listener) {
        if (this.mUpgradeHandler != null) {
            throw new IllegalStateException("can't invoke this upgrade method more than once\uff0cplease create a new instance");
        }
        this.start();
        this.mConnectType = connectType;
        this.mCommand = cmd;
        this.mLib = lib;
        this.mListener = listener;
        this.mFileType = fileType;
        this.curLength = 0;
        this.mUpgradeHandler = new Handler(this.getLooper()){

            public void handleMessage(Message msg) {
                JXUpgradeService.this.handleMessages(this, msg);
            }
        };
        this.mUpgradeHandler.obtainMessage(10, 1, 0).sendToTarget();
    }

    public boolean quit() {
        if (this.mUpgradeHandler != null) {
            this.mUpgradeHandler.removeCallbacksAndMessages(null);
            JXLog.d(TAG, "upgrade service quit");
        }
        return super.quit();
    }

    private void handleFail(Handler H, int what, String msg, int curTimes) {
        if (curTimes < 10) {
            this.mListener.onRetry(what, "retry to " + msg + "...");
            Message m = H.obtainMessage(what, curTimes + 1, 0);
            H.sendMessageDelayed(m, 2000L);
        } else {
            this.mListener.onError(what, "upgrade failed by failing to " + msg);
        }
    }

    private void handleMessages(Handler H, Message msg) {
        int times = msg.arg1;
        switch (msg.what) {
            case 10: {
                boolean success;
                this.mListener.onProcess(msg.what, "set the upgrade mode " + times + " times...");
                if (this.mConnectType == 1) {
                    success = this.mCommand.gj_set_mode_bluetooth_upgrade();
                } else if (this.mConnectType == 2) {
                    success = this.mCommand.gj_set_mode_usb_upgrade();
                } else {
                    JXLog.e(TAG, "Unsupported upgrade type " + this.mConnectType);
                    this.handleFail(H, msg.what, "set the upgrade mode ", 10);
                    return;
                }
                if (success) {
                    this.mCommand.mAPI.closeConnection();
                    Message m = H.obtainMessage(20, 1, 0);
                    this.mListener.onProcess(msg.what, "succeed to set the upgrade mode to bluetooth and will recheck it soon...");
                    H.sendMessageDelayed(m, 5000L);
                    break;
                }
                this.handleFail(H, msg.what, "set the upgrade mode ", times);
                break;
            }
            case 20: {
                if (!this.mCommand.mAPI.isConnected()) {
                    this.mCommand.mAPI.reopenConnection(20000);
                }
                this.mListener.onProcess(msg.what, "recheck the upgrade mode " + times + " times...");
                boolean success = this.mCommand.gj_check_mode_bt_upgrade();
                if (success) {
                    Message m = H.obtainMessage(this.mFileType == 1 ? 31 : 30, 1, 0);
                    this.mListener.onProcess(msg.what, "upgrade mode is bluetooth now and will check file legality soon...");
                    H.sendMessage(m);
                    break;
                }
                this.handleFail(H, msg.what, "recheck the upgrade mode", times);
                break;
            }
            case 31: {
                this.mListener.onProcess(msg.what, "check firmware file size legality " + times + " times...");
                int result = this.mCommand.gj_check_upgrade_file_size(false, this.mLib.length);
                if (result == JXFirmwareFontUpgrade.SUCCESS) {
                    this.mListener.onProcess(msg.what, "file is available and will start to download file to device soon...");
                    this.curLength = 0;
                    Message m = H.obtainMessage(40, 1, 0);
                    H.sendMessage(m);
                    break;
                }
                if (result == JXFirmwareFontUpgrade.ERROR_FILE_ZERO_SIZE) {
                    this.mListener.onError(msg.what, "upgrade failed by file size is zero");
                    break;
                }
                if (result == JXFirmwareFontUpgrade.ERROR_FILE_OVER_SIZE) {
                    this.mListener.onError(msg.what, "upgrade failed by file size is too large");
                    break;
                }
                this.handleFail(H, msg.what, "check file size legality", times);
                break;
            }
            case 30: {
                this.mListener.onProcess(msg.what, "check font file size legality " + times + " times...");
                int result = this.mCommand.gj_check_upgrade_file_size(true, this.mLib.length);
                if (result == JXFirmwareFontUpgrade.SUCCESS) {
                    this.mListener.onProcess(msg.what, "file is available and will start to download file to device soon...");
                    this.curLength = 0;
                    Message m = H.obtainMessage(40, 1, 0);
                    H.sendMessage(m);
                    break;
                }
                if (result == JXFirmwareFontUpgrade.ERROR_FILE_ZERO_SIZE) {
                    this.mListener.onError(msg.what, "upgrade failed by file size is zero");
                    break;
                }
                if (result == JXFirmwareFontUpgrade.ERROR_FILE_OVER_SIZE) {
                    this.mListener.onError(msg.what, "upgrade failed by file size is too large");
                    break;
                }
                this.handleFail(H, msg.what, "check file size legality", times);
                break;
            }
            case 40: {
                int leftLength = this.mLib.length - this.curLength;
                if (leftLength == 0) {
                    Message m = H.obtainMessage(50, 1, 0);
                    H.sendMessage(m);
                    return;
                }
                int chunkSize = leftLength > 2048 ? 2048 : leftLength;
                byte[] chunk = new byte[chunkSize];
                System.arraycopy(this.mLib, this.curLength, chunk, 0, chunkSize);
                this.mListener.onUpload(this.mLib.length, this.curLength);
                boolean success = this.mCommand.gj_upgrade_upload_file(chunk, this.mFileType == 2);
                if (success) {
                    this.curLength += chunkSize;
                    Message m = H.obtainMessage(msg.what);
                    H.sendMessage(m);
                    break;
                }
                this.handleFail(H, msg.what, "downloading file to device", times);
                break;
            }
            case 50: {
                this.mListener.onProcess(msg.what, "restart the device to finish upgrade " + times + " times...");
                boolean success = this.mCommand.gj_set_upgrade_restart();
                if (success) {
                    this.mListener.onProcess(msg.what, "please wait the device to restart");
                    this.mListener.onSuccess();
                    break;
                }
                this.handleFail(H, msg.what, "restart the device to finish upgrade", times);
                break;
            }
        }
    }
}

