/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import android.view.View;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.DataMatrixWriter;
import com.google.zxing.oned.CodaBarWriter;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.Code39Writer;
import com.google.zxing.pdf417.PDF417Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jxit.printer.jxsdk.JXLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;

public class BitmapTools {
    public static final String TAG = BitmapTools.class.getSimpleName();

    public static Bitmap compress(Bitmap bitmap, int newWidth) {
        int height;
        int width = bitmap.getWidth();
        int newHeight = height = bitmap.getHeight();
        if (width > newWidth) {
            float radio = (float)width / (float)newWidth;
            newHeight = (int)((float)height / radio);
        }
        Bitmap targetBmp = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas targetCanvas = new Canvas(targetBmp);
        targetCanvas.drawColor(-1);
        targetCanvas.drawBitmap(bitmap, new Rect(0, 0, width, height), new Rect(0, 0, newWidth, newHeight), null);
        return targetBmp;
    }

    public static Bitmap getSinglePic(Bitmap inputBMP, int threshold) {
        int[] pix = new int[inputBMP.getWidth() * inputBMP.getHeight()];
        int[] colorTemp = new int[inputBMP.getWidth() * inputBMP.getHeight()];
        inputBMP.getPixels(pix, 0, inputBMP.getWidth(), 0, 0, inputBMP.getWidth(), inputBMP.getHeight());
        Bitmap returnBMP = Bitmap.createBitmap((int)inputBMP.getWidth(), (int)inputBMP.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        for (int j = 0; j < colorTemp.length; ++j) {
            colorTemp[j] = Color.rgb((int)Color.red((int)pix[j]), (int)Color.green((int)pix[j]), (int)Color.blue((int)pix[j]));
        }
        for (int i = 0; i < colorTemp.length; ++i) {
            int b;
            int g;
            int r = Color.red((int)pix[i]);
            colorTemp[i] = r + (g = Color.green((int)pix[i])) + (b = Color.blue((int)pix[i])) > 3 * threshold ? Color.rgb((int)255, (int)255, (int)255) : Color.rgb((int)0, (int)0, (int)0);
        }
        returnBMP.setPixels(colorTemp, 0, inputBMP.getWidth(), 0, 0, inputBMP.getWidth(), inputBMP.getHeight());
        return returnBMP;
    }

    public static Bitmap getSinglePicDithering(Bitmap inputBMP, int threshold) {
        inputBMP = BitmapTools.getSinglePic(inputBMP, threshold);
        int width = inputBMP.getWidth();
        int height = inputBMP.getHeight();
        int[] pixels = new int[width * height];
        inputBMP.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] gray = new int[height * width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int red;
                int grey = pixels[width * i + j];
                gray[width * i + j] = red = (grey & 0xFF0000) >> 16;
            }
        }
        int e = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int g = gray[width * i + j];
                if (g >= 128) {
                    pixels[width * i + j] = 0xFFFFFF;
                    e = g - 255;
                } else {
                    pixels[width * i + j] = -16777216;
                    e = g - 0;
                }
                if (j < width - 1 && i < height - 1) {
                    int n = width * i + j + 1;
                    gray[n] = gray[n] + 3 * e / 8;
                    int n2 = width * (i + 1) + j;
                    gray[n2] = gray[n2] + 3 * e / 8;
                    int n3 = width * (i + 1) + j + 1;
                    gray[n3] = gray[n3] + e / 4;
                    continue;
                }
                if (j == width - 1 && i < height - 1) {
                    int n = width * (i + 1) + j;
                    gray[n] = gray[n] + 3 * e / 8;
                    continue;
                }
                if (j >= width - 1 || i != height - 1) continue;
                int n = width * i + j + 1;
                gray[n] = gray[n] + e / 4;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    public static Bitmap scaleBitmap(Bitmap bitmap, float scale, int printerMaxDot) {
        if (bitmap == null || scale <= 0.0f || scale > 1.0f) {
            JXLog.e(TAG, "bitmap is null or scale not in 0-1.0");
            return bitmap;
        }
        int maxDot = printerMaxDot;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int targetW = (int)((float)maxDot * scale);
        float bmpScale = 1.0f * (float)targetW / (float)width;
        Matrix matrix = new Matrix();
        matrix.postScale(bmpScale, bmpScale);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap view2Bitmap(View view, int width) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = BitmapTools.scaleBitmapByMatrix(BitmapTools.view2Bitmap(view), width);
        return bitmap;
    }

    public static Bitmap view2Bitmap(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable bgDrawable = view.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(0);
        }
        view.draw(canvas);
        return bitmap;
    }

    public static Bitmap getBitmapByPath(String path, int maxWidth) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)path);
        if (maxWidth == 0) {
            maxWidth = 1080;
        }
        return BitmapTools.scaleBitmapByMatrix(bitmap, maxWidth);
    }

    public static Bitmap bitmapSampling(Bitmap bitmap) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        return bitmap;
    }

    public static Bitmap bitmapScaled(Bitmap bitmap, int target) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newWidth = target;
        float radio = (float)width / (float)newWidth;
        int newHeight = (int)((float)height / radio);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
        return bitmap;
    }

    public static Bitmap bitmapScaledFix(Bitmap bitmap, int targetWidth, int targetHeight) {
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)targetWidth, (int)targetHeight, (boolean)true);
        return bitmap;
    }

    public static Bitmap getSinglePicOTSU(Bitmap inputBMP) {
        int[] pix = new int[inputBMP.getWidth() * inputBMP.getHeight()];
        int[] colorTemp = new int[inputBMP.getWidth() * inputBMP.getHeight()];
        inputBMP.getPixels(pix, 0, inputBMP.getWidth(), 0, 0, inputBMP.getWidth(), inputBMP.getHeight());
        Bitmap returnBMP = Bitmap.createBitmap((int)inputBMP.getWidth(), (int)inputBMP.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int lightNumber = BitmapTools.otsu(inputBMP);
        for (int j = 0; j < colorTemp.length; ++j) {
            colorTemp[j] = Color.rgb((int)Color.red((int)pix[j]), (int)Color.green((int)pix[j]), (int)Color.blue((int)pix[j]));
        }
        for (int i = 0; i < colorTemp.length; ++i) {
            int b;
            int g;
            int r = Color.red((int)pix[i]);
            colorTemp[i] = r + (g = Color.green((int)pix[i])) + (b = Color.blue((int)pix[i])) > 3 * lightNumber ? Color.argb((int)255, (int)255, (int)255, (int)255) : Color.argb((int)255, (int)0, (int)0, (int)0);
        }
        returnBMP.setPixels(colorTemp, 0, inputBMP.getWidth(), 0, 0, inputBMP.getWidth(), inputBMP.getHeight());
        return returnBMP;
    }

    public static Bitmap getSinglePic(Bitmap inputBMP) {
        int[] pix = new int[inputBMP.getWidth() * inputBMP.getHeight()];
        int[] colorTemp = new int[inputBMP.getWidth() * inputBMP.getHeight()];
        inputBMP.getPixels(pix, 0, inputBMP.getWidth(), 0, 0, inputBMP.getWidth(), inputBMP.getHeight());
        Bitmap returnBMP = Bitmap.createBitmap((int)inputBMP.getWidth(), (int)inputBMP.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int lightNumber = 127;
        for (int j = 0; j < colorTemp.length; ++j) {
            colorTemp[j] = Color.rgb((int)Color.red((int)pix[j]), (int)Color.green((int)pix[j]), (int)Color.blue((int)pix[j]));
        }
        for (int i = 0; i < colorTemp.length; ++i) {
            int b;
            int g;
            int r = Color.red((int)pix[i]);
            colorTemp[i] = r + (g = Color.green((int)pix[i])) + (b = Color.blue((int)pix[i])) > 3 * lightNumber ? Color.argb((int)255, (int)255, (int)255, (int)255) : Color.argb((int)255, (int)0, (int)0, (int)0);
        }
        returnBMP.setPixels(colorTemp, 0, inputBMP.getWidth(), 0, 0, inputBMP.getWidth(), inputBMP.getHeight());
        return returnBMP;
    }

    public static Bitmap getSinglePicDithering(Bitmap inputBMP) {
        inputBMP = BitmapTools.getSinglePic(inputBMP);
        int width = inputBMP.getWidth();
        int height = inputBMP.getHeight();
        int[] pixels = new int[width * height];
        inputBMP.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] gray = new int[height * width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int red;
                int grey = pixels[width * i + j];
                gray[width * i + j] = red = (grey & 0xFF0000) >> 16;
            }
        }
        int e = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int g = gray[width * i + j];
                if (g >= 128) {
                    pixels[width * i + j] = 0xFFFFFF;
                    e = g - 255;
                } else {
                    pixels[width * i + j] = -16777216;
                    e = g - 0;
                }
                if (j < width - 1 && i < height - 1) {
                    int n = width * i + j + 1;
                    gray[n] = gray[n] + 3 * e / 8;
                    int n2 = width * (i + 1) + j;
                    gray[n2] = gray[n2] + 3 * e / 8;
                    int n3 = width * (i + 1) + j + 1;
                    gray[n3] = gray[n3] + e / 4;
                    continue;
                }
                if (j == width - 1 && i < height - 1) {
                    int n = width * (i + 1) + j;
                    gray[n] = gray[n] + 3 * e / 8;
                    continue;
                }
                if (j >= width - 1 || i != height - 1) continue;
                int n = width * i + j + 1;
                gray[n] = gray[n] + e / 4;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    public static Bitmap getSinglePicDitheringGrayscale(Bitmap bmp) {
        int grey;
        int j;
        int i;
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        int[] pixels = new int[width * height];
        int SumGray = 0;
        int mGray = 0;
        int eGray = 0;
        int nGray = 0;
        bmp.getPixels(pixels, 0, width, 0, 0, width, height);
        int alpha = -16777216;
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                grey = pixels[width * i + j];
                int red = (grey & 0xFF0000) >> 16;
                int green = (grey & 0xFF00) >> 8;
                int blue = grey & 0xFF;
                pixels[width * i + j] = grey = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
                SumGray += grey;
                ++nGray;
            }
        }
        mGray = SumGray / nGray;
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                grey = pixels[width * i + j];
                if (grey > mGray) {
                    pixels[width * i + j] = 0xFFFFFF;
                    eGray = grey - 255;
                } else {
                    pixels[width * i + j] = -16777216;
                    eGray = grey - 0;
                }
                if (j < width - 1 && i < height - 1) {
                    int n = width * i + j + 1;
                    pixels[n] = pixels[n] + 3 * eGray / 8;
                    int n2 = width * (i + 1) + j;
                    pixels[n2] = pixels[n2] + 3 * eGray / 8;
                    int n3 = width * (i + 1) + j + 1;
                    pixels[n3] = pixels[n3] + eGray / 4;
                    continue;
                }
                if (j == width - 1 && i < height - 1) {
                    int n = width * (i + 1) + j;
                    pixels[n] = pixels[n] + 3 * eGray / 8;
                    continue;
                }
                if (j >= width - 1 || i != height - 1) continue;
                int n = width * i + j + 1;
                pixels[n] = pixels[n] + eGray / 4;
            }
        }
        Bitmap newBmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        newBmp.setPixels(pixels, 0, width, 0, 0, width, height);
        return newBmp;
    }

    public static Bitmap compressPic(Bitmap bitmap, int newWidth) {
        int height;
        int width = bitmap.getWidth();
        int newHeight = height = bitmap.getHeight();
        if (width > newWidth) {
            float radio = (float)width / (float)newWidth;
            newHeight = (int)((float)height / radio);
        }
        Bitmap targetBmp = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas targetCanvas = new Canvas(targetBmp);
        targetCanvas.drawBitmap(bitmap, new Rect(0, 0, width, height), new Rect(0, 0, newWidth, newHeight), null);
        return targetBmp;
    }

    public static int otsu(Bitmap bitmap) {
        int tr;
        int index;
        int threshold = 127;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] inPixels = new int[width * height];
        bitmap.getPixels(inPixels, 0, width, 0, 0, width, height);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                index = row * width + col;
                int ta = inPixels[index] >> 24 & 0xFF;
                tr = inPixels[index] >> 16 & 0xFF;
                int tg = inPixels[index] >> 8 & 0xFF;
                int tb = inPixels[index] & 0xFF;
                int gray = (int)(0.299 * (double)tr + 0.587 * (double)tg + 0.114 * (double)tb);
                inPixels[index] = ta << 24 | gray << 16 | gray << 8 | gray;
            }
        }
        int[] histogram = new int[256];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                index = row * width + col;
                int n = tr = inPixels[index] >> 16 & 0xFF;
                histogram[n] = histogram[n] + 1;
            }
        }
        double total = width * height;
        double[] variances = new double[256];
        for (int i = 0; i < variances.length; ++i) {
            int t;
            int t2;
            double bmeans = 0.0;
            double bvariance = 0.0;
            double count = 0.0;
            for (t2 = 0; t2 < i; ++t2) {
                count += (double)histogram[t2];
                bmeans += (double)(histogram[t2] * t2);
            }
            double bw = count / total;
            bmeans = count == 0.0 ? 0.0 : bmeans / count;
            for (t2 = 0; t2 < i; ++t2) {
                bvariance += Math.pow((double)t2 - bmeans, 2.0) * (double)histogram[t2];
            }
            bvariance = count == 0.0 ? 0.0 : bvariance / count;
            double fw = 0.0;
            double fmeans = 0.0;
            double fvariance = 0.0;
            count = 0.0;
            for (t = i; t < histogram.length; ++t) {
                count += (double)histogram[t];
                fmeans += (double)(histogram[t] * t);
            }
            fw = count / total;
            fmeans = count == 0.0 ? 0.0 : fmeans / count;
            for (t = i; t < histogram.length; ++t) {
                fvariance += Math.pow((double)t - fmeans, 2.0) * (double)histogram[t];
            }
            fvariance = count == 0.0 ? 0.0 : fvariance / count;
            variances[i] = bw * bvariance + fw * fvariance;
        }
        double min = variances[0];
        for (int m = 1; m < variances.length; ++m) {
            if (!(min > variances[m])) continue;
            threshold = m;
            min = variances[m];
        }
        return threshold;
    }

    public static Bitmap createQRcodeImage(String contents, BarcodeFormat code) {
        int width = 500;
        int height = 500;
        try {
            if (contents == null || "".equals(contents) || contents.length() < 1) {
                return null;
            }
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.MARGIN, 0);
            BitMatrix bitMatrix = null;
            switch (code) {
                case QR_CODE: {
                    hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
                    bitMatrix = new QRCodeWriter().encode(contents, code, width, height, hints);
                    break;
                }
                case PDF_417: {
                    bitMatrix = new PDF417Writer().encode(URLEncoder.encode(contents, "UTF-8"), code, width, height, hints);
                    break;
                }
                case DATA_MATRIX: {
                    bitMatrix = new DataMatrixWriter().encode(contents, code, width, height, hints);
                    break;
                }
                case MAXICODE: {
                    bitMatrix = new QRCodeWriter().encode(contents, code, width, height, hints);
                    break;
                }
                default: {
                    bitMatrix = new QRCodeWriter().encode(contents, code, width, height, hints);
                }
            }
            if (bitMatrix == null) {
                return null;
            }
            bitMatrix = BitmapTools.deleteWhite(bitMatrix);
            width = bitMatrix.getWidth();
            height = bitMatrix.getHeight();
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels[y * width + x] = bitMatrix.get(x, y) ? -16777216 : 0xFFFFFF;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            return bitmap;
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    private static int getBarCodeNoPaddingWidthCode39(int expectWidth, String contents, int maxWidth) {
        contents = contents.replaceAll("\r|\n", "");
        boolean[] code = new Code39Writer().encode(contents);
        int inputWidth = code.length;
        double outputWidth = Math.max(expectWidth, inputWidth);
        double multiple = outputWidth / (double)inputWidth;
        int returnVal = 0;
        int ceil = (int)Math.ceil(multiple);
        if (inputWidth * ceil <= maxWidth) {
            returnVal = inputWidth * ceil;
        } else {
            int floor = (int)Math.floor(multiple);
            returnVal = inputWidth * floor;
        }
        return returnVal;
    }

    private static int getBarCodeNoPaddingWidthCodeBar(int expectWidth, String contents, int maxWidth) {
        contents = contents.replaceAll("\r|\n", "");
        boolean[] code = new CodaBarWriter().encode(contents);
        int inputWidth = code.length;
        double outputWidth = Math.max(expectWidth, inputWidth);
        double multiple = outputWidth / (double)inputWidth;
        int returnVal = 0;
        int ceil = (int)Math.ceil(multiple);
        if (inputWidth * ceil <= maxWidth) {
            returnVal = inputWidth * ceil;
        } else {
            int floor = (int)Math.floor(multiple);
            returnVal = inputWidth * floor;
        }
        return returnVal;
    }

    private static int getBarCodeNoPaddingWidth(int expectWidth, String contents, int maxWidth) {
        contents = contents.replaceAll("\r|\n", "");
        boolean[] code = new Code128Writer().encode(contents);
        int inputWidth = code.length;
        double outputWidth = Math.max(expectWidth, inputWidth);
        double multiple = outputWidth / (double)inputWidth;
        int returnVal = 0;
        int ceil = (int)Math.ceil(multiple);
        if (inputWidth * ceil <= maxWidth) {
            returnVal = inputWidth * ceil;
        } else {
            int floor = (int)Math.floor(multiple);
            returnVal = inputWidth * floor;
        }
        return returnVal;
    }

    public static Bitmap flex(Bitmap bitmap, float wScale, float hScale) {
        if (wScale <= 0.0f || hScale <= 0.0f) {
            return null;
        }
        float ii = 1.0f / wScale;
        float jj = 1.0f / hScale;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int dstWidth = (int)(wScale * (float)width);
        int dstHeight = (int)(hScale * (float)height);
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] dstPixels = new int[dstWidth * dstHeight];
        for (int j = 0; j < dstHeight; ++j) {
            for (int i = 0; i < dstWidth; ++i) {
                dstPixels[j * dstWidth + i] = pixels[(int)(jj * (float)j) * width + (int)(ii * (float)i)];
            }
        }
        Bitmap outBitmap = Bitmap.createBitmap((int)dstWidth, (int)dstHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        outBitmap.setPixels(dstPixels, 0, dstWidth, 0, 0, dstWidth, dstHeight);
        return outBitmap;
    }

    public static byte[] bitmap2Bytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap scaleBitmapByMatrix(Bitmap bitmap, float radio) {
        Matrix matrix = new Matrix();
        matrix.setScale(radio, radio);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap;
    }

    public static Bitmap scaleBitmapByMatrix(Bitmap bitmap, int maxWidth) {
        if (bitmap.getWidth() > maxWidth) {
            Matrix matrix = new Matrix();
            float radio = (float)maxWidth * 1.0f / (float)bitmap.getWidth();
            matrix.setScale(radio, radio);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        return bitmap;
    }

    public static Bitmap bitmapCompress(Context context, Uri ui) {
        Bitmap photoBitmap = null;
        try {
            photoBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)ui);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String path = Environment.getExternalStorageDirectory().getPath() + "/Pic";
        File file = new File(path);
        file.mkdirs();
        long i = System.currentTimeMillis();
        file = new File(file.toString() + "/" + i + ".png");
        Log.e((String)"fileNew", (String)file.getPath());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file.getPath());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        photoBitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)out);
        try {
            photoBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)Uri.fromFile((File)file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return photoBitmap;
    }

    private static boolean isRepetitionStart(int index, byte[] data, int len) {
        if (index + 2 >= len) {
            return false;
        }
        byte b1 = data[index];
        byte b2 = data[index + 1];
        byte b3 = data[index + 2];
        return b1 == b2 && b2 == b3;
    }

    public static byte[] rleCompress(byte[] src) {
        ArrayList<Byte> dest = new ArrayList<Byte>();
        byte oldChar = 0;
        int srcLen = src.length;
        int i = 0;
        while (i < srcLen) {
            byte newChar;
            int count = 0;
            if (BitmapTools.isRepetitionStart(i, src, srcLen)) {
                while (i < srcLen) {
                    if (count == 0) {
                        oldChar = src[i];
                        count = 1;
                        ++i;
                        continue;
                    }
                    newChar = src[i];
                    if (newChar != oldChar) break;
                    ++i;
                    if (++count != 127) continue;
                }
                dest.add((byte)count);
                dest.add(oldChar);
                continue;
            }
            int start = i;
            while (i < srcLen) {
                if (count == 0) {
                    if (i + 2 >= srcLen) {
                        count = srcLen - i;
                        i = srcLen;
                        break;
                    }
                    oldChar = src[i + 2];
                    count = 3;
                    i += 3;
                    continue;
                }
                newChar = src[i];
                if (newChar == oldChar) {
                    --i;
                    --count;
                    break;
                }
                oldChar = newChar;
                ++i;
                if (++count != 127) continue;
            }
            dest.add((byte)(count | 0x80));
            for (int j = 0; j < count; ++j) {
                dest.add(src[start + j]);
            }
        }
        byte[] destArray = new byte[dest.size()];
        for (int j = 0; j < dest.size(); ++j) {
            destArray[j] = (Byte)dest.get(j);
        }
        return destArray;
    }

    public static byte[] rleUncompress(byte[] src) {
        ArrayList<Byte> dest = new ArrayList<Byte>();
        int index = 0;
        while (index < src.length) {
            byte flag;
            boolean isRepeat = ((flag = src[index++]) >> 7 & 0xFF) == 0;
            int count = flag & 0x7F;
            if (isRepeat) {
                byte v = src[index++];
                for (int i = 0; i < count; ++i) {
                    dest.add(v);
                }
                continue;
            }
            for (int i = 0; i < count; ++i) {
                dest.add(src[index++]);
            }
        }
        byte[] destArray = new byte[dest.size()];
        for (int i = 0; i < dest.size(); ++i) {
            destArray[i] = (Byte)dest.get(i);
        }
        return destArray;
    }
}

