/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.text.TextUtils;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.BarcodeFormat;
import com.jxit.printer.jxsdk.GuoJiang_CMD;
import com.jxit.printer.jxsdk.JXCommand;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.utils.GlobalUtil;

class Global_Page_CMD
extends JXCommand {
    private GuoJiang_CMD gj_cmd;
    private boolean isWhiteBG = false;
    private GlobalUtil.Barcode1DTextWriter mBarcode1DWriter;
    private PageTextWriter mWriter;

    public Global_Page_CMD(JXInterfaceAPI api) {
        super(api);
        this.gj_cmd = new GuoJiang_CMD(api);
        this.mWriter = new PageTextWriter();
    }

    public boolean pageSetup(int width, int height, byte paperType) {
        if (width <= 0) {
            JXLog.e(this.TAG, "ignore invalid printWidth " + width);
            return false;
        }
        if (paperType != 0 && paperType != 1 && paperType != 2) {
            JXLog.e(this.TAG, "paperType must be 0 or 1 or 2");
            return false;
        }
        return this.gj_cmd.gj_page_setup(width, height, paperType);
    }

    public boolean pagePrint() {
        return this.gj_cmd.gj_page_print(false, 1);
    }

    public boolean pagePrint(boolean isUpsideDown, int times) {
        return this.gj_cmd.gj_page_print(isUpsideDown, times);
    }

    public boolean x35_pagePrint(boolean isUpsideDown) {
        byte[] cmd = new byte[]{16, 33, 1, 1, 0, 1};
        if (isUpsideDown) {
            cmd[2] = 2;
        }
        return this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmd, 0, cmd.length);
    }

    public boolean x35_unwind_before_print(int line) {
        if (line >= 0) {
            byte[] cmd = new byte[]{16, 33, 5, 2, 0, (byte)(line & 0xFF), (byte)(line >> 8 & 0xFF)};
            return this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmd, 0, cmd.length);
        }
        return false;
    }

    public boolean x35_unwind_before_print() {
        byte[] cmd = new byte[]{16, 33, 8, 1, 0, 0};
        return this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmd, 0, cmd.length);
    }

    public boolean x35_feed_after_print(int line) {
        if (line >= 0) {
            byte[] cmd = new byte[]{16, 33, 6, 2, 0, (byte)(line & 0xFF), (byte)(line >> 8 & 0xFF)};
            return this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmd, 0, cmd.length);
        }
        return false;
    }

    public boolean x35_feed_after_print() {
        byte[] cmd = new byte[]{16, 33, 8, 1, 0, 1};
        return this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmd, 0, cmd.length);
    }

    public boolean x35_set_position_type_after_print(int positionType) {
        byte[] cmd = new byte[]{16, 33, 7, 1, 0, (byte)(positionType & 0xFF)};
        return this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmd, 0, cmd.length);
    }

    public void setWhiteBGMode(boolean isWhiteBG) {
        this.isWhiteBG = isWhiteBG;
    }

    public boolean drawText(int start_x, int start_y, int end_x, int end_y, String content, int fontSize, int rotate, boolean bold, boolean reverse, boolean underline, boolean singleLine) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            JXLog.e(this.TAG, "content is empty");
            return false;
        }
        int width = end_x - start_x + 1;
        int height = end_y - start_y + 1;
        if (width < fontSize || height < fontSize) {
            JXLog.e(this.TAG, "param error, text rectSize must be positive");
            return false;
        }
        boolean lineSpacing = false;
        Paint paint = new Paint(1);
        Paint bgPaint = null;
        paint.setTextSize((float)fontSize);
        paint.setFakeBoldText(bold);
        paint.setStrokeWidth(1.0f);
        Paint.FontMetrics fm = paint.getFontMetrics();
        if (reverse) {
            paint.setColor(-1);
            bgPaint = new Paint(1);
            bgPaint.setStyle(Paint.Style.FILL);
            bgPaint.setColor(-16777216);
        } else {
            paint.setColor(-16777216);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        float baseline = fm.descent - fm.ascent;
        String[] textArray = GlobalUtil.autoSplitText(paint, content, width).split("\n");
        int startX = 0;
        int startY = (int)(-fm.top);
        if (textArray != null && textArray.length > 0) {
            for (int i = 0; i < textArray.length; ++i) {
                if (reverse) {
                    float bgWidth = i == textArray.length - 1 ? paint.measureText(textArray[i]) : (float)width;
                    canvas.drawRect((float)start_x, (float)startY + fm.top, bgWidth, (float)startY + fm.bottom, bgPaint);
                }
                canvas.drawText(textArray[i], (float)startX, (float)startY, paint);
                if (underline) {
                    int lineEndX = startX + (int)paint.measureText(textArray[i]);
                    canvas.drawLine((float)startX, (float)(startY + 3), (float)lineEndX, (float)(startY + 3), paint);
                }
                if (singleLine) break;
                startY = (int)((float)startY + (baseline + fm.leading + (float)lineSpacing));
            }
        }
        if (rotate != 0) {
            bitmap = GlobalUtil.rotateBitmap(bitmap, rotate);
        }
        return this.drawGraphic(start_x, start_y, bitmap);
    }

    public boolean drawText(int start_x, int start_y, int end_x, int end_y, String content, int rotate, boolean singleLine) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            JXLog.e(this.TAG, "content is empty");
            return false;
        }
        int width = end_x - start_x + 1;
        int height = end_y - start_y + 1;
        if (width <= 0 || height <= 0) {
            JXLog.e(this.TAG, "param error, text rectSize must be positive");
            return false;
        }
        Bitmap bmp = this.mWriter.createTextBitmap(width, height, content, rotate, singleLine);
        return this.drawGraphic(start_x, start_y, bmp);
    }

    public boolean drawBox(int start_x, int start_y, int width, int height, int lineWidth, boolean fullLine) {
        if (width < 0 || height < 0 || lineWidth < 0) {
            JXLog.e(this.TAG, "param error");
            return false;
        }
        int end_x = start_x + width;
        int end_y = start_y + height;
        boolean drawLeft = this.drawLine(start_x, start_y, start_x, end_y, lineWidth, fullLine);
        boolean drawTop = this.drawLine(start_x, start_y, end_x, start_y, lineWidth, fullLine);
        boolean drawRight = this.drawLine(end_x - lineWidth, start_y, end_x - lineWidth, end_y, lineWidth, fullLine);
        boolean drawBottom = this.drawLine(start_x, end_y - lineWidth, end_x, end_y - lineWidth, lineWidth, fullLine);
        return drawLeft && drawTop && drawRight && drawBottom;
    }

    public boolean drawLine(int start_x, int start_y, int end_x, int end_y, int lineWidth, boolean fullLine) {
        if (lineWidth < 0) {
            JXLog.e(this.TAG, "line length and width must be greater than 0");
            return false;
        }
        int xChange = Math.abs(end_x - start_x);
        int yChange = Math.abs(end_y - start_y);
        float offset = (float)lineWidth / 2.0f;
        int bmpHeight = yChange + lineWidth;
        int bmpWidth = xChange + lineWidth;
        Bitmap bitmap = Bitmap.createBitmap((int)bmpWidth, (int)bmpHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        Paint paint = new Paint();
        paint.setColor(-16777216);
        if (fullLine) {
            paint.setPathEffect(null);
        } else {
            DashPathEffect pathEffect = new DashPathEffect(new float[]{5.0f, 5.0f, 5.0f, 5.0f}, 1.0f);
            paint.setPathEffect((PathEffect)pathEffect);
        }
        paint.setStrokeWidth((float)lineWidth);
        if (xChange >= yChange) {
            canvas.drawLine(0.0f, offset, (float)xChange, offset, paint);
        } else {
            canvas.drawLine(offset, 0.0f, offset, (float)yChange, paint);
        }
        return this.drawGraphic(start_x, start_y, bitmap);
    }

    public void setBarcode1DText(boolean isPositionBelow, int fontSize, boolean isBold, int margin, boolean breakLine) {
        this.mBarcode1DWriter = new GlobalUtil.Barcode1DTextWriter(isPositionBelow, fontSize, isBold, margin, breakLine);
    }

    public boolean drawBarcode1D(int start_x, int start_y, int width, int height, String content, int rotate, BarcodeFormat format) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            JXLog.e(this.TAG, "content can't be null or empty");
            return false;
        }
        Bitmap bitmap = GlobalUtil.barcode1D(width, height, content, rotate, format, this.mBarcode1DWriter);
        this.mBarcode1DWriter = null;
        return this.drawGraphic(start_x, start_y, bitmap);
    }

    public boolean drawBarcode2D(int start_x, int start_y, int width, int height, String content, int rotate, BarcodeFormat format) {
        Bitmap bitmap = GlobalUtil.barcode2D(width, height, content, format);
        if (rotate != 0) {
            bitmap = GlobalUtil.rotateBitmap(bitmap, rotate);
        }
        return this.drawGraphic(start_x, start_y, bitmap);
    }

    public boolean drawQrCode(int start_x, int start_y, int size, String content, int rotate) {
        Bitmap bitmap = GlobalUtil.barcode2D(size, size, content, BarcodeFormat.QR_CODE);
        if (rotate != 0) {
            bitmap = GlobalUtil.rotateBitmap(bitmap, rotate);
        }
        return this.drawGraphic(start_x, start_y, bitmap);
    }

    public boolean drawGraphic(int start_x, int start_y, Bitmap bmp) {
        int i;
        byte[] cmd = new byte[]{16, 33, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        if (width == 0 || height == 0) {
            JXLog.d("PageBlock,0:", width + "," + height);
            return false;
        }
        if (this.isWhiteBG) {
            cmd[2] = 4;
        }
        int ByteWidth = (width - 1) / 8 + 1;
        int UnitHeight = 1024 / ByteWidth;
        int Times = (height - 1) / UnitHeight + 1;
        cmd[5] = (byte)(ByteWidth % 256);
        cmd[6] = (byte)(ByteWidth / 256);
        cmd[9] = (byte)(start_x % 256);
        cmd[10] = (byte)(start_x / 256);
        int[] pixels = new int[width * height];
        bmp.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] DataByte = new byte[ByteWidth * height];
        for (i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int color = pixels[width * i + j];
                int A = color >> 24 & 0xFF;
                int R = color >> 16 & 0xFF;
                int G = color >> 8 & 0xFF;
                int B = color & 0xFF;
                if (A <= 0 || !((double)R * 0.3 + (double)G * 0.59 + (double)B * 0.11 < 180.0)) continue;
                int n = i * ByteWidth + j / 8;
                DataByte[n] = (byte)(DataByte[n] | (byte)(128 >> j % 8));
            }
        }
        for (i = 0; i < Times; ++i) {
            int L = 0;
            int H = 0;
            int O = 0;
            int Y = start_y;
            if (i == Times - 1) {
                L = 8 + ByteWidth * (height - i * UnitHeight);
                H = height - i * UnitHeight;
            } else {
                L = 8 + ByteWidth * UnitHeight;
                H = UnitHeight;
            }
            Y = start_y + i * UnitHeight;
            O = UnitHeight * i * ByteWidth;
            cmd[3] = (byte)(L % 256);
            cmd[4] = (byte)(L / 256);
            cmd[7] = (byte)(H % 256);
            cmd[8] = (byte)(H / 256);
            cmd[11] = (byte)(Y % 256);
            cmd[12] = (byte)(Y / 256);
            if (this.mAPI.writeBuffer(cmd, 0, cmd.length)) {
                if (this.mAPI.writeBuffer(DataByte, O, H * ByteWidth)) continue;
                JXLog.d("PageBlock,1:", DataByte.toString());
                return false;
            }
            JXLog.d("PageBlock,2:", DataByte.toString());
            return false;
        }
        return true;
    }

    public boolean feed() {
        return this.gj_cmd.gj_set_motor_control(1, 800, 0);
    }

    private class PageTextWriter
    extends GlobalUtil.GlobalTextWriter {
        private PageTextWriter() {
        }

        public Bitmap createTextBitmap(int width, int height, String content, int rotate, boolean singleLine) {
            Paint paint = this.getTextPaint();
            Paint bgPaint = this.getBgPaint();
            Paint.FontMetrics fm = paint.getFontMetrics();
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawColor(-1);
            float baseline = fm.descent - fm.ascent;
            String[] textArray = GlobalUtil.autoSplitText(paint, content, width).split("\n");
            int startX = 0;
            float startY = -fm.top;
            if (textArray != null && textArray.length > 0) {
                for (int i = 0; i < textArray.length; ++i) {
                    String text = textArray[i];
                    if (isReverse) {
                        float bgWidth = i == textArray.length - 1 ? paint.measureText(text) : (float)width;
                        canvas.drawRect(0.0f, startY + fm.top, bgWidth, startY + fm.bottom, bgPaint);
                    }
                    canvas.drawText(text, (float)startX, startY, paint);
                    if (isUnderline) {
                        int lineEndX = startX + (int)paint.measureText(text);
                        canvas.drawLine((float)startX, startY + 3.0f, (float)lineEndX, startY + 3.0f, paint);
                    }
                    if (singleLine) break;
                    startY += baseline + fm.leading + (float)lineSpace;
                }
            }
            if (rotate != 0) {
                bitmap = GlobalUtil.rotateBitmap(bitmap, rotate);
            }
            return bitmap;
        }
    }
}

