/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.graphics.Bitmap;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.JXCommand;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXBTTransfer;
import com.jxit.printer.model.JXBTTransferResult;
import com.jxit.printer.model.JXCommunication;
import com.jxit.printer.model.JXCommunicationError;
import com.jxit.printer.model.JXFirmwareFontUpgrade;
import com.jxit.printer.model.JXFirmwareInfo;
import com.jxit.printer.model.JXFontLibInfo;
import com.jxit.printer.model.JXHeadAndBatteryInfo;
import com.jxit.printer.model.JXHostLegalityEncryption;
import com.jxit.printer.model.JXOptocouplerInfo;
import com.jxit.printer.model.JXOptocouplerTestResult;
import com.jxit.printer.model.JXPrinterConfigInfo;
import com.jxit.printer.model.JXPrinterStatus;
import com.jxit.printer.model.JXSupportInfo;
import com.jxit.printer.model.JXUsageDataInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

class GuoJiang_CMD
extends JXCommand {
    private volatile int communicationError = 0;
    private volatile int sentPackageCount = 0;

    public GuoJiang_CMD(JXInterfaceAPI api) {
        super(api);
    }

    JXPrinterStatus gj_printer_status(int resOffset) {
        byte[] rep;
        JXPrinterStatus status;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = (status = new JXPrinterStatus()).createCommand(), rep = new byte[2 + resOffset], false) && status.parse(rep)) {
            return status;
        }
        return null;
    }

    boolean gj_test_device_legality() {
        byte[] rep;
        JXHostLegalityEncryption encryption = new JXHostLegalityEncryption();
        byte[] cmd = encryption.createCommand();
        if (this._write_read_data(cmd, rep = new byte[10])) {
            return encryption.parse(rep);
        }
        return false;
    }

    private boolean _write_read_variable_length_data(byte[] cmd, int nIndex, byte[] response) {
        boolean success;
        this.mAPI.flushReadBuffer();
        boolean bl = success = this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.readBuffer(response, ~nIndex, response.length, 5000);
        if (!success && this.mAPI.reopenConnection(200)) {
            return this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.readBuffer(response, ~nIndex, response.length, 5000);
        }
        return true;
    }

    JXHeadAndBatteryInfo gj_info_head_temperature_voltage() {
        JXHeadAndBatteryInfo info;
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = new byte[]{16, 4, 6}, rep = new byte[6]) && (info = new JXHeadAndBatteryInfo()).parse(rep)) {
            return info;
        }
        return null;
    }

    JXSupportInfo gj_info_support() {
        JXSupportInfo info;
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = new byte[]{16, 4, 8}, rep = new byte[8]) && (info = new JXSupportInfo()).parse(rep)) {
            return info;
        }
        return null;
    }

    String gj_info_firmware_version() {
        JXFirmwareInfo info;
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_variable_length_data(cmd = new byte[]{16, 4, 16}, 3, rep = new byte[128]) && (info = new JXFirmwareInfo()).parse(rep)) {
            return info.version;
        }
        return null;
    }

    JXUsageDataInfo gj_info_usage_data() {
        JXUsageDataInfo info;
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = new byte[]{16, 4, 32}, rep = new byte[16]) && (info = new JXUsageDataInfo()).parse(rep)) {
            return info;
        }
        return null;
    }

    String gj_info_configuration(int configID) {
        JXPrinterConfigInfo info;
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_variable_length_data(cmd = new byte[]{16, 2, (byte)configID, 82}, 4, rep = new byte[128]) && (info = new JXPrinterConfigInfo()).parse(rep)) {
            return info.value;
        }
        return null;
    }

    boolean gj_set_configuration(int configID, String value) {
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && (cmd = new JXPrinterConfigInfo().createCommand(configID, value)) != null && this._write_read_data(cmd, rep = new byte[5])) {
            return (rep[2] & 0xFF) == configID && rep[4] == 0;
        }
        return false;
    }

    boolean gj_set_config(int configID, String value) {
        if (this.gj_set_configuration(configID, value)) {
            return this.gj_set_save_configuration();
        }
        return false;
    }

    boolean gj_set_save_configuration() {
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = new byte[]{16, 2, 0, 83}, rep = new byte[5])) {
            return rep[4] == 0;
        }
        return false;
    }

    boolean gj_set_power_off() {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 3, 8, 0, -1, -3, 1, 16, 76, -11, -106, -49};
            byte[] rep = new byte[3];
            return this._write_read_data(cmd, rep);
        }
        return false;
    }

    boolean gj_print_x301_qr() {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 3, 8, 0, -1, -3, 61, 42, -99, -31, -83, -9};
            byte[] rep = new byte[3];
            return this._write_read_data(cmd, rep);
        }
        return false;
    }

    boolean gj_print_self_check_page() {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 3, 8, 0, -1, -3, 61, 42, -99, -31, -83, -8};
            byte[] rep = new byte[3];
            return this._write_read_data(cmd, rep);
        }
        return false;
    }

    boolean gj_set_motor_control(int cmdId, int firstStep, int secondStep) {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 12, (byte)cmdId, (byte)(firstStep & 0xFF), (byte)(firstStep >> 8 & 0xFF), (byte)(secondStep & 0xFF), (byte)(secondStep >> 8 & 0xFF)};
            return this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.readBuffer(new byte[3], 0, 3, 5000);
        }
        return false;
    }

    JXBTTransferResult gj_test_bluetooth_transfer_speed(int cmdId, int length, boolean isRandom, int timeout) {
        JXBTTransfer transfer = new JXBTTransfer(cmdId, length, isRandom);
        byte[] cmd = transfer.createCommand();
        byte[] rep = new byte[5];
        this.mAPI.flushReadBuffer();
        long writeST = System.currentTimeMillis();
        boolean writeSuccess = this.mAPI.writeBuffer(cmd, 0, cmd.length);
        if (writeSuccess) {
            long readST = System.currentTimeMillis();
            boolean readSuccess = this.mAPI.readBuffer(rep, 0, rep.length, timeout);
            if (readSuccess) {
                long finishST = System.currentTimeMillis();
                boolean success = transfer.parse(rep);
                if (!success) {
                    JXLog.e(this.TAG, "gj_test_bluetooth_transfer_speed parse fail");
                }
                return new JXBTTransferResult(cmd.length, writeST, readST, finishST, success);
            }
            JXLog.e(this.TAG, "gj_test_bluetooth_transfer_speed read fail");
        } else {
            JXLog.e(this.TAG, "gj_test_bluetooth_transfer_speed write fail");
        }
        return null;
    }

    boolean gj_test_communication(int testId, int length) {
        JXCommunication cs = new JXCommunication();
        byte[] cmd = cs.createCommand(testId, length, this.mAPI);
        if (cmd != null) {
            byte[] rep;
            if (testId == 0) {
                rep = new byte[cmd.length - 1];
            } else if (testId == 1) {
                rep = new byte[5];
            } else if (testId == 2) {
                rep = new byte[6];
            } else if (testId == 3) {
                rep = new byte[9];
            } else {
                JXLog.e(this.TAG, "unknown testId=" + testId);
                return false;
            }
            if (this._write_read_data(cmd, rep)) {
                return cs.parse(rep);
            }
        }
        return false;
    }

    JXCommunicationError gj_test_communication_continuously(int cmdType, int packageSize, int packageCount, boolean isRandomData, int intervalMills) {
        this.communicationError = 0;
        JXCommunicationError error = new JXCommunicationError(this.communicationError, null);
        ConcurrentLinkedQueue taskQueue = new ConcurrentLinkedQueue();
        this.mAPI.flushReadBuffer();
        new Thread(() -> {
            long serialNum = 0L;
            try {
                for (int i = 0; i < packageCount; ++i) {
                    JXCommunication cs = new JXCommunication();
                    cs.setSerialNum(serialNum++);
                    cs.setDataSourceType(isRandomData);
                    byte[] cmd = cs.createCommand(cmdType, packageSize, this.mAPI);
                    if (!this.mAPI.writeBuffer(cmd, 0, cmd.length)) {
                        String message;
                        String time = new SimpleDateFormat("MM/dd HH:mm:ss").format(System.currentTimeMillis());
                        error.message = message = String.format("%s:\u5199\u5165\u5931\u8d25\uff0c\u7b2c%d/%d\u7ec4\uff0c\u505c\u6b62\u53d1\u9001\u6570\u636e", time, i + 1, packageCount);
                        JXLog.e(this.TAG, message);
                        if (this.communicationError == 0) {
                            error.id = this.communicationError = 1;
                        }
                        break;
                    }
                    taskQueue.offer(cs);
                    if (intervalMills <= 0 || i + 1 >= packageCount) continue;
                    Thread.sleep(intervalMills);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.communicationError = 4;
            }
        }).start();
        try {
            int received = 0;
            int readCount = 0;
            while (received < packageCount && error.id == 0) {
                String message;
                String time;
                if (taskQueue.isEmpty()) continue;
                JXCommunication current = (JXCommunication)taskQueue.poll();
                JXLog.d(this.TAG, "will read SN=" + current.getSerialNum());
                byte[] rep = cmdType == 0 ? new byte[packageSize + 4] : (cmdType == 1 ? new byte[5] : (cmdType == 2 ? new byte[6] : (cmdType == 3 ? new byte[9] : new byte[]{})));
                JXLog.d(this.TAG, "received=" + received + ",readCount=" + ++readCount + ",taskQueSize=" + taskQueue.size());
                boolean readSuccess = this.mAPI.readBuffer(rep, 0, rep.length, 5000);
                if (this.communicationError == 1) {
                    JXLog.d(this.TAG, "\u53d1\u9001\u6570\u636e\u8d85\u65f6\uff0c\u5f85\u8bfb\u53d6\u6570\u636ecount=" + taskQueue.size());
                }
                if (!readSuccess) {
                    time = new SimpleDateFormat("MM/dd HH:mm:ss").format(System.currentTimeMillis());
                    message = time + ":\u8bfb\u53d6\u6570\u636e\u8d85\u65f6,\u5171\u63a5\u6536" + received + "\u7ec4,\u53d1\u9001" + (received + taskQueue.size() + 1) + "\u7ec4";
                    JXLog.e(this.TAG, message);
                    if (this.communicationError == 0) {
                        error.id = this.communicationError = 2;
                        error.message = message;
                    }
                    break;
                }
                if (!current.parse(rep)) {
                    time = new SimpleDateFormat("MM/dd HH:mm:ss").format(System.currentTimeMillis());
                    message = String.format("%s:\u6307\u4ee4\u8fd4\u56de\u6570\u636e\u4e0e\u9884\u671f\u4e0d\u7b26\uff0c\u7b2c%d/%d\u7ec4", time, received + 1, received + taskQueue.size() + 1) + "\n" + current.getErrorMessage();
                    JXLog.e(this.TAG, message);
                    if (this.communicationError == 0) {
                        error.id = this.communicationError = 3;
                        error.message = message;
                    }
                }
                ++received;
            }
        }
        catch (Exception e) {
            this.communicationError = 4;
            e.printStackTrace();
            error.id = this.communicationError;
            error.message = e.getMessage();
        }
        return error;
    }

    JXOptocouplerInfo gj_info_optocoupler_volume() {
        JXOptocouplerInfo info;
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_variable_length_data(cmd = new byte[]{16, 4, 48}, 3, rep = new byte[13]) && (info = new JXOptocouplerInfo()).parse(rep)) {
            return info;
        }
        return null;
    }

    boolean gj_set_mode_bluetooth_upgrade() {
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = new byte[]{16, 7, 1, 47, -103, 107, 35, 77, 88, -101}, rep = new byte[3])) {
            return rep[2] == 0;
        }
        return false;
    }

    boolean gj_set_mode_usb_upgrade() {
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = new byte[]{16, 7, 2, 47, -103, 107, 35, 77, 88, -101}, rep = new byte[3])) {
            return rep[2] == 0;
        }
        return false;
    }

    boolean gj_check_mode_bt_upgrade() {
        byte[] rep;
        byte[] cmd = JXFirmwareFontUpgrade.createUpgradeModeCheckCMD();
        if (this._write_read_data(cmd, rep = new byte[4])) {
            return JXFirmwareFontUpgrade.parseUpgradeModeCheck(rep);
        }
        return false;
    }

    int gj_check_upgrade_file_size(boolean isFont, int length) {
        byte[] cmd = JXFirmwareFontUpgrade.createUpgradeFileSizeCheckCMD(length, isFont);
        byte[] rep = new byte[4];
        this.mAPI.flushReadBuffer();
        if (this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.readBuffer(rep, 0, rep.length, 120000)) {
            return JXFirmwareFontUpgrade.parseUpgradeFileSizeCheckCMD(rep, isFont);
        }
        return -1;
    }

    boolean gj_set_upgrade_restart() {
        byte[] rep;
        byte[] cmd = JXFirmwareFontUpgrade.createUpgradeRestartCMD();
        if (this._write_read_data(cmd, rep = new byte[4])) {
            return JXFirmwareFontUpgrade.parseUpgradeRestartCheck(rep);
        }
        return false;
    }

    boolean gj_upgrade_upload_file(byte[] data, boolean isFont) {
        byte[] rep;
        byte[] cmd = JXFirmwareFontUpgrade.createUpgradeFileUploadCMD(data, isFont);
        if (this._write_read_data(cmd, rep = new byte[4])) {
            return JXFirmwareFontUpgrade.parseUpgradeFileUpload(rep, isFont);
        }
        return false;
    }

    int gj_test_print_speed() {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 3, 8, 0, -1, -3, 61, 42, -99, -31, -83, -4};
            long[] repTS = new long[2];
            this.mAPI.flushReadBuffer();
            if (this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.readBuffer(new byte[6], new byte[3], repTS, 20000)) {
                return (int)(repTS[1] - repTS[0]);
            }
        }
        return -1;
    }

    JXOptocouplerTestResult gj_test_optocoupler(int V, int O) {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 12, 17, (byte)(V & 0xFF), (byte)(V >> 8 & 0xFF), (byte)(O & 0xFF), (byte)(O >> 8 & 0xFF)};
            long[] repTS = new long[2];
            byte[] res = new byte[5];
            this.mAPI.flushReadBuffer();
            if (this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.readBuffer(new byte[3], res, repTS, 20000)) {
                int realFindLength = (res[3] & 0xFF) + (res[4] & 0xFF) * 255;
                return new JXOptocouplerTestResult(repTS[0], repTS[1], realFindLength, V);
            }
        }
        return null;
    }

    int gj_test_feed_speed() {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 3, 8, 0, -1, -3, 61, 42, -99, -31, -83, -6};
            long[] repTS = new long[2];
            this.mAPI.flushReadBuffer();
            if (this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.readBuffer(new byte[6], new byte[3], repTS, 20000)) {
                return (int)(repTS[1] - repTS[0]);
            }
        }
        return -1;
    }

    boolean gj_test_paper_feed_accuracy() {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 3, 8, 0, -1, -3, 61, 42, -99, -31, -83, -7};
            byte[] rep = new byte[3];
            return this._write_read_data(cmd, rep);
        }
        return false;
    }

    boolean gj_test_print_accuracy() {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 3, 8, 0, -1, -3, 61, 42, -99, -31, -83, -7};
            byte[] rep = new byte[3];
            return this._write_read_data(cmd, rep);
        }
        return false;
    }

    boolean gj_test_print_quality_blackness() {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 3, 8, 0, -1, -3, 61, 42, -99, -31, -83, -5};
            byte[] rep = new byte[3];
            return this._write_read_data(cmd, rep);
        }
        return false;
    }

    int gj_info_single_byte_font_lib_count() {
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = new byte[]{16, 4, 64}, rep = new byte[5])) {
            return rep[4] & 0xFF;
        }
        return -1;
    }

    JXFontLibInfo gj_info_single_byte_font_lib(int index) {
        JXFontLibInfo info;
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_variable_length_data(cmd = new byte[]{16, 4, 65, (byte)index}, 4, rep = new byte[128]) && (info = new JXFontLibInfo()).parse(rep)) {
            return info;
        }
        return null;
    }

    int gj_info_double_byte_font_lib_count() {
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_data(cmd = new byte[]{16, 4, 66}, rep = new byte[5])) {
            return rep[4] & 0xFF;
        }
        return -1;
    }

    JXFontLibInfo gj_info_double_byte_font_lib(int index) {
        JXFontLibInfo info;
        byte[] rep;
        byte[] cmd;
        if (this.mAPI.isConnected() && this._write_read_variable_length_data(cmd = new byte[]{16, 4, 67, (byte)index}, 4, rep = new byte[128]) && (info = new JXFontLibInfo()).parse(rep)) {
            return info;
        }
        return null;
    }

    boolean gj_set_label_size(int widthMM, int height, int paperType) {
        if (this.mAPI.isConnected()) {
            int width = widthMM * 8;
            byte[] cmd = new byte[]{16, 33, 0, 5, 0, (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)paperType};
            return this.mAPI.writeBuffer(cmd, 0, cmd.length);
        }
        return false;
    }

    boolean gj_set_print_forward_repeat(int repeatTimes) {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 33, 1, 1, 0, (byte)repeatTimes};
            return this.mAPI.writeBuffer(cmd, 0, cmd.length);
        }
        return false;
    }

    boolean gj_set_print_backward_repeat(int repeatTimes) {
        if (this.mAPI.isConnected()) {
            byte[] cmd = new byte[]{16, 33, 2, 1, 0, (byte)repeatTimes};
            return this.mAPI.writeBuffer(cmd, 0, cmd.length);
        }
        return false;
    }

    boolean gj_test_print_line(int widthMM, int count, int interval, int startMarginMM, int endMarginMM) {
        int height = count + (count - 1) * interval;
        int l = widthMM * height + 8;
        byte[] cmd = new byte[5 + l];
        cmd[0] = 16;
        cmd[1] = 33;
        cmd[2] = 3;
        cmd[3] = (byte)(l & 0xFF);
        cmd[4] = (byte)(l >> 8 & 0xFF);
        cmd[5] = (byte)(widthMM & 0xFF);
        cmd[6] = (byte)(widthMM >> 8 & 0xFF);
        cmd[7] = (byte)(height & 0xFF);
        cmd[8] = (byte)(height >> 8 & 0xFF);
        cmd[9] = 0;
        cmd[10] = 0;
        cmd[11] = 0;
        cmd[12] = 0;
        ArrayList<Integer> linePos = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            linePos.add(i * (interval + 1));
        }
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < widthMM; ++i) {
                int index = 13 + j * widthMM + i;
                cmd[index] = i < startMarginMM || i >= widthMM - endMarginMM ? 0 : (linePos.contains(j) ? -1 : 0);
            }
        }
        return this.mAPI.writeBuffer(cmd, 0, cmd.length);
    }

    boolean gj_print_dot_matrix(int widthMM, int height, float density) {
        int divider;
        if (widthMM <= 0 || widthMM > 72) {
            return false;
        }
        if (density == 1.0f) {
            divider = 1;
        } else if (density == 0.5f) {
            divider = 2;
        } else if (density == 0.25f) {
            divider = 4;
        } else if (density == 0.125f) {
            divider = 8;
        } else if (density == 0.0625f) {
            divider = 16;
        } else {
            JXLog.e(this.TAG, "undefined density " + density + " ,set density to 0.5f");
            divider = 2;
        }
        byte[] imageData = new byte[widthMM * height];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < widthMM; ++i) {
                int index = j * widthMM + i;
                int value = 0;
                switch (divider) {
                    case 1: {
                        value = -1;
                        break;
                    }
                    case 2: {
                        value = (byte)(170 >> (j & 1));
                        break;
                    }
                    case 4: {
                        value = (byte)(136 >> (j & 3));
                        break;
                    }
                    case 8: {
                        value = (byte)(128 >> (j & 7));
                        break;
                    }
                    case 16: {
                        int v = 32768 >> (j & 0xF);
                        value = (byte)((i & 1) == 0 ? v >> 8 : v & 0xFF);
                    }
                }
                imageData[index] = value;
            }
        }
        int unitHeight = 1024 / widthMM;
        int unitCount = (height - 1) / unitHeight + 1;
        int y = 0;
        byte[] cmdHeader = new byte[13];
        cmdHeader[0] = 16;
        cmdHeader[1] = 33;
        cmdHeader[2] = 3;
        cmdHeader[5] = (byte)(widthMM & 0xFF);
        cmdHeader[6] = (byte)(widthMM >> 8 & 0xFF);
        cmdHeader[9] = 0;
        cmdHeader[10] = 0;
        for (int i = 0; i < unitCount; ++i) {
            if (i == unitCount - 1) {
                unitHeight = height - y;
            }
            int l = widthMM * unitHeight + 8;
            cmdHeader[3] = (byte)(l & 0xFF);
            cmdHeader[4] = (byte)(l >> 8 & 0xFF);
            cmdHeader[7] = (byte)(unitHeight & 0xFF);
            cmdHeader[8] = (byte)(unitHeight >> 8 & 0xFF);
            cmdHeader[11] = (byte)(y & 0xFF);
            cmdHeader[12] = (byte)(y >> 8 & 0xFF);
            if (!this.mAPI.writeBuffer(cmdHeader, 0, cmdHeader.length)) {
                return false;
            }
            byte[] cmd = new byte[widthMM * unitHeight];
            System.arraycopy(imageData, y * widthMM, cmd, 0, unitHeight * widthMM);
            if (!this.mAPI.writeBuffer(cmd, 0, cmd.length)) {
                return false;
            }
            y += unitHeight;
        }
        return true;
    }

    public boolean gj_page_setup(int width, int height, byte paperType) {
        width = ((width - 1) / 8 + 1) * 8;
        byte wl = (byte)(width % 256);
        byte wh = (byte)(width / 256);
        byte hl = (byte)(height % 256);
        byte hh = (byte)(height / 256);
        byte[] cmd = new byte[]{16, 33, 0, 5, 0, wl, wh, hl, hh, paperType};
        return this.mAPI.writeBuffer(cmd, 0, cmd.length);
    }

    public boolean gj_page_data(int start_x, int start_y, int width, int height, byte[] data) {
        byte[] cmd = new byte[]{16, 33, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int length = data.length;
        cmd[3] = (byte)(length % 256);
        cmd[4] = (byte)(length / 256);
        cmd[5] = (byte)(width % 256);
        cmd[6] = (byte)(width / 256);
        cmd[7] = (byte)(height % 256);
        cmd[8] = (byte)(height / 256);
        cmd[9] = (byte)(start_x % 256);
        cmd[10] = (byte)(start_x / 256);
        cmd[11] = (byte)(start_y % 256);
        cmd[12] = (byte)(start_y / 256);
        return this.mAPI.writeBuffer(cmd, 0, cmd.length) && this.mAPI.writeBuffer(data, 0, data.length);
    }

    public boolean gj_page_bitmap(int start_x, int start_y, Bitmap bmp) {
        int i;
        byte[] cmd = new byte[]{16, 33, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        if (width == 0 || height == 0) {
            JXLog.d("PageBlock,0:", width + "," + height);
            return false;
        }
        int ByteWidth = (width - 1) / 8 + 1;
        int UnitHeight = 1024 / ByteWidth;
        int Times = (height - 1) / UnitHeight + 1;
        cmd[5] = (byte)(ByteWidth % 256);
        cmd[6] = (byte)(ByteWidth / 256);
        cmd[9] = (byte)(start_x % 256);
        cmd[10] = (byte)(start_x / 256);
        int[] pixels = new int[width * height];
        bmp.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] DataByte = new byte[ByteWidth * height];
        for (i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int color = pixels[width * i + j];
                int A = color >> 24 & 0xFF;
                int R = color >> 16 & 0xFF;
                int G = color >> 8 & 0xFF;
                int B = color & 0xFF;
                if (A <= 0 || !((double)R * 0.3 + (double)G * 0.59 + (double)B * 0.11 < 127.0)) continue;
                int n = i * ByteWidth + j / 8;
                DataByte[n] = (byte)(DataByte[n] | (byte)(128 >> j % 8));
            }
        }
        for (i = 0; i < Times; ++i) {
            int L = 0;
            int H = 0;
            int O = 0;
            int Y = start_y;
            if (i == Times - 1) {
                L = 8 + ByteWidth * (height - i * UnitHeight);
                H = height - i * UnitHeight;
            } else {
                L = 8 + ByteWidth * UnitHeight;
                H = UnitHeight;
            }
            Y = start_y + i * UnitHeight;
            O = UnitHeight * i * ByteWidth;
            cmd[3] = (byte)(L % 256);
            cmd[4] = (byte)(L / 256);
            cmd[7] = (byte)(H % 256);
            cmd[8] = (byte)(H / 256);
            cmd[11] = (byte)(Y % 256);
            cmd[12] = (byte)(Y / 256);
            if (this.mAPI.writeBuffer(cmd, 0, cmd.length)) {
                if (this.mAPI.writeBuffer(DataByte, O, H * ByteWidth)) continue;
                JXLog.d("PageBlock,1:", DataByte.toString());
                return false;
            }
            JXLog.d("PageBlock,2:", DataByte.toString());
            return false;
        }
        return true;
    }

    public boolean gj_page_print(boolean isUpsideDown, int times) {
        if (times > 255) {
            times = 255;
        }
        if (times < 1) {
            times = 1;
        }
        byte[] cmd = new byte[]{16, 33, 1, 1, 0, (byte)(times & 0xFF)};
        if (isUpsideDown) {
            cmd[2] = 2;
        }
        return this.mAPI.writeBuffer(cmd, 0, cmd.length);
    }
}

