/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.BarcodeFormat;
import com.jxit.printer.jxsdk.Global_Line_CMD;
import com.jxit.printer.jxsdk.Global_Page_CMD;
import com.jxit.printer.jxsdk.GuoJiang_CMD;
import com.jxit.printer.jxsdk.JXExecutors;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXPrinterStatus;
import com.jxit.printer.utils.GlobalUtil;
import com.jxit.printer.utils.JXJNISDK;

public class JXGlobalPrinter {
    private static final String TAG = "JXGlobalPrinter";
    private Global_Page_CMD PAGE;
    private Global_Line_CMD LINE;
    private JXInterfaceAPI mAPI;
    private PrintMode mPrintMode;
    private GuoJiang_CMD gj;

    public JXGlobalPrinter(JXInterfaceAPI interfaceAPI, PrintMode mode) {
        if (interfaceAPI == null) {
            JXLog.e(TAG, "interfaceApi must not be null!");
            throw new IllegalArgumentException("interfaceApi must not be null");
        }
        this.mAPI = interfaceAPI;
        this.mPrintMode = mode;
        this.gj = new GuoJiang_CMD(interfaceAPI);
        if (this.mPrintMode == PrintMode.Line) {
            this.LINE = new Global_Line_CMD(this.mAPI);
        } else {
            this.PAGE = new Global_Page_CMD(this.mAPI);
        }
    }

    public static void init(Context context, boolean showLog) {
        JXJNISDK.init();
    }

    public JXInterfaceAPI getInterfaceAPI() {
        return this.mAPI;
    }

    private void checkPrintMode4Method(boolean isLineMode) {
        if (isLineMode && this.mPrintMode == PrintMode.Line || !isLineMode && this.mPrintMode == PrintMode.Page) {
            return;
        }
        throw new IllegalArgumentException("this method can only be invoked in PrintMode " + (isLineMode ? "Line" : "Page"));
    }

    public boolean writeCmd(byte[] cmd) {
        try {
            JXLog.d_method(TAG, "writeCmd", new Object[]{cmd});
            return JXExecutors.printer().execute(() -> this.mAPI.writeBuffer(cmd, 0, cmd.length)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public void line_setMaxPrintWidth(int maxWidth) {
        this.checkPrintMode4Method(true);
        this.LINE.setMaxPrintWidth(maxWidth);
    }

    public boolean line_reset() {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_reset", "");
            return JXExecutors.printer().execute(() -> this.LINE.reset()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_feed(int n) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_feed", n);
            return JXExecutors.printer().execute(() -> this.LINE.feed(n)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_print() {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_print", "");
            return JXExecutors.printer().execute(() -> this.LINE.print()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_setLeftMargin(int margin) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_setLeftMargin", margin);
            return JXExecutors.printer().execute(() -> this.LINE.setLeftMargin(margin)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_setRightMargin(int margin) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_setRightMargin", margin);
            return JXExecutors.printer().execute(() -> this.LINE.setRightMargin(margin)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_setAlign(int align) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_setAlign", align);
            return JXExecutors.printer().execute(() -> this.LINE.setAlign(align)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public void line_setFontTypeface(Typeface typeface) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.typeface = typeface;
    }

    public void line_setFontUnderline(boolean isUnderline) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.isUnderline = isUnderline;
    }

    public void line_setFontBold(boolean isBold) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.isBold = isBold;
    }

    public void line_setFontItaly(boolean isItaly) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.isItaly = isItaly;
    }

    public void line_setFontSize(int fontSize) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.fontSize = fontSize;
    }

    public void line_setFontScale(int widthScale, int heightScale) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.fontWidthScale = widthScale;
        GlobalUtil.GlobalTextWriter.fontHeightScale = heightScale;
    }

    public void line_setLineSpacing(int lineSpacing) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.lineSpace = lineSpacing;
    }

    public void line_setLetterSpacing(int letterSpacing) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.letterSpace = letterSpacing;
    }

    public void line_setFontReverse(boolean isReverse) {
        this.checkPrintMode4Method(true);
        GlobalUtil.GlobalTextWriter.isReverse = isReverse;
    }

    public boolean line_drawText(String content) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_drawText", content);
            return JXExecutors.printer().execute(() -> this.LINE.drawText(content)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_drawGraphic(Bitmap bitmap) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_drawGraphic", "");
            return JXExecutors.printer().execute(() -> this.LINE.drawGraphic(bitmap)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_drawLine(float lineLength, int lineWidth, boolean isSolid) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_drawLine", Float.valueOf(lineLength), lineWidth, isSolid);
            return JXExecutors.printer().execute(() -> this.LINE.drawLine(lineLength, lineWidth, isSolid)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public void line_setBarcode1DText(boolean isPositionBelow, int fontSize, boolean isBold, int margin, boolean breakLine) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_setBarcode1DText", isPositionBelow, fontSize, isBold, margin, breakLine);
            JXExecutors.printer().execute(() -> this.LINE.setBarcode1DText(isPositionBelow, fontSize, isBold, margin, breakLine));
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
        }
    }

    public boolean line_drawBarcode1D(int width, int height, String content, int rotate, BarcodeFormat format) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_drawBarcode1D", new Object[]{width, height, content, rotate, format});
            return JXExecutors.printer().execute(() -> this.LINE.drawBarcode1D(width, height, content, rotate, format)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_drawBarcode2D(int width, int height, String content, int rotate, BarcodeFormat format) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_drawBarcode2D", new Object[]{width, height, content, rotate, format});
            return JXExecutors.printer().execute(() -> this.LINE.drawBarcode2D(width, height, content, rotate, format)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean line_drawLineSegments(int ... xPos) {
        this.checkPrintMode4Method(true);
        try {
            JXLog.d_method(TAG, "line_drawLineSegments", new Object[]{xPos});
            return JXExecutors.printer().execute(() -> this.LINE.drawLineSegments(xPos)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean page_setup(int width, int height, int paperType) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_pageSetup", width, height, paperType);
            return JXExecutors.printer().execute(() -> this.PAGE.pageSetup(width, height, (byte)paperType)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean page_feed() {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_feed", "");
            return JXExecutors.printer().execute(() -> this.PAGE.feed()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean page_print() {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_print", "");
            return JXExecutors.printer().execute(() -> this.PAGE.pagePrint()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean page_print(boolean isUpsideDown, int times) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_print", isUpsideDown, times);
            return JXExecutors.printer().execute(() -> this.PAGE.pagePrint(isUpsideDown, times)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public void page_resetFontSettings() {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.reset();
    }

    public void page_setFontTypeface(Typeface typeface) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.typeface = typeface;
    }

    public void page_setFontUnderline(boolean isUnderline) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.isUnderline = isUnderline;
    }

    public void page_setFontBold(boolean isBold) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.isBold = isBold;
    }

    public void page_setFontItaly(boolean isItaly) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.isItaly = isItaly;
    }

    public void page_setFontSize(int fontSize) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.fontSize = fontSize;
    }

    public void page_setFontScale(int widthScale, int heightScale) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.fontWidthScale = widthScale;
        GlobalUtil.GlobalTextWriter.fontHeightScale = heightScale;
    }

    public void page_setLineSpacing(int lineSpacing) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.lineSpace = lineSpacing;
    }

    public void page_setLetterSpacing(int letterSpacing) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.letterSpace = letterSpacing;
    }

    public void page_setFontReverse(boolean isReverse) {
        this.checkPrintMode4Method(false);
        GlobalUtil.GlobalTextWriter.isReverse = isReverse;
    }

    public boolean page_drawBox(int start_x, int start_y, int width, int height, int lineWidth, boolean isSolid) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_drawBox", start_x, start_y, width, height, lineWidth, isSolid);
            return JXExecutors.printer().execute(() -> this.PAGE.drawBox(start_x, start_y, width, height, lineWidth, isSolid)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean page_drawLine(int start_x, int start_y, int end_x, int end_y, int lineWidth, boolean isSolid) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_drawBox", start_x, start_y, end_x, end_y, lineWidth, isSolid);
            return JXExecutors.printer().execute(() -> this.PAGE.drawLine(start_x, start_y, end_x, end_y, lineWidth, isSolid)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean page_drawText(int start_x, int start_y, int end_x, int end_y, int rotate, boolean singleLine, String content) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_drawText", start_x, start_y, end_x, end_y, content, rotate, singleLine);
            return JXExecutors.printer().execute(() -> this.PAGE.drawText(start_x, start_y, end_x, end_y, content, rotate, singleLine)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean page_drawGraphic(int start_x, int start_y, Bitmap bmp) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_drawGraphic", start_x, start_y);
            return JXExecutors.printer().execute(() -> this.PAGE.drawGraphic(start_x, start_y, bmp)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public void page_setBarcode1DText(boolean isPositionBelow, int fontSize, boolean isBold, int margin, boolean breakLine) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_setBarcode1DText", isPositionBelow, fontSize, isBold, margin, breakLine);
            JXExecutors.printer().execute(() -> this.PAGE.setBarcode1DText(isPositionBelow, fontSize, isBold, margin, breakLine));
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
        }
    }

    public boolean page_drawBarcode1D(int start_x, int start_y, int width, int height, String content, int rotate, BarcodeFormat format) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_drawBarcode1D", new Object[]{width, height, content, rotate, format});
            return JXExecutors.printer().execute(() -> this.PAGE.drawBarcode1D(start_x, start_y, width, height, content, rotate, format)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean page_drawBarcode2D(int start_x, int start_y, int width, int height, String content, int rotate, BarcodeFormat format) {
        this.checkPrintMode4Method(false);
        try {
            JXLog.d_method(TAG, "page_drawBarcode2D", new Object[]{width, height, content, rotate, format});
            return JXExecutors.printer().execute(() -> this.PAGE.drawBarcode2D(start_x, start_y, width, height, content, rotate, format)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public String get_print_darkness() {
        JXLog.d_method(TAG, "get_print_darkness", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_configuration(21)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public String get_print_quality() {
        JXLog.d_method(TAG, "get_print_quality", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_info_configuration(22)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean set_print_darkness(String value) {
        JXLog.d_method(TAG, "set_print_darkness", value);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_config(21, value)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean set_print_quality(String value) {
        JXLog.d_method(TAG, "set_print_darkness", value);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_set_config(22, value)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public JXPrinterStatus get_printer_status() {
        JXLog.d_method(TAG, "info_printer_status", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_printer_status(0)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return null;
        }
    }

    public boolean set_print_unlock() {
        JXLog.d_method(TAG, "set_print_darkness", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.mAPI.isUnlock()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public boolean print_check_page() {
        JXLog.d_method(TAG, "set_print_darkness", new Object[0]);
        try {
            return JXExecutors.printer().execute(() -> this.gj.gj_print_self_check_page()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "execute exception " + e.getMessage());
            return false;
        }
    }

    public static enum PrintMode {
        Line,
        Page;

    }
}

