/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.model;

import androidx.annotation.NonNull;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXParser;
import java.util.ArrayList;
import java.util.List;

public class JXSupportInfo
implements JXParser {
    public int maxWidth;
    public int maxPageHeight;
    public int printDpi;
    public static final int JX_MOBILE_ESC_CMD = 1;
    public static final int JX_DESKTOP_ESC_CMD = 2;
    public static final int JX_CPCL_CMD = 4;
    public static final int JX_GJ_CMD = 8;
    public static final int JX_TSPL_IMAGE_CMD = 16;
    public static final int JX_TSPL_CMD = 32;
    public int commandType;

    @Override
    public boolean parse(byte[] data) {
        if (data == null || data.length != 8) {
            JXLog.e(this.getClass().getSimpleName(), "bad param");
            return false;
        }
        this.maxWidth = this.bytes2Int(data, 0, true);
        this.maxPageHeight = this.bytes2Int(data, 2, true);
        this.commandType = this.bytes2Int(data, 4, true);
        this.printDpi = this.bytes2Int(data, 6, true);
        return true;
    }

    public List<Integer> getSupportCommandTypes() {
        ArrayList<Integer> cmd = new ArrayList<Integer>();
        if ((1 & this.commandType) == 1) {
            cmd.add(1);
        }
        if ((2 & this.commandType) == 2) {
            cmd.add(2);
        }
        if ((4 & this.commandType) == 4) {
            cmd.add(4);
        }
        if ((8 & this.commandType) == 8) {
            cmd.add(8);
        }
        if ((0x10 & this.commandType) == 16) {
            cmd.add(16);
        }
        if ((0x20 & this.commandType) == 32) {
            cmd.add(32);
        }
        return cmd;
    }

    @NonNull
    public String toString() {
        return "\u6253\u5370\u5bbd\u5ea6 " + this.maxWidth + " \u70b9,\u9875\u9762\u9ad8\u5ea6 " + this.maxPageHeight + " \u70b9, \u652f\u6301\u6307\u4ee4 " + this.commandType;
    }
}

