/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.model;

import androidx.annotation.NonNull;
import com.jxit.printer.model.JXParser;

public class JXUsageDataInfo
implements JXParser {
    public int totalPowerOnCount;
    public int totalPowerOffCount;
    public int totalCoverOpenCount;
    public int totalPrintPoints;
    public float totalPrintLength;

    @Override
    public boolean parse(byte[] data) {
        if (data == null || data.length != 16) {
            return false;
        }
        this.totalPowerOffCount = this.bytes2Int(data, 4, false);
        this.totalPowerOnCount = this.totalPowerOffCount + 1;
        this.totalCoverOpenCount = this.bytes2Int(data, 8, false);
        this.totalPrintPoints = this.bytes2Int(data, 12, false);
        this.totalPrintLength = (float)this.totalPrintPoints / 8000.0f;
        return true;
    }

    @NonNull
    public String toString() {
        return "\u5173\u673a\u6b21\u6570\uff1a" + this.totalPowerOffCount + "\uff0c\u5f00\u673a\u6b21\u6570\uff1a" + this.totalPowerOnCount + "\uff0c\u5f00\u76d6\u6b21\u6570\uff1a" + this.totalCoverOpenCount + ", \u6253\u5370\u957f\u5ea6\uff1a" + this.totalPrintPoints + "\u70b9\uff0c\u6253\u5370\u957f\u5ea6\uff1a" + this.totalPrintLength + "\u7c73";
    }
}

