package com.jxit.sdkdemo.databinding;
import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.BR;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class BluetoothPairedlistviewItemBindingImpl extends BluetoothPairedlistviewItemBinding  {

    @Nullable
    private static final android.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = new android.util.SparseIntArray();
        sViewsWithIds.put(R.id.lvitem_image_first, 2);
    }
    // views
    @NonNull
    private final android.support.constraint.ConstraintLayout mboundView0;
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public BluetoothPairedlistviewItemBindingImpl(@Nullable android.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 3, sIncludes, sViewsWithIds));
    }
    private BluetoothPairedlistviewItemBindingImpl(android.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            , (android.widget.ImageView) bindings[2]
            , (android.widget.TextView) bindings[1]
            );
        this.lvitemTextview.setTag(null);
        this.mboundView0 = (android.support.constraint.ConstraintLayout) bindings[0];
        this.mboundView0.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x2L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.device == variableId) {
            setDevice((android.bluetooth.BluetoothDevice) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setDevice(@Nullable android.bluetooth.BluetoothDevice Device) {
        this.mDevice = Device;
        synchronized(this) {
            mDirtyFlags |= 0x1L;
        }
        notifyPropertyChanged(BR.device);
        super.requestRebind();
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        java.lang.String deviceNameChar = null;
        java.lang.String deviceName = null;
        java.lang.String deviceNameCharDeviceAddress = null;
        java.lang.String deviceNameCharDeviceAddressChar = null;
        java.lang.String deviceAddress = null;
        android.bluetooth.BluetoothDevice device = mDevice;

        if ((dirtyFlags & 0x3L) != 0) {



                if (device != null) {
                    // read device.name
                    deviceName = device.getName();
                    // read device.address
                    deviceAddress = device.getAddress();
                }


                // read (device.name) + ('(')
                deviceNameChar = (deviceName) + ('(');


                // read ((device.name) + ('(')) + (device.address)
                deviceNameCharDeviceAddress = (deviceNameChar) + (deviceAddress);


                // read (((device.name) + ('(')) + (device.address)) + (')')
                deviceNameCharDeviceAddressChar = (deviceNameCharDeviceAddress) + (')');
        }
        // batch finished
        if ((dirtyFlags & 0x3L) != 0) {
            // api target 1

            android.databinding.adapters.TextViewBindingAdapter.setText(this.lvitemTextview, deviceNameCharDeviceAddressChar);
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): device
        flag 1 (0x2L): null
    flag mapping end*/
    //end
}