package com.jxit.sdkdemo.adapter;

import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;

import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.databinding.BluetoothPairedlistviewItemBinding;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BluetoothDeviceAdapter extends RecyclerView.Adapter<BluetoothDeviceAdapter.VH> {
    private List<BluetoothDevice> mData = new ArrayList<>();
    private Context mContext;
    private LayoutInflater mInflater;
    private AdapterView.OnItemClickListener mListener;
    private AdapterView.OnItemLongClickListener mLongListener;

    public BluetoothDeviceAdapter(Context context) {
        mContext = context;
        mInflater = LayoutInflater.from(mContext);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        mListener = listener;
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        mLongListener = listener;
    }

    public void setDataAndNotify(Set<BluetoothDevice> devices) {
        mData.clear();
        if (devices != null) {
            for (BluetoothDevice device : devices) {
                if (!TextUtils.isEmpty(device.getName())) {
                    BluetoothClass btClass = device.getBluetoothClass();
                    if (btClass.getMajorDeviceClass() == BluetoothClass.Device.Major.IMAGING
                            || btClass.getMajorDeviceClass() == BluetoothClass.Device.Major.UNCATEGORIZED) {
                        mData.add(device);
                    }
                }
            }
        }
        notifyDataSetChanged();
    }

    public void removeAndNotify(int position) {
        if (position >= 0 && position < mData.size()) {
            mData.remove(position);
            notifyItemRemoved(position);
        }
    }

    public void appendDataAndNotify(BluetoothDevice device) {
        if (device != null) {
            for (BluetoothDevice d : mData) {
                if (d.getAddress().equals(device.getAddress())) {
                    return;
                }
            }
            mData.add(device);
            notifyDataSetChanged();
        }
    }


    @NonNull
    @Override
    public VH onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new VH(BluetoothPairedlistviewItemBinding.inflate(mInflater, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull VH vh, int i) {
        BluetoothDevice device = mData.get(i);
        vh.bd.setDevice(device);
        vh.itemView.setOnClickListener(v -> {
            if (mListener != null) {
                mListener.onItemClick(null, v, i, i);
            }
        });
        vh.itemView.setOnLongClickListener(v -> {
            if (mLongListener != null) {
                return mLongListener.onItemLongClick(null, v, i, i);
            }
            return false;
        });
        BluetoothClass btClass = device.getBluetoothClass();
        int imageRes = (btClass != null && btClass.getMajorDeviceClass() == BluetoothClass.Device.Major.IMAGING) ? R.drawable.printer24 : R.drawable.ic_bluetooth;
        vh.bd.lvitemImageFirst.setImageResource(imageRes);
    }

    public BluetoothDevice getItem(int i) {
        return mData.get(i);
    }

    @Override
    public int getItemCount() {
        return mData.size();
    }

    class VH extends RecyclerView.ViewHolder {
        public BluetoothPairedlistviewItemBinding bd;

        public VH(@NonNull BluetoothPairedlistviewItemBinding bd) {
            super(bd.getRoot());
            this.bd = bd;
        }
    }
}
