/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.graphics.Bitmap;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.JXCommand;
import com.jxit.printer.jxsdk.JXLog;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ESC_CMD
extends JXCommand {
    public ESC_CMD(JXInterfaceAPI api) {
        super(api);
    }

    boolean esc_print_text(String text) {
        byte[] data;
        try {
            data = text.getBytes("GBK");
        }
        catch (UnsupportedEncodingException var4) {
            JXLog.e(this.TAG, "String getBytes('GBK') failed");
            return false;
        }
        return this.mAPI.isConnected() && !this.mAPI.writeBuffer(data, 0, data.length) ? false : this.esc_write_null();
    }

    boolean esc_write_null() {
        byte[] cmd = new byte[]{0};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(cmd, 0, 1);
    }

    public boolean esc_write_bytes(byte[] bytes) {
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(bytes, 0, bytes.length);
    }

    public boolean esc_read_bytes(byte[] bytes) {
        return this.mAPI.isConnected() && this.mAPI.readBuffer(bytes, 0, bytes.length, 20000);
    }

    public boolean esc_clear() {
        return this.mAPI.isConnected() && this.mAPI.flushReadBuffer();
    }

    public boolean esc_reset() {
        byte[] reset = new byte[]{27, 64};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(reset, 0, reset.length);
    }

    public boolean esc_bold(boolean b) {
        byte[] esc_bold = new byte[]{27, 69, !b ? (byte)0 : 1};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_bold, 0, esc_bold.length);
    }

    public boolean esc_underline(int n) {
        byte[] esc_underline = new byte[]{27, 45, n == 1 || n == 49 ? (byte)1 : (n == 2 || n == 50 ? (byte)2 : 0)};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_underline, 0, esc_underline.length);
    }

    public boolean esc_print_formfeed() {
        byte[] esc_print_form_feed = new byte[]{10};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_print_form_feed, 0, esc_print_form_feed.length);
    }

    public boolean esc_print_label() {
        byte[] esc_print_label = new byte[]{29, 12};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_print_label, 0, esc_print_label.length);
    }

    public boolean esc_next_horizontal_tab() {
        byte[] esc_next_horizontal_tab = new byte[]{9};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_next_horizontal_tab, 0, esc_next_horizontal_tab.length);
    }

    public boolean esc_left_black_label() {
        byte[] esc_left_black_label = new byte[]{12};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_left_black_label, 0, esc_left_black_label.length);
    }

    public boolean esc_select_cutting_mode() {
        byte[] esc_select_cutting_mode = new byte[]{29, 86, 0};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_select_cutting_mode, 0, esc_select_cutting_mode.length);
    }

    public boolean esc_select_cutting_mode(int n) {
        byte[] esc_select_cutting_mode = new byte[]{29, 86, 66, 0};
        esc_select_cutting_mode[3] = n >= 0 && n <= 255 ? (n == 0 ? (byte)0 : (byte)n) : (byte)0;
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_select_cutting_mode, 0, esc_select_cutting_mode.length);
    }

    public boolean esc_print_enter() {
        byte[] esc_print_enter = new byte[]{13};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_print_enter, 0, esc_print_enter.length);
    }

    public boolean esc_right_spacing(int n) {
        byte[] esc_right_space = new byte[3];
        esc_right_space[0] = 27;
        esc_right_space[1] = 32;
        if (n < 0) {
            esc_right_space[2] = 0;
        } else if (0 <= n && n <= 255) {
            esc_right_space[2] = (byte)n;
        } else if (n > 255) {
            esc_right_space[2] = -1;
        }
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_right_space, 0, esc_right_space.length);
    }

    public boolean esc_print_mode(int n) {
        byte[] esc_print_mode = new byte[]{27, 33, n <= 0 ? (byte)0 : (n == 1 ? (byte)1 : (n == 2 ? (byte)2 : (n == 3 ? (byte)3 : (n == 8 ? (byte)8 : (n == 16 ? (byte)16 : (n == 32 ? (byte)32 : (n == 128 ? (byte)-128 : (n >= 255 ? (byte)-1 : (byte)n))))))))};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_print_mode, 0, esc_print_mode.length);
    }

    public boolean esc_absolute_print_position(int nL, int nH) {
        byte[] esc_right_space = new byte[]{27, 36, nL < 0 || nL > 255 ? (byte)0 : (byte)nL, nH < 0 || nH > 255 ? (byte)0 : (byte)nH};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_right_space, 0, esc_right_space.length);
    }

    public boolean esc_raster_image(Bitmap bitmap) {
        int count;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int widthByte = (width - 1) / 8 + 1;
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int UNIT_SIZE = 2040;
        int unitHeight = 2039 / widthByte + 1;
        int temp = 0;
        for (int startY = 0; startY < height; startY += count) {
            int i;
            count = startY + unitHeight < height ? unitHeight : height - startY;
            byte[] data = new byte[widthByte * count];
            for (int y = startY; y < startY + count; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = pixels[width * y + x];
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel & 0xFF;
                    boolean value = alpha == 0 ? false : (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11) <= 180;
                    int offset = x % 8;
                    if (value) {
                        temp = (byte)(temp | 128 >> offset);
                    }
                    if (offset != 7 && x < width - 1) continue;
                    data[x / 8 + widthByte * (y - startY)] = temp;
                    temp = 0;
                }
            }
            byte[] cmd = new byte[]{29, 118, 48, 0, (byte)(widthByte & 0xFF), (byte)(widthByte >> 16 & 0xFF), (byte)(count & 0xFF), (byte)(count >> 16 & 0xFF)};
            byte[] send = new byte[cmd.length + data.length];
            for (i = 0; i < cmd.length; ++i) {
                send[i] = cmd[i];
            }
            for (i = 0; i < data.length; ++i) {
                send[i + cmd.length] = data[i];
            }
            if (!this.mAPI.writeBuffer(send, 0, send.length)) {
                JXLog.e(this.TAG, "sendRaster failed, startY=" + startY + ",count=" + count);
                return false;
            }
            JXLog.d(this.TAG, "sendRaster startY=" + startY + ",endY=" + (startY + count));
        }
        return true;
    }

    private boolean sendRasterDataLines(List<byte[]> dataList, int widthByte, int startY, int count) {
        int i;
        byte[] cmd;
        int MAX_SIZE = 2048;
        int totalDataLength = 2040;
        int unitHeight = (totalDataLength - 1) / widthByte + 1;
        while (count > unitHeight) {
            cmd = new byte[]{29, 118, 48, 0, (byte)(widthByte & 0xFF), (byte)(widthByte >> 16 & 0xFF), (byte)(unitHeight & 0xFF), (byte)(unitHeight >> 16 & 0xFF)};
            if (this.mAPI.writeBuffer(cmd, 0, cmd.length)) {
                for (i = 0; i < unitHeight; ++i) {
                    this.mAPI.writeBuffer(dataList.get(startY + i), 0, widthByte);
                }
            }
            JXLog.e(this.TAG, "sendRaster startY=" + startY + ",endY=" + (startY + unitHeight));
            startY += unitHeight;
            count -= unitHeight;
        }
        cmd = new byte[]{29, 118, 48, 0, (byte)(widthByte & 0xFF), (byte)(widthByte >> 16 & 0xFF), (byte)(count & 0xFF), (byte)(count >> 16 & 0xFF)};
        if (this.mAPI.writeBuffer(cmd, 0, cmd.length)) {
            for (i = 0; i < count; ++i) {
                this.mAPI.writeBuffer(dataList.get(startY + i), 0, widthByte);
            }
        }
        JXLog.e(this.TAG, "sendRaster startY=" + startY + ",endY=" + (startY + count));
        return true;
    }

    private boolean sendRasterBlankLines(int count) {
        while (count > 255) {
            JXLog.e(this.TAG, "sendBlank count=255");
            this.mAPI.writeBuffer(new byte[]{27, 74, -1}, 0, 3);
            count -= 255;
        }
        if (count > 0) {
            JXLog.e(this.TAG, "sendBlank count=" + count);
            return this.mAPI.writeBuffer(new byte[]{27, 74, (byte)count}, 0, 3);
        }
        return false;
    }

    public boolean esc_bitmap_mode(int m, Bitmap bitmap) {
        if (m != 1 && m != 32 && m != 33) {
            m = 0;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        ArrayList<Bitmap> bmpList = new ArrayList<Bitmap>();
        if (height > 240) {
            for (int y = 0; y < height; y += 240) {
                Bitmap subBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)y, (int)width, (int)(y + 240 <= height ? 240 : height - y));
                bmpList.add(subBmp);
            }
        } else {
            bmpList.add(bitmap);
        }
        for (Bitmap bmp : bmpList) {
            if (this._esc_bitmap_mode(m, bmp)) continue;
            return false;
        }
        return true;
    }

    public boolean _esc_bitmap_mode(int m, Bitmap bitmap) {
        if (m != 1 && m != 32 && m != 33) {
            m = 0;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        ArrayList<Bitmap> bmps = new ArrayList<Bitmap>();
        if (height > 240) {
            for (int y = 0; y >= bitmap.getHeight(); y += 240) {
                Bitmap subBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)y, (int)width, (int)240);
                bmps.add(subBmp);
            }
        } else {
            bmps.add(bitmap);
        }
        int heightbytes = (height - 1) / 8 + 1;
        if (m == 0 || m == 1) {
            int bufsize = width * heightbytes;
            byte[] maparray = new byte[bufsize];
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int pixel = pixels[width * j + i];
                    int A = pixel >> 24 & 0xFF;
                    int R = pixel >> 16 & 0xFF;
                    int G = pixel >> 8 & 0xFF;
                    int B = pixel & 0xFF;
                    if (A <= 0 || !((double)R * 0.3 + (double)G * 0.59 + (double)B * 0.11 < 180.0)) continue;
                    int n = i + j / 8 * width;
                    maparray[n] = (byte)(maparray[n] | (byte)(128 >> j % 8));
                }
            }
            byte[] Cmd = new byte[5];
            byte[] pictureTop = new byte[]{27, 51, 0};
            if (!this.mAPI.writeBuffer(pictureTop, 0, pictureTop.length)) {
                return false;
            }
            for (int i = 0; i < heightbytes; ++i) {
                Cmd[0] = 27;
                Cmd[1] = 42;
                Cmd[2] = (byte)m;
                Cmd[3] = (byte)(width % 256);
                Cmd[4] = (byte)(width / 256);
                if (!this.mAPI.writeBuffer(Cmd, 0, 5)) {
                    return false;
                }
                if (!this.mAPI.writeBuffer(maparray, i * width, width)) {
                    return false;
                }
                if (this.mAPI.writeBuffer(new byte[]{13, 10}, 0, 2)) continue;
                return false;
            }
        } else {
            if (heightbytes % 3 != 0) {
                heightbytes += 3 - heightbytes % 3;
            }
            int bufsize = width * heightbytes;
            byte[] maparray = new byte[bufsize];
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int index;
                    int pixel = pixels[width * j + i];
                    int A = pixel >> 24 & 0xFF;
                    int R = pixel >> 16 & 0xFF;
                    int G = pixel >> 8 & 0xFF;
                    int B = pixel & 0xFF;
                    if (A <= 0 || !((double)R * 0.3 + (double)G * 0.59 + (double)B * 0.11 < 180.0) || (index = 3 * width * (j / 24) + i * 3 + j % 24 / 8) >= bufsize) continue;
                    int n = index;
                    maparray[n] = (byte)(maparray[n] | (byte)(128 >> j % 8));
                }
            }
            byte[] Cmd = new byte[5];
            byte[] pictureTop = new byte[]{27, 51, 0};
            if (!this.mAPI.writeBuffer(pictureTop, 0, pictureTop.length)) {
                return false;
            }
            for (int j = 0; j < (heightbytes - 1) / 3 + 1; ++j) {
                Cmd[0] = 27;
                Cmd[1] = 42;
                Cmd[2] = (byte)m;
                Cmd[3] = (byte)(width % 256);
                Cmd[4] = (byte)(width / 256);
                if (!this.mAPI.writeBuffer(Cmd, 0, 5)) {
                    return false;
                }
                if (!this.mAPI.writeBuffer(maparray, j * width * 3, width * 3)) {
                    return false;
                }
                if (this.mAPI.writeBuffer(new byte[]{13, 10}, 0, 2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean esc_default_line_height() {
        byte[] esc_default_line_height = new byte[]{27, 50};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_default_line_height, 0, esc_default_line_height.length);
    }

    public boolean esc_line_height(int n) {
        byte[] esc_line_height = new byte[]{27, 51, n < 0 ? (byte)0 : (n > 255 ? (byte)-1 : (byte)n)};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_line_height, 0, esc_line_height.length);
    }

    public boolean esc_horizontal_tab_position(int[] n) {
        byte[] esc_horizontal_tab_position_top = new byte[]{27, 68};
        byte[] targetB = new byte[32];
        if (n.length > 32) {
            int[] targetI = Arrays.copyOfRange(n, 0, 32);
            targetB[0] = (byte)targetI[0];
            for (int i = 1; i < targetI.length; ++i) {
                if (targetI[i] <= targetI[i - 1]) {
                    return false;
                }
                targetB[i] = (byte)targetI[i];
            }
            if (!this.mAPI.isConnected()) {
                return false;
            }
            if (!this.mAPI.writeBuffer(esc_horizontal_tab_position_top, 0, esc_horizontal_tab_position_top.length)) {
                return false;
            }
            if (!this.mAPI.writeBuffer(targetB, 0, targetB.length)) {
                return false;
            }
        } else {
            byte[] target = new byte[n.length];
            target[0] = (byte)n[0];
            for (int i = 1; i < n.length; ++i) {
                if (n[i] <= n[i - 1]) {
                    return false;
                }
                target[i] = (byte)n[i];
            }
            if (!this.mAPI.isConnected()) {
                return false;
            }
            if (!this.mAPI.writeBuffer(esc_horizontal_tab_position_top, 0, esc_horizontal_tab_position_top.length)) {
                return false;
            }
            if (!this.mAPI.writeBuffer(target, 0, target.length)) {
                return false;
            }
            if (!this.mAPI.writeBuffer(new byte[]{0}, 0, 1)) {
                return false;
            }
        }
        return true;
    }

    public boolean esc_print_formfeed(int n) {
        byte[] esc_print_formfeed = new byte[]{27, 74, n < 0 ? (byte)0 : (n > 255 ? (byte)-1 : (byte)n)};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_print_formfeed, 0, esc_print_formfeed.length);
    }

    public boolean esc_font(int n) {
        byte[] esc_font = new byte[]{27, 77, 0};
        esc_font[0] = 27;
        esc_font[1] = 77;
        esc_font[2] = n == 1 || n == 49 ? 1 : (n == 2 || n == 50 ? 2 : (n == 3 || n == 51 ? 3 : 0));
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_font, 0, esc_font.length);
    }

    public boolean esc_national_character_set(int n) {
        byte[] esc_national_character_set = new byte[]{27, 82, n == 1 ? (byte)1 : (n == 2 ? (byte)2 : (n == 3 ? (byte)3 : (n == 4 ? (byte)4 : (n == 5 ? (byte)5 : (n == 6 ? (byte)6 : (n == 7 ? (byte)7 : (n == 8 ? (byte)8 : (n == 9 ? (byte)9 : (n == 10 ? (byte)10 : (n == 11 ? (byte)11 : (n == 12 ? (byte)12 : (n == 13 ? (byte)13 : 0))))))))))))};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_national_character_set, 0, esc_national_character_set.length);
    }

    public boolean esc_rotate(int n) {
        byte[] esc_rotate = new byte[]{27, 86, n == 1 || n == 49 ? (byte)1 : (n == 2 || n == 50 ? (byte)2 : (n == 3 || n == 51 ? (byte)3 : 0))};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_rotate, 0, esc_rotate.length);
    }

    public boolean esc_relative_print_position(int nL, int nH) {
        byte[] esc_relative_print_position = new byte[]{27, 92, nL < 0 ? (byte)0 : (nL > 255 ? (byte)-1 : (byte)nL), nH < 0 ? (byte)0 : (nH > 255 ? (byte)-1 : (byte)nH)};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_relative_print_position, 0, esc_relative_print_position.length);
    }

    public boolean esc_align(int n) {
        byte[] esc_align = new byte[]{27, 97, n == 1 || n == 49 ? (byte)1 : (n == 2 || n == 50 ? (byte)2 : 0)};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_align, 0, esc_align.length);
    }

    public boolean esc_print_formfeed_row(int n) {
        byte[] esc_print_formfeed_row = new byte[]{27, 100, n < 0 ? (byte)0 : (n > 255 ? (byte)-1 : (byte)n)};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_print_formfeed_row, 0, esc_print_formfeed_row.length);
    }

    public boolean esc_character_code_page(int n) {
        byte[] esc_character_code_page = new byte[]{27, 116, n == 1 ? (byte)1 : (n == 2 ? (byte)2 : (n == 3 ? (byte)3 : (n == 4 ? (byte)4 : (n == 5 ? (byte)5 : (n == 6 ? (byte)6 : (n == 7 ? (byte)7 : (n == 8 ? (byte)8 : (n == 9 ? (byte)9 : (n == 10 ? (byte)10 : (n == 11 ? (byte)11 : (n == 12 ? (byte)12 : (n == 13 ? (byte)13 : (n == 14 ? (byte)14 : (n == 15 ? (byte)15 : (n == 16 ? (byte)16 : (n == 17 ? (byte)17 : (n == 18 ? (byte)18 : (n == 19 ? (byte)19 : (n == 20 ? (byte)20 : (n == 21 ? (byte)21 : (n == 22 ? (byte)22 : (n == 23 ? (byte)23 : (n == 24 ? (byte)24 : (n == 30 ? (byte)30 : (n == 40 ? (byte)40 : (n == 41 ? (byte)41 : (n == 42 ? (byte)42 : (n == 43 ? (byte)43 : (n == 50 ? (byte)50 : (n == 252 ? (byte)-4 : (n == 253 ? (byte)-3 : (n == 254 ? (byte)-2 : (n == 255 ? (byte)-1 : 0)))))))))))))))))))))))))))))))))};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_character_code_page, 0, esc_character_code_page.length);
    }

    public boolean esc_character_size(int n) {
        byte[] esc_character_size = new byte[3];
        esc_character_size[0] = 29;
        esc_character_size[1] = 33;
        int scale = n - 1;
        int param = scale + (scale << 4);
        esc_character_size[2] = (byte)(param & 0xFF);
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_character_size, 0, esc_character_size.length);
    }

    public boolean esc_define_print_download_bitmap(int x, int y, byte[] data, int m) {
        byte[] esc_define_download_bitmap = new byte[4];
        esc_define_download_bitmap[0] = 29;
        esc_define_download_bitmap[1] = 42;
        if (x < 1 || x > 255 || y < 1 || y > 48 || x * y > 1536 || data.length != x * y * 8) {
            return false;
        }
        esc_define_download_bitmap[2] = (byte)x;
        esc_define_download_bitmap[3] = (byte)y;
        byte[] target = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            target[i] = data[i];
        }
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_define_download_bitmap, 0, esc_define_download_bitmap.length)) {
            return false;
        }
        if (!this.mAPI.writeBuffer(target, 0, target.length)) {
            return false;
        }
        byte[] esc_print_download_bitmap = new byte[]{29, 47, m == 1 || m == 49 ? (byte)1 : (m == 2 || m == 50 ? (byte)2 : (m == 3 || m == 51 ? (byte)3 : 0))};
        return this.mAPI.writeBuffer(esc_print_download_bitmap, 0, esc_print_download_bitmap.length);
    }

    public boolean esc_black_white_reverse(boolean b) {
        byte[] esc_black_white_reverse = new byte[3];
        esc_black_white_reverse[0] = 29;
        esc_black_white_reverse[1] = 66;
        if (!b) {
            esc_black_white_reverse[2] = 0;
        } else if (b) {
            esc_black_white_reverse[2] = 1;
        }
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_black_white_reverse, 0, esc_black_white_reverse.length);
    }

    public boolean esc_left_margin(int nL, int nH) {
        byte[] esc_left_margin = new byte[4];
        esc_left_margin[0] = 29;
        esc_left_margin[1] = 76;
        if (0 <= nL && nL <= 255 && 0 <= nH && nH <= 255) {
            esc_left_margin[2] = (byte)nL;
            esc_left_margin[3] = (byte)nH;
        } else {
            esc_left_margin[2] = 0;
            esc_left_margin[3] = 0;
        }
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_left_margin, 0, esc_left_margin.length);
    }

    public boolean esc_move_unit(int x, int y) {
        byte[] esc_move_unit = new byte[4];
        esc_move_unit[0] = 29;
        esc_move_unit[1] = 80;
        if (0 <= x && x <= 255 && 0 <= y && y <= 255) {
            esc_move_unit[2] = (byte)x;
            esc_move_unit[3] = (byte)y;
        } else {
            esc_move_unit[2] = 0;
            esc_move_unit[3] = 0;
        }
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_move_unit, 0, esc_move_unit.length);
    }

    public boolean esc_chinese_mode(boolean b) {
        byte[] esc_chinese_mode = new byte[]{28, !b ? (byte)46 : 38};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_chinese_mode, 0, esc_chinese_mode.length);
    }

    public boolean esc_chinese_character_mode(int n) {
        byte[] esc_chinese_character_mode = new byte[]{28, 33, n == 4 ? (byte)4 : (n == 8 ? (byte)8 : (n == 128 ? (byte)-128 : (n == 12 ? (byte)12 : (n == 132 ? (byte)-124 : (n == 136 ? (byte)-120 : (n == 140 ? (byte)-116 : 0))))))};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_chinese_character_mode, 0, esc_chinese_character_mode.length);
    }

    public boolean esc_chinese_character_underline_mode(int n) {
        byte[] esc_chinese_character_underline_mode = new byte[]{28, 45, n == 1 || n == 49 ? (byte)1 : (n == 2 || n == 50 ? (byte)2 : 0)};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_chinese_character_underline_mode, 0, esc_chinese_character_underline_mode.length);
    }

    public boolean esc_define_chinese_character(int c2, byte[] data) {
        byte[] esc_define_chinese_character = new byte[4];
        esc_define_chinese_character[0] = 28;
        esc_define_chinese_character[1] = 50;
        esc_define_chinese_character[2] = -2;
        if (c2 < 161 || c2 > 254 || data.length != 72) {
            return false;
        }
        for (byte aData : data) {
            if (aData >= 0 && aData <= 255) continue;
            return false;
        }
        esc_define_chinese_character[3] = (byte)c2;
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_define_chinese_character, 0, esc_define_chinese_character.length)) {
            return false;
        }
        byte[] target = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            target[i] = data[i];
        }
        return this.mAPI.writeBuffer(target, 0, target.length);
    }

    public boolean esc_chinese_character_twice_height_width(boolean b) {
        byte[] esc_chinese_character_twice_height_width = new byte[]{28, 87, !b ? (byte)0 : 1};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_chinese_character_twice_height_width, 0, esc_chinese_character_twice_height_width.length);
    }

    public boolean esc_print_to_right_black_label() {
        byte[] esc_print_to_right_black_label = new byte[]{14};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_print_to_right_black_label, 0, esc_print_to_right_black_label.length);
    }

    public boolean esc_print_to_label() {
        byte[] esc_print_to_label = new byte[]{29, 12};
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_print_to_label, 0, esc_print_to_label.length);
    }

    public boolean esc_print_grating_bitmap(int m, Bitmap bitmap) {
        byte[] esc_print_grating_bitmap = new byte[8];
        esc_print_grating_bitmap[0] = 29;
        esc_print_grating_bitmap[1] = 118;
        esc_print_grating_bitmap[2] = 48;
        esc_print_grating_bitmap[3] = m == 1 || m == 49 ? 1 : (m == 2 || m == 50 ? 2 : (m == 3 || m == 51 ? 3 : 0));
        bitmap = Bitmap.createBitmap((Bitmap)bitmap);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int widthbytes = (width - 1) / 8 + 1;
        int bufsize = height * widthbytes;
        byte[] maparray = new byte[bufsize];
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int pixel = pixels[width * j + i];
                if (pixel == -1) continue;
                int n = j * widthbytes + i / 8;
                maparray[n] = (byte)(maparray[n] | (byte)(128 >> i % 8));
            }
        }
        esc_print_grating_bitmap[4] = (byte)(widthbytes % 256);
        esc_print_grating_bitmap[5] = (byte)(widthbytes / 256);
        esc_print_grating_bitmap[6] = (byte)(height % 256);
        esc_print_grating_bitmap[7] = (byte)(height / 256);
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_print_grating_bitmap, 0, esc_print_grating_bitmap.length)) {
            return false;
        }
        return this.mAPI.writeBuffer(maparray, 0, maparray.length);
    }

    public boolean esc_barcode_1d(int HRI_position, int HRI_font, int width, int height, int type, String content) {
        byte[] esc_barcode_1d_HRI_position = new byte[]{29, 72, 0};
        if (HRI_position == 1 || HRI_position == 49) {
            esc_barcode_1d_HRI_position[2] = 1;
        }
        esc_barcode_1d_HRI_position[2] = HRI_position == 2 || HRI_position == 50 ? 2 : 0;
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_barcode_1d_HRI_position, 0, esc_barcode_1d_HRI_position.length)) {
            return false;
        }
        byte[] esc_barcode_1d_HRI_font = new byte[]{29, 102, 0};
        esc_barcode_1d_HRI_font[2] = HRI_font == 1 || HRI_font == 49 ? (byte)1 : 0;
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_barcode_1d_HRI_font, 0, esc_barcode_1d_HRI_font.length)) {
            return false;
        }
        byte[] esc_barcode_1d_width = new byte[]{29, 119, 0};
        esc_barcode_1d_width[2] = 1;
        if (width == 2) {
            esc_barcode_1d_width[2] = 2;
        }
        if (width == 3) {
            esc_barcode_1d_width[2] = 3;
        }
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_barcode_1d_width, 0, esc_barcode_1d_width.length)) {
            return false;
        }
        byte[] esc_barcode_1d_height = new byte[]{29, 104, -94};
        esc_barcode_1d_height[2] = height <= 0 || height > 255 ? -94 : (byte)height;
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_barcode_1d_height, 0, esc_barcode_1d_height.length)) {
            return false;
        }
        type = type == 0 || type == 65 ? 0 : (type == 1 || type == 66 ? 1 : (type == 2 || type == 67 ? 2 : (type == 3 || type == 68 ? 3 : (type == 4 || type == 69 ? 4 : (type == 5 || type == 70 ? 5 : (type == 6 || type == 71 ? 6 : (type == 7 || type == 72 ? 7 : (type == 8 || type == 73 ? 8 : 8))))))));
        byte[] esc_barcode_1d_type = new byte[]{29, 107, (byte)type};
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_barcode_1d_type, 0, esc_barcode_1d_type.length)) {
            return false;
        }
        byte[] esc_barcode_1d_content_end = new byte[]{0};
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(content.getBytes(), 0, content.length())) {
            return false;
        }
        return this.mAPI.writeBuffer(esc_barcode_1d_content_end, 0, esc_barcode_1d_content_end.length);
    }

    public boolean esc_print_barcode_2d(int size, int qrVersion, int level, String content) {
        byte[] esc_barcode_2d_size = new byte[]{29, 119, 0};
        if (size == 1) {
            esc_barcode_2d_size[2] = 1;
        } else if (size == 2) {
            esc_barcode_2d_size[2] = 2;
        } else if (size == 3) {
            esc_barcode_2d_size[2] = 3;
        } else if (size == 4) {
            esc_barcode_2d_size[2] = 4;
        } else {
            size = 0;
        }
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (size > 0 && !this.mAPI.writeBuffer(esc_barcode_2d_size, 0, esc_barcode_2d_size.length)) {
            return false;
        }
        byte[] esc_print_barcode_2d_type = new byte[]{29, 107, 32, (byte)qrVersion, (byte)level};
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_print_barcode_2d_type, 0, esc_print_barcode_2d_type.length)) {
            return false;
        }
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(content.getBytes(), 0, content.length())) {
            return false;
        }
        byte[] esc_barcode_1d_content_end = new byte[]{0};
        return this.mAPI.writeBuffer(esc_barcode_1d_content_end, 0, esc_barcode_1d_content_end.length);
    }

    public boolean esc_print_barcode_2d(int size, String content) {
        byte[] esc_barcode_2d_size = new byte[]{29, 119, 0};
        esc_barcode_2d_size[2] = size == 1 ? 1 : (size == 2 ? 2 : (size == 3 ? 3 : 4));
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_barcode_2d_size, 0, esc_barcode_2d_size.length)) {
            return false;
        }
        byte[] esc_print_barcode_2d_type = new byte[]{29, 107, 32, 0, 2};
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(esc_print_barcode_2d_type, 0, esc_print_barcode_2d_type.length)) {
            return false;
        }
        if (!this.mAPI.isConnected()) {
            return false;
        }
        if (!this.mAPI.writeBuffer(content.getBytes(), 0, content.length())) {
            return false;
        }
        byte[] esc_barcode_1d_content_end = new byte[]{0};
        return this.mAPI.writeBuffer(esc_barcode_1d_content_end, 0, esc_barcode_1d_content_end.length);
    }

    public boolean esc_print_line_segments(int ... xPos) {
        if (xPos == null || xPos.length < 2) {
            return false;
        }
        ArrayList<Integer> points = new ArrayList<Integer>();
        for (int i = 0; i < (xPos.length + 1) / 2; ++i) {
            int endX = xPos[i + 1];
            int startX = xPos[i];
            if (endX < startX || startX > 243 || endX > 243) {
                JXLog.e(this.TAG, "The startX is greater than the endX or the x-coordinate has exceeded its maximum value 243, where the startX index is " + i);
                continue;
            }
            if (points.size() >= 16) {
                JXLog.e(this.TAG, "the max segment count is 8");
                break;
            }
            points.add(startX);
            points.add(endX);
        }
        if (!points.isEmpty()) {
            byte[] cmd = new byte[3 + points.size() * 2];
            cmd[0] = 29;
            cmd[1] = 39;
            cmd[2] = (byte)(points.size() / 2);
            for (int i = 0; i < points.size(); ++i) {
                cmd[3 + i] = (byte)((Integer)points.get(i) & 0xFF);
                cmd[4 + i] = (byte)((Integer)points.get(i) >> 16 & 0xFF);
            }
            return this.mAPI.isConnected() && this.mAPI.writeBuffer(cmd, 0, cmd.length);
        }
        return true;
    }
}

