/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.jxit.printer.jxsdk.JXExecutors;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;

public class JXLogManager {
    private static Context mContext;
    private static final String TAG = "JXLogManager";
    private static final String LOG_PREFIX = "jxlog";
    public static final String SUFFIX_LOG = ".log";
    public static final String SUFFIX_TXT = ".txt";
    private static final long MB = 0x100000L;
    private static final long MIN_FREE_ROM_SIZE = 0x1400000L;
    private static final SimpleDateFormat mTimeFormat;
    private static final HashSet<LogOwner> mOwnerList;
    private static volatile boolean isRegisteringLogOwner;

    private JXLogManager() {
    }

    static long getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        Log.d((String)TAG, (String)("path=" + path.getPath()));
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    static boolean isInitialized(LogOwner owner) {
        return owner != null && owner.parentDir != null && mOwnerList.contains(owner);
    }

    public static void registerLogOwner(Context context, LogOwner owner) {
        if (context == null || owner == null || !owner.checkParams()) {
            Log.e((String)TAG, (String)"LogOwner\u53c2\u6570\u9519\u8bef");
            return;
        }
        mContext = context.getApplicationContext();
        if (isRegisteringLogOwner) {
            Log.d((String)TAG, (String)"owner\u6b63\u5728\u521d\u59cb\u5316");
            return;
        }
        JXExecutors.logger().execute(() -> {
            if (isRegisteringLogOwner) {
                Log.d((String)TAG, (String)"owner\u6b63\u5728\u521d\u59cb\u5316");
                return;
            }
            isRegisteringLogOwner = true;
            String rootPath = JXLogManager.getAvailableLogDirPath(mContext);
            if (rootPath == null) {
                Log.e((String)TAG, (String)"\u5f53\u524d\u65e0\u6cd5\u8bfb\u5199\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5b58\u50a8\u5361\u7a7a\u95f4\u662f\u5426\u8db3\u591f\u4e14\u6388\u4e88app\u8bfb\u5199\u6743\u9650");
                isRegisteringLogOwner = false;
                return;
            }
            if (JXLogManager.initLogDir(rootPath, owner)) {
                HashSet<LogOwner> hashSet = mOwnerList;
                synchronized (hashSet) {
                    mOwnerList.add(owner);
                }
            }
            isRegisteringLogOwner = false;
        });
    }

    private static String getAvailableLogDirPath(Context context) {
        try {
            long localSpace = JXLogManager.getAvailableInternalMemorySize();
            String localFilePath = context.getFilesDir().getAbsolutePath();
            if (localSpace < 0x1400000L) {
                Log.e((String)TAG, (String)"\u624b\u673a\u5185\u5b58\u5269\u4f59\u5bb9\u91cf\u8fc7\u5c0f\uff0c\u505c\u6b62\u5199\u65e5\u5fd7\u3002");
                return null;
            }
            return localFilePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"\u8bf7\u68c0\u67e5\u8bfb\u5199\u6743\u9650\u662f\u5426\u83b7\u53d6\u5230");
            return null;
        }
    }

    static boolean initLogDir(String parentPath, LogOwner owner) {
        try {
            String path = parentPath + File.separator + owner.relativeDirPath;
            File dir = new File(path);
            long timeout = 100L;
            long tm = SystemClock.elapsedRealtime();
            while (!dir.exists()) {
                dir.mkdirs();
                Thread.sleep(20L);
                if (SystemClock.elapsedRealtime() - tm <= 100L) continue;
            }
            if (!dir.exists()) {
                Log.d((String)TAG, (String)("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff01" + dir.getAbsolutePath()));
                return false;
            }
            owner.setParentDir(dir);
            Log.d((String)TAG, (String)(owner.name + "\u65e5\u5fd7\u521d\u59cb\u5316\u5b8c\u6210"));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void write(LogOwner owner, String level, String message) {
        if (owner == null || TextUtils.isEmpty((CharSequence)message)) {
            Log.w((String)TAG, (String)"write log failed for bad params");
            return;
        }
        if (!JXLogManager.isInitialized(owner)) {
            Log.w((String)TAG, (String)"write log failed for not init ,try to init it");
            JXLogManager.registerLogOwner(mContext, owner);
            return;
        }
        JXExecutors.logger().execute(() -> {
            try {
                String time = mTimeFormat.format(System.currentTimeMillis());
                LogOwner logOwner = owner;
                synchronized (logOwner) {
                    boolean needWrite2Storage = owner.writeLog(level, "--", time, "--", message, "\n");
                    if (needWrite2Storage) {
                        String logs = owner.readLog();
                        Writer fw = owner.getFileWriter();
                        if (fw == null) {
                            Log.e((String)TAG, (String)"\u83b7\u53d6\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25,\u65e0\u6cd5\u5199\u5165\uff01");
                            return;
                        }
                        fw.write(logs);
                        fw.flush();
                        fw.close();
                    }
                }
            }
            catch (Exception var8) {
                var8.printStackTrace();
            }
        });
    }

    static {
        mTimeFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
        mOwnerList = new HashSet();
        isRegisteringLogOwner = false;
    }

    public static class LogOwner {
        public String name;
        public int maxLogFileCount = 24;
        public int fileCreateIntervalInHour = 24;
        public String relativeDirPath;
        private File parentDir;
        private File logFile;
        public long fileCreateTime = 0L;
        public String fileSuffix = ".log";
        private static final long HOUR_1 = 3600000L;
        private StringBuffer sb = new StringBuffer();
        private volatile int logCount = 0;
        private static final int MAX_BUFFER_LENGTH = 8192;
        private static final int MAX_BUFFER_LOG_COUNT = 5;

        public LogOwner(String name, String relativeDirPath, int days) {
            this.name = name;
            if (days < 1) {
                days = 1;
            }
            if (this.fileCreateIntervalInHour < 1) {
                this.fileCreateIntervalInHour = 1;
            }
            this.maxLogFileCount = days * 24 / this.fileCreateIntervalInHour;
            this.relativeDirPath = relativeDirPath;
        }

        public LogOwner(String name, String relativeDirPath, int fileCreateIntervalInHour, int maxLogFileCount) {
            this.name = name;
            if (fileCreateIntervalInHour < 1) {
                fileCreateIntervalInHour = 1;
            }
            this.fileCreateIntervalInHour = fileCreateIntervalInHour;
            this.maxLogFileCount = maxLogFileCount;
            this.relativeDirPath = relativeDirPath;
        }

        public void setSuffix(String suffix) {
            this.fileSuffix = suffix;
        }

        public boolean checkParams() {
            if (TextUtils.isEmpty((CharSequence)this.name) || TextUtils.isEmpty((CharSequence)this.relativeDirPath) || this.maxLogFileCount <= 0) {
                Log.e((String)JXLogManager.TAG, (String)"bad params for LogOwner");
                return false;
            }
            return true;
        }

        private void reset() {
            this.logFile = null;
            this.fileCreateTime = 0L;
        }

        private File getLogFile() {
            File parentDir = this.parentDir;
            if (parentDir == null) {
                return null;
            }
            if (this.logFile != null) {
                if (System.currentTimeMillis() - this.fileCreateTime < (long)this.fileCreateIntervalInHour * 3600000L) {
                    return this.logFile;
                }
                this.reset();
                return this.getLogFile();
            }
            File lastLogFile = this.findAvailableLogFile(parentDir);
            if (lastLogFile != null) {
                this.logFile = lastLogFile;
                this.fileCreateTime = lastLogFile.lastModified();
                return lastLogFile;
            }
            File newLogFile = this.createLogFile(parentDir);
            if (newLogFile != null) {
                this.logFile = newLogFile;
                this.fileCreateTime = System.currentTimeMillis();
                return newLogFile;
            }
            return null;
        }

        public Writer getFileWriter() {
            try {
                File logFile = this.getLogFile();
                if (logFile != null) {
                    return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile, true), "UTF-8"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)JXLogManager.TAG, (String)"\u83b7\u53d6\u65e5\u5fd7\u6587\u4ef6\u6d41\u5931\u8d25");
                this.reset();
            }
            return null;
        }

        private File findAvailableLogFile(File parentDir) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HH");
            File[] logs = parentDir.listFiles(pathname -> pathname.isFile() && pathname.getName().endsWith(this.fileSuffix));
            if (logs != null && logs.length > 0) {
                ArrayList<File> logList = new ArrayList<File>(Arrays.asList(logs));
                if (logs.length > 1) {
                    Collections.sort(logList, (f1, f2) -> f1.lastModified() > f2.lastModified() ? -1 : 1);
                }
                while (logList.size() > this.maxLogFileCount && logList.size() > 1) {
                    File deleteFile = (File)logList.get(logList.size() - 1);
                    deleteFile.delete();
                    logList.remove(logList.size() - 1);
                }
                File lastFile = (File)logList.get(0);
                String name = lastFile.getName().replace(this.fileSuffix, "");
                if (name.length() == "yyyyMMdd_HH".length()) {
                    try {
                        Date date = sdf.parse(name);
                        if (System.currentTimeMillis() - date.getTime() < (long)this.fileCreateIntervalInHour * 3600000L) {
                            lastFile.setLastModified(date.getTime());
                            return lastFile;
                        }
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        private File createLogFile(File parentDir) {
            try {
                if (this.checkStorageEnough(parentDir)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HH");
                    String fileName = sdf.format(System.currentTimeMillis()) + this.fileSuffix;
                    File newFile = new File(parentDir.getAbsolutePath(), fileName);
                    long timeout = 100L;
                    long tm = SystemClock.elapsedRealtime();
                    while (!newFile.exists()) {
                        newFile.createNewFile();
                        Thread.sleep(20L);
                        if (SystemClock.elapsedRealtime() - tm <= 100L) continue;
                    }
                    if (newFile.exists()) {
                        return newFile;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Log.e((String)JXLogManager.TAG, (String)"\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25");
            return null;
        }

        private boolean checkStorageEnough(File parentDir) {
            StatFs statfs = new StatFs(parentDir.getAbsolutePath());
            long nSDFreeSize = (long)statfs.getAvailableBlocks() * (long)statfs.getBlockSize();
            if (nSDFreeSize < 0x1400000L) {
                Log.e((String)JXLogManager.TAG, (String)"SD\u5361\u5269\u4f59\u5bb9\u91cf\u8fc7\u5c0f\uff0c\u505c\u6b62\u5199\u65e5\u5fd7\u3002");
                return false;
            }
            return true;
        }

        public void setParentDir(File parentDir) {
            this.parentDir = parentDir;
        }

        public boolean writeLog(String ... logs) {
            if (logs != null && logs.length > 0) {
                for (String str : logs) {
                    this.sb.append(str);
                }
                ++this.logCount;
                if (this.logCount > 5 || this.sb.length() > 8192) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String readLog() {
            String log;
            StringBuffer stringBuffer = this.sb;
            synchronized (stringBuffer) {
                log = this.sb.toString();
                this.sb.setLength(0);
                this.logCount = 0;
            }
            return log;
        }
    }
}

