/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.graphics.Bitmap;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.GuoJiang_CMD;
import com.jxit.printer.jxsdk.JXCommand;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXSupportInfo;
import com.jxit.printer.utils.BitmapTools;

public class LowMemory_CMD
extends JXCommand {
    private int maxPrintWidth = 0;

    public LowMemory_CMD(JXInterfaceAPI api) {
        super(api);
    }

    public boolean checkMaxPrintWidth(GuoJiang_CMD gj) {
        if (this.maxPrintWidth == 0) {
            JXSupportInfo supportInfo = gj.gj_info_support();
            if (supportInfo != null) {
                this.maxPrintWidth = supportInfo.maxWidth;
            }
            if (this.maxPrintWidth <= 0) {
                this.maxPrintWidth = 576;
            }
        }
        return true;
    }

    public boolean print_graphic(Bitmap bmp, boolean compress, boolean fluid, String printerModel) {
        int maxChunkSize = 2304;
        if (printerModel == null) {
            maxChunkSize = 2304;
        }
        int bmp_size_x = bmp.getWidth();
        int bmp_size_y = bmp.getHeight();
        if (this.maxPrintWidth == 0) {
            throw new IllegalAccessError("maxPrintWidth must initialized");
        }
        if (bmp_size_x > this.maxPrintWidth) {
            bmp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)this.maxPrintWidth, (int)bmp_size_y);
            bmp_size_x = this.maxPrintWidth;
        }
        int byteWidth = (bmp_size_x - 1) / 8 + 1;
        int byteHeight = bmp_size_y;
        if (byteWidth <= 0) {
            return false;
        }
        if (byteHeight <= 0) {
            return false;
        }
        int unitHeight = maxChunkSize / byteWidth;
        int unitCount = (byteHeight - 1) / unitHeight + 1;
        for (int n = 0; n < unitCount; ++n) {
            int startY = n * unitHeight;
            int endY = startY + unitHeight > bmp_size_y ? bmp_size_y : startY + unitHeight;
            int byteLen = (endY - startY) * byteWidth;
            byte[] dataByte = new byte[byteLen];
            for (int y = startY; y < endY; ++y) {
                for (int x = 0; x < bmp_size_x; ++x) {
                    int color = bmp.getPixel(x, y);
                    int A = color >> 24 & 0xFF;
                    int R = color >> 16 & 0xFF;
                    int G = color >> 8 & 0xFF;
                    int B = color & 0xFF;
                    if (A <= 0 || !((double)R * 0.3 + (double)G * 0.59 + (double)B * 0.11 < 180.0)) continue;
                    int n2 = (y - startY) * byteWidth + x / 8;
                    dataByte[n2] = (byte)(dataByte[n2] | 128 >> x % 8);
                }
            }
            int curUnitHeight = n == unitCount - 1 ? byteHeight - n * unitHeight : unitHeight;
            boolean useCompress = compress;
            if (compress) {
                byte[] before = dataByte;
                dataByte = BitmapTools.rleCompress(dataByte);
                JXLog.d(this.TAG, "will compress");
                if ((double)before.length * 0.95 < (double)dataByte.length) {
                    JXLog.d(this.TAG, "compression ratio > 95%,no compress");
                    dataByte = before;
                    useCompress = false;
                }
            }
            this.writeGraphicData(useCompress, byteWidth, curUnitHeight, fluid, dataByte);
        }
        return true;
    }

    private boolean writeGraphicData(boolean compressed, int width, int height, boolean fluid, byte[] data) {
        byte[] cmdHeader = new byte[]{16, 34, 0, (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(data.length & 0xFF), (byte)(data.length >> 8 & 0xFF)};
        if (fluid) {
            byte[] rep = new byte[1];
            cmdHeader[2] = compressed ? 3 : 2;
            boolean success = this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmdHeader, 0, cmdHeader.length) && this.mAPI.writeBuffer(data, 0, data.length) && this.mAPI.readBuffer(rep, 0, rep.length, 30000);
            return success && rep[0] == 34;
        }
        cmdHeader[2] = compressed ? (byte)1 : 0;
        return this.mAPI.flushReadBuffer() && this.mAPI.writeBuffer(cmdHeader, 0, cmdHeader.length) && this.mAPI.writeBuffer(data, 0, data.length);
    }
}

