/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.model;

import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXParser;
import com.jxit.printer.utils.SDKUtil;
import java.util.Random;

public class JXBTTransfer
implements JXParser {
    private static final String TAG = "JXBTTransfer";
    private int dataLength;
    private boolean isRandom;
    private int cmdID = 0;
    private byte[] cmd;
    private byte[] data;

    public JXBTTransfer(int cmdID, int dataLength, boolean isRandom) {
        this.dataLength = dataLength - 8;
        if (this.dataLength < 0) {
            this.dataLength = 0;
        }
        this.isRandom = isRandom;
        this.cmdID = cmdID;
        this.cmd = new byte[this.dataLength + 7 + 1];
        this.data = new byte[this.dataLength];
    }

    @Override
    public boolean parse(byte[] data) {
        if (data.length == 5 && data[0] == 16 && data[1] == 6 && data[2] == this.cmdID) {
            int crc = (data[4] << 8 | data[3]) & 0xFFFF;
            int expectCrc = SDKUtil.crc(this.data) & 0xFFFF;
            if (crc == expectCrc) {
                return true;
            }
            JXLog.e(TAG, "crc = " + crc + " \u548c\u9884\u671fcrc = " + expectCrc + "\u4e0d\u76f8\u7b26");
            return false;
        }
        JXLog.e(TAG, "parse data\u4e0d\u7b26\u5408\u6307\u4ee4\u89c4\u5219");
        return false;
    }

    @Override
    public byte[] createCommand() {
        this.cmd[0] = 16;
        this.cmd[1] = 6;
        this.cmd[2] = (byte)(this.cmdID & 0xFF);
        this.cmd[3] = (byte)(this.dataLength & 0xFF);
        this.cmd[4] = (byte)(this.dataLength >> 8 & 0xFF);
        this.cmd[5] = (byte)(this.dataLength >> 16 & 0xFF);
        this.cmd[6] = (byte)(this.dataLength >> 24 & 0xFF);
        this.cmd[this.cmd.length - 1] = 0;
        if (this.isRandom) {
            Random r = new Random(System.currentTimeMillis());
            for (int i = 0; i < this.dataLength; ++i) {
                int n = r.nextInt(255);
                this.data[i] = (byte)n;
            }
        } else {
            for (int i = 0; i < this.dataLength; ++i) {
                this.data[i] = (byte)(i & 0xFF);
            }
        }
        System.arraycopy(this.data, 0, this.cmd, 7, this.dataLength);
        return this.cmd;
    }
}

