/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.model;

import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxapi.JXUsbAPI;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXParser;
import com.jxit.printer.utils.SDKUtil;
import java.util.Random;

public class JXCommunication
implements JXParser {
    private byte[] randomNum;
    private boolean isRandom = true;
    private String errorMessage;
    private long serialNum = 0L;

    @Override
    public boolean parse(byte[] data) {
        this.errorMessage = null;
        if (data == null || data.length < 4) {
            this.errorMessage = "data length to parse is too short";
            JXLog.e("JXCommunicationStability", "bad param");
            return false;
        }
        try {
            byte id = data[2];
            if (id == 0) {
                for (int i = 0; i < this.randomNum.length; ++i) {
                    if (this.randomNum[i] == data[4 + i]) continue;
                    this.errorMessage = "index=" + i + ",expect " + (this.randomNum[i] & 0xFF) + ",but get " + (data[i + 4] & 0xFF) + "\ndata=" + JXLog.byteArrayToHexStr(data);
                    JXLog.e("JXCommunicationStability", this.errorMessage);
                    return false;
                }
                return true;
            }
            if (id == 1) {
                if (data[0] == 16 && data[4] != 0) {
                    this.errorMessage = "expect 1005010100,but get data=" + JXLog.byteArrayToHexStr(data);
                    JXLog.e("JXCommunicationStability", this.errorMessage);
                    return false;
                }
                return true;
            }
            if (id == 2) {
                int expectCrc;
                int crc = this.bytes2Int(data, 4, true);
                if (crc != (expectCrc = SDKUtil.crc(this.randomNum))) {
                    this.errorMessage = "expect crc =" + expectCrc + ",but get crc=" + crc + "\ndata=" + JXLog.byteArrayToHexStr(data);
                    JXLog.e("JXCommunicationStability", this.errorMessage);
                    return false;
                }
                return true;
            }
            if (id == 3) {
                if (data[0] == 16 && data[4] != 0) {
                    this.errorMessage = "serialNum=" + this.serialNum + ", expect 1005030500,but get " + JXLog.byteArrayToHexStr(data);
                    JXLog.e("JXCommunicationStability", this.errorMessage);
                    return false;
                }
                long receivedSN = this.bytes2Long(data, 5);
                JXLog.d("JXCommunicationStability", "parse: SN=" + this.serialNum + ",receivedSN=" + receivedSN);
                if (this.serialNum != receivedSN) {
                    this.errorMessage = "serialNum=" + this.serialNum + ",but get " + receivedSN + ",data=" + JXLog.byteArrayToHexStr(data);
                    JXLog.e("JXCommunicationStability", this.errorMessage);
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMessage = "parse exception" + e.getMessage();
            JXLog.e("JXCommunicationStability", this.errorMessage);
            return false;
        }
    }

    private long bytes2Long(byte[] bs, int offset) {
        return this.byte2Int(bs[offset++]) | this.byte2Int(bs[offset++]) << 8 | this.byte2Int(bs[offset++]) << 16 | this.byte2Int(bs[offset++]) << 24;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setSerialNum(long serial) {
        this.serialNum = serial;
    }

    public long getSerialNum() {
        return this.serialNum;
    }

    public void setDataSourceType(boolean isRandom) {
        this.isRandom = isRandom;
    }

    public byte[] createCommand(int id, int length, JXInterfaceAPI api) {
        byte[] cmd;
        boolean needCrc;
        int maxLen;
        if (id == 0 && api != null && api instanceof JXUsbAPI && (length = 60) > (maxLen = 60)) {
            length = maxLen;
            JXLog.w("JXCommunicationStability", "read length can't bigger than 64, set length to" + maxLen + "for safety");
        }
        this.randomNum = new byte[length];
        int start = 0;
        if (id == 3) {
            start = 4;
            this.randomNum[0] = (byte)(this.serialNum & 0xFFL);
            this.randomNum[1] = (byte)(this.serialNum >> 8 & 0xFFL);
            this.randomNum[2] = (byte)(this.serialNum >> 16 & 0xFFL);
            this.randomNum[3] = (byte)(this.serialNum >> 24 & 0xFFL);
        }
        if (this.isRandom) {
            Random r = new Random();
            for (int i = start; i < this.randomNum.length; ++i) {
                int n = r.nextInt(255);
                this.randomNum[i] = (byte)n;
            }
        } else {
            for (int i = start; i < this.randomNum.length; ++i) {
                this.randomNum[i] = (byte)i;
            }
        }
        boolean bl = needCrc = id == 1 || id == 3;
        if (needCrc) {
            cmd = new byte[this.randomNum.length + 6 + 1];
            int crc = SDKUtil.crc(this.randomNum);
            cmd[cmd.length - 3] = (byte)(crc & 0xFF);
            cmd[cmd.length - 2] = (byte)(crc >> 8 & 0xFF);
            cmd[cmd.length - 1] = 0;
        } else if (id == 0 || id == 2) {
            cmd = new byte[this.randomNum.length + 4 + 1];
        } else {
            JXLog.e("JXCommunicationStability", "id = " + id + " is not support");
            return null;
        }
        System.arraycopy(this.randomNum, 0, cmd, 4, this.randomNum.length);
        cmd[0] = 16;
        cmd[1] = 5;
        cmd[2] = (byte)id;
        cmd[3] = (byte)(this.randomNum.length + (needCrc ? 2 : 0));
        cmd[cmd.length - 1] = 0;
        return cmd;
    }
}

