/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.CodaBarWriter;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.Code39Writer;
import com.google.zxing.oned.Code93Writer;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.EAN8Writer;
import com.google.zxing.oned.ITFWriter;
import com.google.zxing.oned.UPCEWriter;
import com.jxit.printer.jxsdk.JXLog;
import java.util.Hashtable;

public class GlobalUtil {
    private static final String TAG = GlobalUtil.class.getSimpleName();

    private static BarcodeFormat getZxingBarcodeFormat(com.jxit.printer.jxsdk.BarcodeFormat format) {
        return BarcodeFormat.valueOf((String)format.name());
    }

    public static Bitmap barcode1D(int width, int height, String content, int rotate, com.jxit.printer.jxsdk.BarcodeFormat format, Barcode1DTextWriter writer) {
        Bitmap bitmap;
        if (TextUtils.isEmpty((CharSequence)content)) {
            JXLog.e(TAG, "content can't be null or empty");
            return null;
        }
        Bitmap barcodeBitmap = GlobalUtil.barcode1D(width, height, content, format);
        if (writer != null) {
            Bitmap textBitmap = writer.drawTextBitmap(content, width);
            bitmap = Bitmap.createBitmap((int)Math.max(textBitmap.getWidth(), barcodeBitmap.getWidth()), (int)(barcodeBitmap.getHeight() + textBitmap.getHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawColor(-1);
            Paint paint = new Paint();
            if (writer.isPositionBelow()) {
                canvas.drawBitmap(barcodeBitmap, (float)((bitmap.getWidth() - barcodeBitmap.getWidth()) / 2), 0.0f, paint);
                canvas.drawBitmap(textBitmap, (float)((bitmap.getWidth() - textBitmap.getWidth()) / 2), (float)barcodeBitmap.getHeight(), paint);
            } else {
                canvas.drawBitmap(textBitmap, (float)((bitmap.getWidth() - textBitmap.getWidth()) / 2), 0.0f, paint);
                canvas.drawBitmap(barcodeBitmap, (float)((bitmap.getWidth() - barcodeBitmap.getWidth()) / 2), (float)textBitmap.getHeight(), paint);
            }
        } else {
            bitmap = barcodeBitmap;
        }
        if (rotate != 0) {
            bitmap = GlobalUtil.rotateBitmap(bitmap, rotate);
        }
        return bitmap;
    }

    public static Bitmap barcode1D(int width, int height, String content, com.jxit.printer.jxsdk.BarcodeFormat format) {
        if (content == null || "".equals(content) || content.length() < 1) {
            return null;
        }
        MultiFormatWriter writer = new MultiFormatWriter();
        BitMatrix result = null;
        int barWidth = width;
        if (format == com.jxit.printer.jxsdk.BarcodeFormat.CODE_128) {
            barWidth = GlobalUtil.getBarCodeNoPaddingWidth(format, width, content, width);
        }
        int barHeight = height;
        try {
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.MARGIN, 0);
            result = writer.encode(content, GlobalUtil.getZxingBarcodeFormat(format), barWidth, barHeight, hints);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        if (result == null) {
            JXLog.e(TAG, "Check that the length and format of the content meets the bar code rules of " + format.name());
            return null;
        }
        int bWidth = result.getWidth();
        int bHeight = result.getHeight();
        int[] pixels = new int[bWidth * bHeight];
        for (int y = 0; y < bHeight; ++y) {
            int offset = y * bWidth;
            for (int x = 0; x < bWidth; ++x) {
                pixels[offset + x] = result.get(x, y) ? -16777216 : 0;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)bWidth, (int)bHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, bWidth, 0, 0, bWidth, bHeight);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        return bitmap;
    }

    private static int getBarCodeNoPaddingWidth(com.jxit.printer.jxsdk.BarcodeFormat format, int expectWidth, String contents, int maxWidth) {
        UPCEWriter writer;
        switch (format) {
            case UPC_E: {
                writer = new UPCEWriter();
                break;
            }
            case EAN_8: {
                writer = new EAN8Writer();
                break;
            }
            case EAN_13: {
                writer = new EAN13Writer();
                break;
            }
            case CODE_39: {
                writer = new Code39Writer();
                break;
            }
            case CODE_93: {
                writer = new Code93Writer();
                break;
            }
            case ITF: {
                writer = new ITFWriter();
                break;
            }
            case CODABAR: {
                writer = new CodaBarWriter();
                break;
            }
            default: {
                writer = new Code128Writer();
            }
        }
        boolean[] code = writer.encode(contents);
        int inputWidth = code.length;
        double outputWidth = Math.max(expectWidth, inputWidth);
        double multiple = outputWidth / (double)inputWidth;
        int returnVal = 0;
        int ceil = (int)Math.ceil(multiple);
        if (inputWidth * ceil <= maxWidth) {
            returnVal = inputWidth * ceil;
        } else {
            int floor = (int)Math.floor(multiple);
            returnVal = inputWidth * floor;
        }
        return returnVal;
    }

    public static Bitmap barcode2D(int width, int height, String content, com.jxit.printer.jxsdk.BarcodeFormat format) {
        if (content == null || "".equals(content) || content.length() < 1) {
            return null;
        }
        MultiFormatWriter writer = new MultiFormatWriter();
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 0);
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = writer.encode(content, GlobalUtil.getZxingBarcodeFormat(format), width, height, hints);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (bitMatrix == null) {
            JXLog.e(TAG, "Check that the length and format of the content meets the bar code rules of " + format.name());
            return null;
        }
        int w = bitMatrix.getWidth();
        int h = bitMatrix.getHeight();
        int[] pixels = new int[w * h];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                pixels[y * w + x] = bitMatrix.get(x, y) ? -16777216 : 0;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        return bitmap;
    }

    private static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public static String autoSplitText(Paint paint, String rawText, int tvWidth) {
        if ((float)tvWidth < paint.measureText("M")) {
            return String.valueOf(rawText.charAt(0));
        }
        String[] rawTextLines = rawText.replaceAll("\r", "").split("\n");
        StringBuilder sbNewText = new StringBuilder();
        for (String rawTextLine : rawTextLines) {
            if (paint.measureText(rawTextLine) <= (float)tvWidth) {
                sbNewText.append(rawTextLine);
            } else {
                float lineWidth = 0.0f;
                for (int cnt = 0; cnt != rawTextLine.length(); ++cnt) {
                    char ch = rawTextLine.charAt(cnt);
                    if ((lineWidth += paint.measureText(String.valueOf(ch))) <= (float)tvWidth) {
                        sbNewText.append(ch);
                        continue;
                    }
                    sbNewText.append("\n");
                    lineWidth = 0.0f;
                    --cnt;
                }
            }
            sbNewText.append("\n");
        }
        return sbNewText.toString();
    }

    public static Bitmap rotateBitmap(Bitmap bmp, int rotate) {
        if (rotate != 90 && rotate != 180 && rotate != 270) {
            rotate = 0;
        }
        if (rotate != 0) {
            Matrix m = new Matrix();
            m.setRotate((float)rotate);
            return Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)m, (boolean)true);
        }
        return bmp;
    }

    public static class GlobalTextWriter {
        public static boolean isUnderline;
        public static boolean isBold;
        public static boolean isItaly;
        public static boolean isReverse;
        public static int fontSize;
        public static int lineSpace;
        public static int letterSpace;
        public static int fontWidthScale;
        public static int fontHeightScale;
        public static Typeface typeface;
        private Paint mTextPaint = new Paint();
        private Paint mBgPaint = new Paint();

        public static void reset() {
            isUnderline = false;
            isBold = false;
            isItaly = false;
            isReverse = false;
            fontSize = 24;
            lineSpace = 0;
            letterSpace = 0;
            fontWidthScale = 1;
            fontHeightScale = 1;
            typeface = null;
        }

        protected Paint getBgPaint() {
            this.mBgPaint.reset();
            if (isReverse) {
                this.mBgPaint = new Paint(1);
                this.mBgPaint.setStyle(Paint.Style.FILL);
                this.mBgPaint.setColor(-16777216);
            }
            return this.mBgPaint;
        }

        protected Paint getTextPaint() {
            this.mTextPaint.reset();
            this.mTextPaint.setFlags(1);
            float realXScale = 1.0f * (float)fontWidthScale / (float)fontHeightScale;
            int realTextSize = fontSize * fontHeightScale;
            this.mTextPaint.setTextSize((float)realTextSize);
            this.mTextPaint.setTextScaleX(realXScale);
            this.mTextPaint.setFakeBoldText(isBold);
            this.mTextPaint.setTypeface(typeface);
            this.mTextPaint.setStrokeWidth(1.0f);
            if (isReverse) {
                this.mTextPaint.setColor(-1);
            } else {
                this.mTextPaint.setColor(-16777216);
            }
            if (isItaly) {
                this.mTextPaint.setTextSkewX(-0.25f);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (letterSpace == 0) {
                    this.mTextPaint.setLetterSpacing(0.0f);
                } else {
                    float EM = this.mTextPaint.measureText("M");
                    float em_spacing = 1.0f * (float)letterSpace / EM;
                    this.mTextPaint.setLetterSpacing(em_spacing);
                }
            }
            return this.mTextPaint;
        }

        static {
            fontWidthScale = 1;
            fontHeightScale = 1;
        }
    }

    public static class Barcode1DTextWriter {
        private boolean isPositionBelow = true;
        private int fontSize = 24;
        private boolean isBold;
        private int margin = 8;
        private boolean breakLine = false;

        public boolean isPositionBelow() {
            return this.isPositionBelow;
        }

        public Barcode1DTextWriter(boolean isPositionBelow, int fontSize, boolean isBold, int margin, boolean breakLine) {
            this.isPositionBelow = isPositionBelow;
            if (fontSize <= 0) {
                fontSize = 24;
            }
            this.fontSize = fontSize;
            this.isBold = isBold;
            if (margin < 0) {
                margin = 0;
            }
            this.margin = margin;
            this.breakLine = breakLine;
        }

        public Bitmap drawTextBitmap(String text, int barcodeWidth) {
            Paint textPaint = new Paint(1);
            textPaint.setTextSize((float)this.fontSize);
            textPaint.setFakeBoldText(this.isBold);
            textPaint.setStrokeWidth(1.0f);
            textPaint.setColor(-16777216);
            Paint.FontMetrics fm = textPaint.getFontMetrics();
            int lineHeight = (int)((double)(fm.bottom - fm.top) + 0.5);
            text = text.replaceAll("\r", "").replaceAll("\n", "");
            float lineWidth = textPaint.measureText(text);
            if (lineWidth > (float)barcodeWidth && this.breakLine) {
                float breakLength = lineWidth - (float)barcodeWidth;
                for (int cnt = text.length() - 1; cnt >= 0; --cnt) {
                    if (!(textPaint.measureText(text.substring(cnt)) >= breakLength)) continue;
                    text = text.substring(0, cnt);
                    break;
                }
                lineWidth = textPaint.measureText(text);
            }
            Bitmap bitmap = Bitmap.createBitmap((int)((int)(lineWidth + 0.5f)), (int)(lineHeight + this.margin), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            float startX = ((float)bitmap.getWidth() - lineWidth) / 2.0f;
            if (startX < 0.0f) {
                startX = 0.0f;
            }
            float startY = this.isPositionBelow ? (float)this.margin - fm.top : -fm.top;
            canvas.drawText(text, startX, startY, textPaint);
            return bitmap;
        }
    }
}

