/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.text.TextUtils;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.BarcodeFormat;
import com.jxit.printer.jxsdk.JXCommand;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.utils.GlobalUtil;
import java.util.ArrayList;
import java.util.List;

public class Global_Line_CMD
extends JXCommand {
    private LineTextWriter mWriter;
    private GlobalUtil.Barcode1DTextWriter mBarcode1DWriter;
    private int maxPrintWidth = 384;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private LinePrinter mLinePrinter = new LinePrinter();

    public Global_Line_CMD(JXInterfaceAPI api) {
        super(api);
        this.mWriter = new LineTextWriter();
    }

    public boolean reset() {
        Global_Line_CMD global_Line_CMD = this;
        global_Line_CMD.mWriter.reset();
        this.mLinePrinter.reset();
        this.leftMargin = 0;
        this.rightMargin = 0;
        this.mBarcode1DWriter = null;
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(new byte[]{27, 64}, 0, 2);
    }

    public boolean setLeftMargin(int margin) {
        if (this.maxPrintWidth - margin - this.rightMargin < 100) {
            JXLog.e(this.TAG, "real print width is less than 100 px");
            return false;
        }
        this.leftMargin = margin;
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(new byte[]{29, 76, (byte)(margin & 0xFF), (byte)(margin >> 8 & 0xFF)}, 0, 4);
    }

    public boolean setRightMargin(int margin) {
        if (this.maxPrintWidth - this.leftMargin - margin < 100) {
            JXLog.e(this.TAG, "real print width is less than 100 px");
            return false;
        }
        this.rightMargin = margin;
        return true;
    }

    public boolean setAlign(int align) {
        byte[] esc_align = new byte[]{27, 97, 0};
        esc_align[2] = align == 1 ? 1 : (align == 2 ? 2 : 0);
        return this.mAPI.isConnected() && this.mAPI.writeBuffer(esc_align, 0, esc_align.length);
    }

    public void setMaxPrintWidth(int maxWidth) {
        if (maxWidth == 576) {
            maxWidth = 575;
        }
        this.maxPrintWidth = maxWidth;
    }

    public boolean print() {
        return this.mLinePrinter.print();
    }

    public boolean feed(int n) {
        return this.mLinePrinter.feed(n);
    }

    public boolean drawText(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        return this.mWriter.drawText(content);
    }

    public boolean drawGraphic(Bitmap bitmap) {
        if (bitmap == null) {
            return false;
        }
        return this.mLinePrinter.drawBitmap(bitmap);
    }

    public boolean drawLine(float lineLength, int lineWidth, boolean isSolid) {
        if (lineWidth < 0) {
            JXLog.e(this.TAG, "line length and width must be greater than 0");
            return false;
        }
        lineLength = Math.min(this.mLinePrinter.getLineWidthLeft(), lineLength);
        float offset = (float)lineWidth / 2.0f;
        int bmpHeight = lineWidth;
        int bmpWidth = (int)lineLength;
        Bitmap bitmap = Bitmap.createBitmap((int)bmpWidth, (int)bmpHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        Paint paint = new Paint();
        paint.setColor(-16777216);
        if (isSolid) {
            paint.setPathEffect(null);
        } else {
            DashPathEffect pathEffect = new DashPathEffect(new float[]{5.0f, 5.0f, 5.0f, 5.0f}, 1.0f);
            paint.setPathEffect((PathEffect)pathEffect);
        }
        paint.setStrokeWidth((float)lineWidth);
        canvas.drawLine(0.0f, offset, lineLength, offset, paint);
        return this.mLinePrinter.drawBitmap(bitmap);
    }

    public void setBarcode1DText(boolean isPositionBelow, int fontSize, boolean isBold, int margin, boolean breakLine) {
        this.mBarcode1DWriter = new GlobalUtil.Barcode1DTextWriter(isPositionBelow, fontSize, isBold, margin, breakLine);
    }

    public boolean drawBarcode1D(int width, int height, String content, int rotate, BarcodeFormat format) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            JXLog.e(this.TAG, "content can't be null or empty");
            return false;
        }
        Bitmap bitmap = GlobalUtil.barcode1D(width, height, content, rotate, format, this.mBarcode1DWriter);
        this.mBarcode1DWriter = null;
        return this.mLinePrinter.drawBitmap(bitmap);
    }

    public boolean drawBarcode2D(int width, int height, String content, int rotate, BarcodeFormat format) {
        Bitmap bitmap = GlobalUtil.barcode2D(width, height, content, format);
        if (rotate != 0) {
            bitmap = GlobalUtil.rotateBitmap(bitmap, rotate);
        }
        return this.mLinePrinter.drawBitmap(bitmap);
    }

    public boolean drawLineSegments(int ... xPos) {
        if (xPos == null || xPos.length < 2) {
            return false;
        }
        ArrayList<Integer> points = new ArrayList<Integer>();
        for (int i = 0; i < xPos.length / 2; ++i) {
            int endX = xPos[2 * i + 1];
            int startX = xPos[2 * i];
            if (endX < startX || startX > 243 || endX > 243) {
                JXLog.e(this.TAG, "The startX is greater than the endX or the x-coordinate has exceeded its maximum value 243, where the startX index is " + i);
                continue;
            }
            if (points.size() >= 16) {
                JXLog.e(this.TAG, "the max segment count is 8");
                break;
            }
            points.add(startX);
            points.add(endX);
        }
        if (!points.isEmpty()) {
            byte[] cmd = new byte[3 + points.size() * 2];
            cmd[0] = 29;
            cmd[1] = 39;
            cmd[2] = (byte)(points.size() / 2);
            for (int i = 0; i < points.size(); ++i) {
                cmd[3 + i * 2] = (byte)((Integer)points.get(i) & 0xFF);
                cmd[4 + i * 2] = (byte)((Integer)points.get(i) >> 8 & 0xFF);
            }
            return this.mAPI.isConnected() && this.mAPI.writeBuffer(cmd, 0, cmd.length);
        }
        return true;
    }

    private int getRealMaxPrintWidth() {
        int w = this.maxPrintWidth - this.leftMargin - this.rightMargin;
        if (w < 0) {
            w = 0;
        }
        return w;
    }

    private class LineTextWriter
    extends GlobalUtil.GlobalTextWriter {
        private LineTextWriter() {
        }

        private Bitmap createTextBitmap(int width, int height, String text, Paint textPaint, Paint bgPaint, Paint.FontMetrics fm, float leftMargin) {
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawColor(-1);
            if (!TextUtils.isEmpty((CharSequence)text)) {
                float startY = -fm.top;
                if (isReverse) {
                    canvas.drawRect(leftMargin, startY + fm.top, (float)width, startY + fm.bottom, bgPaint);
                }
                canvas.drawText(text, leftMargin, startY, textPaint);
                if (isUnderline) {
                    canvas.drawLine(leftMargin, startY + 3.0f, (float)width, startY + 3.0f, textPaint);
                }
            }
            return bitmap;
        }

        public boolean drawText(String text) {
            if (TextUtils.isEmpty((CharSequence)text)) {
                return false;
            }
            Paint textPaint = this.getTextPaint();
            Paint bgPaint = this.getBgPaint();
            float textLeftMargin = (float)(-letterSpace) / 2.0f;
            Paint.FontMetrics fm = textPaint.getFontMetrics();
            int lineHeight = (int)((double)(fm.bottom - fm.top + (float)lineSpace) + 0.5);
            text = text + "@end";
            String[] rawTextLines = text.replaceAll("\r", "").split("\n");
            StringBuilder sbNewText = new StringBuilder();
            boolean isLastLine = false;
            for (int i = 0; i < rawTextLines.length; ++i) {
                float f;
                float lineWidthLeft = Global_Line_CMD.this.mLinePrinter.getLineWidthLeft();
                String rawLineText = rawTextLines[i];
                if (TextUtils.isEmpty((CharSequence)rawLineText) || rawLineText.equals("@end")) {
                    Global_Line_CMD.this.mLinePrinter.print();
                    continue;
                }
                if (i == rawTextLines.length - 1) {
                    isLastLine = true;
                    rawLineText = rawLineText.substring(0, rawLineText.length() - 4);
                }
                float lineAreaWidth = textPaint.measureText(rawLineText);
                if (f <= lineWidthLeft) {
                    if (!Global_Line_CMD.this.mLinePrinter.drawBitmap(this.createTextBitmap((int)(lineAreaWidth + 0.5f), lineHeight, rawLineText, textPaint, bgPaint, fm, textLeftMargin))) {
                        return false;
                    }
                    if (isLastLine) continue;
                    Global_Line_CMD.this.mLinePrinter.print();
                    continue;
                }
                sbNewText.setLength(0);
                lineAreaWidth = 0.0f;
                for (int cnt = 0; cnt < rawLineText.length(); ++cnt) {
                    float charLength = textPaint.measureText(String.valueOf(text.charAt(cnt)));
                    if (charLength > (float)Global_Line_CMD.this.maxPrintWidth) {
                        JXLog.e(Global_Line_CMD.this.TAG, "length of char " + text.charAt(cnt) + " is too large with length " + charLength);
                        continue;
                    }
                    if ((lineAreaWidth += charLength) <= lineWidthLeft) {
                        sbNewText.append(rawLineText.charAt(cnt));
                        continue;
                    }
                    if (!Global_Line_CMD.this.mLinePrinter.drawBitmap(this.createTextBitmap((int)(lineWidthLeft + 0.5f), lineHeight, sbNewText.toString(), textPaint, bgPaint, fm, textLeftMargin))) {
                        return false;
                    }
                    sbNewText.setLength(0);
                    lineAreaWidth = 0.0f;
                    lineWidthLeft = Global_Line_CMD.this.mLinePrinter.getLineWidthLeft();
                    --cnt;
                }
                if (sbNewText.length() > 0 && !Global_Line_CMD.this.mLinePrinter.drawBitmap(this.createTextBitmap((int)(lineAreaWidth + 0.5f), lineHeight, sbNewText.toString(), textPaint, bgPaint, fm, textLeftMargin))) {
                    return false;
                }
                if (isLastLine) continue;
                Global_Line_CMD.this.mLinePrinter.print();
            }
            return true;
        }
    }

    private class LinePrinter {
        private List<Bitmap> bitmaps = new ArrayList<Bitmap>();
        private int startX = 0;
        private int lineHeight = 0;
        private static final int MIN_BMP_WIDTH = 1;

        private LinePrinter() {
        }

        public float getLineWidthLeft() {
            return Global_Line_CMD.this.getRealMaxPrintWidth() - this.startX;
        }

        public void reset() {
            this.startX = 0;
            this.lineHeight = 0;
            this.bitmaps.clear();
        }

        boolean drawBitmap(Bitmap bitmap) {
            if (bitmap.getWidth() > Global_Line_CMD.this.getRealMaxPrintWidth()) {
                JXLog.e(Global_Line_CMD.this.TAG, "bitmap width " + bitmap.getWidth() + " is larger than the max width to print " + Global_Line_CMD.this.maxPrintWidth);
                return false;
            }
            if (this.getLineWidthLeft() < (float)bitmap.getWidth()) {
                JXLog.d(Global_Line_CMD.this.TAG, "auto print line data");
                this.print();
                return this.drawBitmap(bitmap);
            }
            this.bitmaps.add(bitmap);
            this.startX += bitmap.getWidth();
            this.lineHeight = Math.max(this.lineHeight, bitmap.getHeight());
            if (this.getLineWidthLeft() == 0.0f) {
                this.print();
            }
            return true;
        }

        private boolean feed(int n) {
            if (n > 0) {
                Bitmap bitmap = Bitmap.createBitmap((int)1, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                canvas.drawColor(-1);
                return this.print() && Global_Line_CMD.this.drawGraphic(bitmap) && this.print();
            }
            return false;
        }

        boolean print() {
            if (!this.bitmaps.isEmpty()) {
                Bitmap lineBitmap;
                boolean minWidth = true;
                if (this.bitmaps.size() == 1 && this.bitmaps.get(0).getWidth() >= 1) {
                    lineBitmap = this.bitmaps.get(0);
                } else {
                    int totalW = Math.min(this.startX, Global_Line_CMD.this.getRealMaxPrintWidth());
                    if (totalW < 1) {
                        totalW = 1;
                    }
                    lineBitmap = Bitmap.createBitmap((int)totalW, (int)this.lineHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas canvas = new Canvas(lineBitmap);
                    canvas.drawColor(0);
                    Paint paint = new Paint();
                    int x = 0;
                    for (Bitmap bmp : this.bitmaps) {
                        canvas.drawBitmap(bmp, (float)x, (float)(this.lineHeight - bmp.getHeight()), paint);
                        x += bmp.getWidth();
                        if (bmp.isRecycled()) continue;
                        bmp.recycle();
                    }
                }
                if (!this.escDrawBitmap(lineBitmap)) {
                    return false;
                }
                if (!lineBitmap.isRecycled()) {
                    lineBitmap.recycle();
                }
            }
            this.bitmaps.clear();
            this.startX = 0;
            this.lineHeight = 0;
            return true;
        }

        private boolean escDrawBitmap(Bitmap bitmap) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            int heightBytes = (height - 1) / 8 + 1;
            int bufSize = width * heightBytes;
            byte[] mapArray = new byte[bufSize];
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int pixel = pixels[width * j + i];
                    int A = pixel >> 24 & 0xFF;
                    int R = pixel >> 16 & 0xFF;
                    int G = pixel >> 8 & 0xFF;
                    int B = pixel & 0xFF;
                    if (A <= 0 || !((double)R * 0.3 + (double)G * 0.59 + (double)B * 0.11 < 180.0)) continue;
                    int n = i + j / 8 * width;
                    mapArray[n] = (byte)(mapArray[n] | (byte)(128 >> j % 8));
                }
            }
            byte[] pictureTop = new byte[]{27, 51, 0};
            if (!Global_Line_CMD.this.mAPI.writeBuffer(pictureTop, 0, pictureTop.length)) {
                return false;
            }
            byte[] Cmd = new byte[5];
            for (int i = 0; i < heightBytes; ++i) {
                Cmd[0] = 27;
                Cmd[1] = 42;
                Cmd[2] = 1;
                Cmd[3] = (byte)(width % 256);
                Cmd[4] = (byte)(width / 256);
                if (!Global_Line_CMD.this.mAPI.writeBuffer(Cmd, 0, 5)) {
                    return false;
                }
                if (!Global_Line_CMD.this.mAPI.writeBuffer(mapArray, i * width, width)) {
                    return false;
                }
                if (Global_Line_CMD.this.mAPI.writeBuffer(new byte[]{13, 10}, 0, 2)) continue;
                return false;
            }
            return true;
        }
    }
}

