/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.model;

import androidx.annotation.NonNull;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.model.JXParser;
import java.util.Arrays;

public class JXFontLibInfo
implements JXParser {
    public int libIndex;
    public int libId;
    public int charHeight;
    public String libName;

    @Override
    public boolean parse(byte[] data) {
        if (data == null || data.length < 7) {
            JXLog.e("JXFontLibInfo", "bad param");
            return false;
        }
        try {
            this.libIndex = this.byte2Int(data[3]);
            int length = this.byte2Int(data[4]);
            this.libId = this.byte2Int(data[5]);
            this.charHeight = this.byte2Int(data[6]);
            byte[] nameBytes = Arrays.copyOfRange(data, 7, length + 5);
            this.libName = new String(nameBytes, "GBK");
            return true;
        }
        catch (Exception e) {
            JXLog.e("JXFontLibInfo", "parse exception " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @NonNull
    public String toString() {
        return "\u5b57\u5e93\u540d\u79f0\uff1a" + this.libName + "\u5b57\u5e93index\uff1a" + this.libIndex + ",\u5b57\u5e93id:" + this.libId + ",\u5b57\u7b26\u9ad8\u5ea6\uff1a" + this.charHeight;
    }
}

