package com.jxit.sdkdemo;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.databinding.DataBindingUtil;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Toast;

import com.jxit.sdkdemo.databinding.ActivityHomeBinding;
import com.jxit.sdkdemo.databinding.ActivityMainBinding;
import com.jxit.sdkdemo.fragment.CPCLFragment;
import com.jxit.sdkdemo.fragment.ESCFragment;
import com.jxit.sdkdemo.fragment.GlobalFragment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HomeActivity extends BaseActivity {
    public static final String[] MODEL_ARRAY = {"72mm", "48mm"};
    public static final int _48MM_PRINT_WIDTH = 384;
    public static final int _72MM_PRINTER_WIDTH = 576;
    public static String selectedModel = MODEL_ARRAY[0];
    public static int selectMaxPrinterWidth = _72MM_PRINTER_WIDTH;

    private static final int REQUEST_CONNECT_PRINTER = 101;
    private ActivityHomeBinding mBinding;
    private Fragment globalFragment = new GlobalFragment();
    private Fragment escFragment = new ESCFragment();
    private Fragment cpclFragment = new CPCLFragment();
    public ExecutorService POOL = Executors.newSingleThreadExecutor();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mBinding = DataBindingUtil.setContentView(this, R.layout.activity_home);
        MAdapter adapter = new MAdapter(getSupportFragmentManager());
        mBinding.pager.setAdapter(adapter);
        mBinding.btnConnectPrinter.setOnClickListener(v -> startActivityForResult(new Intent(this, PrinterActivity.class), REQUEST_CONNECT_PRINTER));
        ArrayAdapter<String> spinnerAdapter = new ArrayAdapter(this, android.R.layout.simple_spinner_dropdown_item, Arrays.asList(MODEL_ARRAY));
        mBinding.spinnerModel.setAdapter(spinnerAdapter);
        mBinding.spinnerModel.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                selectedModel = MODEL_ARRAY[position];
                if (selectedModel.equals("48mm")) {
                    selectMaxPrinterWidth = _48MM_PRINT_WIDTH;
                } else {
                    selectMaxPrinterWidth = _72MM_PRINTER_WIDTH;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (PrinterManager.getInstance().isConnected()) {
                    mBinding.btnConnectPrinter.setText(getString(R.string.connect_state));
                } else {
                    mBinding.btnConnectPrinter.setText(getString(R.string.connect_state_none));
                }
            }
        });

    }

    private class MAdapter extends FragmentPagerAdapter {
        private List<Fragment> fragments = new ArrayList<>();

        public MAdapter(FragmentManager fm) {
            super(fm);
            if (PrinterManager.FRAGMENT_ID == 1) {
                fragments.add(escFragment);
            } else if (PrinterManager.FRAGMENT_ID == 2) {
                fragments.add(cpclFragment);
            } else {
                fragments.add(globalFragment);
            }

        }

        @Override
        public Fragment getItem(int i) {
            return fragments.get(i);
        }

        @Override
        public int getCount() {
            return fragments.size();
        }

        @Nullable
        @Override
        public CharSequence getPageTitle(int position) {
            switch (position) {
                case 0:
                    return getString(R.string.tab_global);
                case 1:
                    return getString(R.string.tab_cpcl);
                case 2:
                    return getString(R.string.tab_esc);
                case 3:
                    return getString(R.string.tab_image);
                default:
                    return "";
            }
        }

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        }
    }
}