package com.jxit.sdkdemo;

import android.databinding.DataBindingUtil;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentTransaction;

import com.jxit.printer.jxapi.JXBluetoothAPI;
import com.jxit.sdkdemo.databinding.ActivityPrinterConnectBinding;
import com.jxit.sdkdemo.fragment.BleFragment;
import com.jxit.sdkdemo.fragment.BluetoothFragment;
import com.jxit.sdkdemo.fragment.TcpFragment;
import com.jxit.sdkdemo.fragment.UsbFragment;
@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
public class PrinterActivity extends BaseActivity {
    private BluetoothFragment mBTFragment;
    private UsbFragment mUSBFragment;
    private BleFragment mBleFragment;
    private TcpFragment mTcpFragment;
    private ActivityPrinterConnectBinding bd;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        bd = DataBindingUtil.setContentView(this, R.layout.activity_printer_connect);
        this.setLayout();
        JXBluetoothAPI btApi = JXBluetoothAPI.getDefault(this);
        if (btApi.isBTSupport() && !btApi.isBTEnabled()) {
            btApi.openBluetooth();
        }
    }

    private final void setLayout() {
        this.mBTFragment = new BluetoothFragment();
        this.mUSBFragment = new UsbFragment();
        this.mBleFragment = new BleFragment();
        this.mTcpFragment = new TcpFragment();
        bd.rgConnectType.setOnCheckedChangeListener((group, checkedId) -> showFragment(checkedId));
        bd.rbBt.setChecked(true);
        bd.ibBack.setOnClickListener(v -> finish());
    }

    private final void showFragment(int id) {
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        if (id == R.id.rb_bt) {
            ft.replace(R.id.container, mBTFragment);
        } else if (id == R.id.rb_usb) {
            ft.replace(R.id.container, mUSBFragment);
        } else if (id == R.id.rb_ble) {
            ft.replace(R.id.container, mBleFragment);
        }else if (id == R.id.rb_tcp) {
            ft.replace(R.id.container, mTcpFragment);
        }
        ft.commitAllowingStateLoss();
    }
}
