package com.jxit.sdkdemo;

import android.bluetooth.BluetoothDevice;
import android.hardware.usb.UsbDevice;

import com.jxit.printer.jxapi.JXBleAPI;
import com.jxit.printer.jxapi.JXBluetoothAPI;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxapi.JXTcpAPI;
import com.jxit.printer.jxapi.JXUsbAPI;
import com.jxit.printer.jxsdk.JXPrinter;

/**
 * singleton manager printer status
 */
public class PrinterManager {
    public static int FRAGMENT_ID = 0;
    public static int CONNECT_BLUETOOTH = 1;
    public static int CONNECT_USB = 2;
    public static int CONNECT_BLE = 3;
    public static int CONNECT_WIFI = 4;
    private static volatile PrinterManager mInstance;



    private PrinterManager() {
    }

    public static PrinterManager getInstance() {
        if (mInstance == null) {
            synchronized (PrinterManager.class) {
                if (mInstance == null) {
                    mInstance = new PrinterManager();
                }
            }
        }
        return mInstance;
    }

    private JXInterfaceAPI mApi;
    private int mType;
    // bt device connected
    private BluetoothDevice mBTDevice;
    // usb device connected
    private UsbDevice mUsbDevice;
    private TcpDevice mTcpDevice;
    private JXPrinter mBTPrinter;
    private JXPrinter mUsbPrinter;
    private JXPrinter mBlePrinter;
    private JXPrinter mTcpPrinter;

    public void setAPI(JXBluetoothAPI api, BluetoothDevice device) {
        synchronized (mInstance) {
            mApi = api;
            mBTDevice = device;
            mType = CONNECT_BLUETOOTH;
        }
    }

    public void setAPI(JXBleAPI api, BluetoothDevice device) {
        synchronized (mInstance) {
            mApi = api;
            mBTDevice = device;
            mType = CONNECT_BLE;
        }
    }

    public void setAPI(JXUsbAPI api, UsbDevice device) {
        synchronized (mInstance) {
            mApi = api;
            mUsbDevice = device;
            mType = CONNECT_USB;
        }
    }
    public void setAPI(JXTcpAPI api, TcpDevice device) {
        synchronized (mInstance) {
            mApi = api;
            mTcpDevice = device;
            mType = CONNECT_WIFI;
        }
    }

    public int getType() {
        return mType;
    }

    public JXPrinter getPrinter() {
        if (mApi != null) {
            if (mType == CONNECT_BLUETOOTH) {
                if (mBTPrinter == null) {
                    mBTPrinter = new JXPrinter(mApi);
                }
                return mBTPrinter;
            } else if (mType == CONNECT_USB) {
                if (mUsbPrinter == null) {
                    mUsbPrinter = new JXPrinter(mApi);
                }
                return mUsbPrinter;
            } else if (mType == CONNECT_BLE) {
                if (mBlePrinter == null) {
                    mBlePrinter = new JXPrinter(mApi);
                }
                return mBlePrinter;
            }else if (mType == CONNECT_WIFI) {
                if (mTcpPrinter == null) {
                    mTcpPrinter = new JXPrinter(mApi);
                }
                return mTcpPrinter;
            }
        }
        return null;
    }

    public void closeConnection() {
        if (mApi != null) {
            getPrinter().clear();
            mApi.closeConnection();
            mType = 0;
            mApi = null;
        }
    }

    public JXInterfaceAPI getApi() {
        return mApi;
    }

    public UsbDevice getConnectUsbDevice() {
        return mUsbDevice;
    }

    public BluetoothDevice getConnectBTDevice() {
        return mBTDevice;
    }
    public TcpDevice getConnectTcpDevice() {
        return mTcpDevice;
    }

    public boolean isConnected(int connectType) {
        if (mApi != null) {
            if (mType == connectType) {
                return mApi.isConnected();
            }
        }
        return false;
    }

    public boolean isConnected() {
        if (mApi!=null){
            return mApi.isConnected();
        }else {
            return  false;
        }
    }
}
