package com.jxit.sdkdemo.adapter;

import android.bluetooth.BluetoothClass;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.AdapterView;

import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.TcpDevice;
import com.jxit.sdkdemo.databinding.TcpPairedlistviewItemBinding;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TcpDeviceAdapter extends RecyclerView.Adapter<TcpDeviceAdapter.VH> {
    private List<TcpDevice> mData = new ArrayList<>();
    private Context mContext;
    private LayoutInflater mInflater;
    private AdapterView.OnItemClickListener mListener;
    private AdapterView.OnItemLongClickListener mLongListener;

    public TcpDeviceAdapter(Context context) {
        mContext = context;
        mInflater = LayoutInflater.from(mContext);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        mListener = listener;
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        mLongListener = listener;
    }

    public void setDataAndNotify(Set<TcpDevice> devices) {
        mData.clear();
        if (devices != null) {
            for (TcpDevice device : devices) {
                if (!TextUtils.isEmpty(device.getIp())) {
                    mData.add(device);
                }
            }
        }
        notifyDataSetChanged();
    }

    public void removeAndNotify(int position) {
        if (position >= 0 && position < mData.size()) {
            mData.remove(position);
            notifyItemRemoved(position);
        }
    }

    public void appendDataAndNotify(TcpDevice device) {
        if (device != null) {
            for (TcpDevice d : mData) {
                if (d.getIp().equals(device.getIp())) {
                    return;
                }
            }
            mData.add(device);
            notifyDataSetChanged();
        }
    }


    @NonNull
    @Override
    public VH onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new VH(TcpPairedlistviewItemBinding.inflate(mInflater, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull VH vh, int i) {
        TcpDevice device = mData.get(i);
        vh.bd.setDevice(device);
        vh.itemView.setOnClickListener(v -> {
            if (mListener != null) {
                mListener.onItemClick(null, v, i, i);
            }
        });
        vh.itemView.setOnLongClickListener(v -> {
            if (mLongListener != null) {
                return mLongListener.onItemLongClick(null, v, i, i);
            }
            return false;
        });
        int imageRes = R.drawable.ic_all ;
        vh.bd.lvitemImageFirst.setImageResource(imageRes);
    }

    public TcpDevice getItem(int i) {
        return mData.get(i);
    }

    @Override
    public int getItemCount() {
        return mData.size();
    }

    class VH extends RecyclerView.ViewHolder {
        public TcpPairedlistviewItemBinding bd;

        public VH(@NonNull TcpPairedlistviewItemBinding bd) {
            super(bd.getRoot());
            this.bd = bd;
        }
    }
}
