package com.jxit.sdkdemo.fragment;

import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.jxit.printer.jxapi.JXBleAPI;
import com.jxit.sdkdemo.BaseActivity;
import com.jxit.sdkdemo.PrinterActivity;
import com.jxit.sdkdemo.PrinterManager;
import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.adapter.BluetoothDeviceAdapter;
import com.jxit.sdkdemo.databinding.FragmentBtConnectBinding;

@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
public class BleFragment extends Fragment {
    private FragmentBtConnectBinding bd;
    private BluetoothDeviceAdapter mNewAdapter;
    private JXBleAPI mApi;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (bd == null) {
            bd = FragmentBtConnectBinding.inflate(inflater, container, false);
            setLayout();
        }
        refreshLayout();
        return bd.getRoot();
    }

    private void setLayout() {
        bd.lvPaired.setVisibility(View.GONE);
        mNewAdapter = new BluetoothDeviceAdapter(getContext());
        mNewAdapter.setOnItemClickListener((parent, view, position, id) -> {
            mApi.stopLeScan();
            BluetoothDevice device = mNewAdapter.getItem(position);
            new Thread(() -> {
                connectDevice(device);
            }).start();
        });
        bd.lvNew.setAdapter(mNewAdapter);
        bd.lvNew.setLayoutManager(new LinearLayoutManager(getContext()));
        bd.ibDiscover.setOnClickListener(v -> {
            mNewAdapter.setDataAndNotify(null);
            ((BaseActivity) getActivity()).toast(R.string.bt_start_discovery);
            mApi.startLeScan((device, rssi, scanRecord) -> {
                if (mNewAdapter != null && !TextUtils.isEmpty(device.getName())) {
                    mNewAdapter.appendDataAndNotify(device);
                }
            });
        });

    }

    private void refreshLayout() {
        mApi = JXBleAPI.getDefault(getContext());
        if (PrinterManager.getInstance().isConnected(PrinterManager.CONNECT_BLUETOOTH)) {
            BluetoothDevice device = PrinterManager.getInstance().getConnectBTDevice();
            if (device != null && !TextUtils.isEmpty(device.getName())) {
                String title = getString(R.string.device_connected);
                bd.tvConnectedDevice.setText(String.format("%s: %s(%s)", title, device.getName(), device.getAddress()));
            } else {
                bd.tvConnectedDevice.setText(R.string.no_device_connected);
            }
        }
    }

    private boolean connectDevice(BluetoothDevice device) {
        ((PrinterActivity) getActivity()).showProgress(R.string.bt_connecting);
        JXBleAPI.setMTU(512);
        boolean connected = mApi.openConnection(device.getAddress());
        ((PrinterActivity) getActivity()).hideProgress();
        if (connected) {
            PrinterManager.getInstance().setAPI(mApi, device);
            getActivity().setResult(Activity.RESULT_OK);
            getActivity().finish();
            ((BaseActivity) getActivity()).toast(R.string.connect_success);
        } else {
            ((BaseActivity) getActivity()).toast(R.string.connect_fail);
        }
        return connected;
    }
}
