package com.jxit.sdkdemo.fragment;

import android.Manifest;
import android.app.Activity;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.jxit.printer.jxapi.JXBluetoothAPI;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.sdkdemo.BaseActivity;
import com.jxit.sdkdemo.PrinterActivity;
import com.jxit.sdkdemo.PrinterManager;
import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.adapter.BluetoothDeviceAdapter;
import com.jxit.sdkdemo.databinding.FragmentBtConnectBinding;

import java.util.Set;

public class BluetoothFragment extends Fragment {
    private FragmentBtConnectBinding bd;
    private BluetoothDeviceAdapter mPairedAdapter, mNewAdapter;
    private JXBluetoothAPI mApi;
    private BluetoothDiscoveryReceiver mReceiver = new BluetoothDiscoveryReceiver();

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        IntentFilter filter = new IntentFilter(BluetoothDevice.ACTION_FOUND);
        filter.addAction(BluetoothDevice.ACTION_BOND_STATE_CHANGED);
        context.registerReceiver(mReceiver, filter);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        getContext().unregisterReceiver(mReceiver);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (bd == null) {
            bd = FragmentBtConnectBinding.inflate(inflater, container, false);
            setLayout();
        }
        refreshLayout();
        return bd.getRoot();
    }

    private void setLayout() {
        bd.lvPaired.setVisibility(View.GONE);
//        mPairedAdapter = new BluetoothDeviceAdapter(getContext());
//        mPairedAdapter.setOnItemClickListener((parent, view, position, id) -> {
//            BluetoothDevice device = mPairedAdapter.getItem(position);
//            new Thread(() -> connectDevice(device)).start();
//        });
//        mPairedAdapter.setOnItemLongClickListener((parent, view, position, id) -> {
//            BluetoothDevice device = mPairedAdapter.getItem(position);
//            if (mApi.removeBTBond(device)) {
//                mPairedAdapter.removeAndNotify(position);
//                ((BaseActivity) getActivity()).toast(R.string.bt_bond_remove_success);
//            } else {
//                ((BaseActivity) getActivity()).toast(R.string.bt_bond_remove_fail);
//            }
//            return true;
//        });
//        bd.lvPaired.setAdapter(mPairedAdapter);
//        bd.lvPaired.setLayoutManager(new LinearLayoutManager(getContext()));
        mNewAdapter = new BluetoothDeviceAdapter(getContext());
        mNewAdapter.setOnItemClickListener((parent, view, position, id) -> {
            mApi.cancelDiscovery();
            BluetoothDevice device = mNewAdapter.getItem(position);
            new Thread(() -> {
                Set<BluetoothDevice> bondedDevices = mApi.getBondedDevices();
                if (bondedDevices != null) {
                    for (BluetoothDevice bonded : bondedDevices) {
                        if (bonded.getAddress().equals(device.getAddress())) {
                            connectDevice(device);
                            return;
                        }
                    }
                }
                bondDevice(device);
                //listen bond broadcast
            }).start();
        });
        bd.lvNew.setAdapter(mNewAdapter);
        bd.lvNew.setLayoutManager(new LinearLayoutManager(getContext()));
        bd.ibDiscover.setOnClickListener(v -> {
            mNewAdapter.setDataAndNotify(null);
            ((BaseActivity) getActivity()).toast(R.string.bt_start_discovery);
            mApi.startDiscovery();
        });

    }

    private void refreshLayout() {
        mApi = JXBluetoothAPI.getDefault(getContext());
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            if (ActivityCompat.checkSelfPermission(getContext(), Manifest.permission.BLUETOOTH_CONNECT) != PackageManager.PERMISSION_GRANTED) {
                return ;
            }
        }
        mApi.startDiscovery();
//        mPairedAdapter.setDataAndNotify(mApi.getBondedDevices());
        if (PrinterManager.getInstance().isConnected(PrinterManager.CONNECT_BLUETOOTH)) {
            BluetoothDevice device = PrinterManager.getInstance().getConnectBTDevice();
            if (device != null) {
                String title = getString(R.string.device_connected);
                bd.tvConnectedDevice.setText(String.format("%s: %s(%s)", title, device.getName(), device.getAddress()));
            } else {
                bd.tvConnectedDevice.setText(R.string.no_device_connected);
            }
        }
        if (ActivityCompat.checkSelfPermission(getContext(), Manifest.permission.BLUETOOTH_CONNECT) == PackageManager.PERMISSION_GRANTED) {


        }

    }


    private boolean bondDevice(BluetoothDevice device) {
        ((PrinterActivity) getActivity()).showProgress(R.string.bt_bonding);
        return mApi.createBTBond(device);
    }

    private boolean connectDevice(BluetoothDevice device) {
        ((PrinterActivity) getActivity()).showProgress(R.string.bt_connecting);
        boolean connected = mApi.openConnection(device.getAddress());
        ((PrinterActivity) getActivity()).hideProgress();
        if (connected) {
            PrinterManager.getInstance().setAPI(mApi, device);
            getActivity().setResult(Activity.RESULT_OK);
            getActivity().finish();
            ((BaseActivity) getActivity()).toast(R.string.connect_success);
        } else {
            ((BaseActivity) getActivity()).toast(R.string.connect_fail);
        }
        return connected;
    }

    class BluetoothDiscoveryReceiver extends BroadcastReceiver {
        private final String TAG = BluetoothDiscoveryReceiver.class.getSimpleName();
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction() == BluetoothDevice.ACTION_FOUND) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                    if (ActivityCompat.checkSelfPermission(getContext(), Manifest.permission.BLUETOOTH_CONNECT) != PackageManager.PERMISSION_GRANTED) {
                        return ;
                    }
                }
                BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                if (device != null && !TextUtils.isEmpty(device.getName())) {
                    BluetoothClass btClass = device.getBluetoothClass();
                    if (btClass.getMajorDeviceClass() == BluetoothClass.Device.Major.IMAGING
                            || btClass.getMajorDeviceClass() == BluetoothClass.Device.Major.UNCATEGORIZED) {
                        if (mNewAdapter != null) {
                            mNewAdapter.appendDataAndNotify(device);
                        }
                    }
                }
            } else if (intent.getAction() == BluetoothDevice.ACTION_BOND_STATE_CHANGED) {
                switch (intent.getIntExtra(BluetoothDevice.EXTRA_BOND_STATE, -1)) {
                    case BluetoothDevice.BOND_NONE: {
                        JXLog.i(TAG, "BOND_NONE ");
                        ((PrinterActivity) getActivity()).hideProgress();
                        break;
                    }
                    case BluetoothDevice.BOND_BONDING: {
                        JXLog.i(TAG, "BOND_BONDING");
                        break;
                    }
                    case BluetoothDevice.BOND_BONDED: {
                        JXLog.i(TAG, "BOND_BONDED");
                        BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                        if (device != null) {
                            connectDevice(device);
                        }
                        break;
                    }
                    default:
                        break;
                }

            }

        }
    }
}
