package com.jxit.sdkdemo.fragment;

import static java.lang.Math.sin;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.BarcodeFormat;
import com.jxit.printer.jxsdk.JXGlobalPrinter;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.jxsdk.JXPrinter;
import com.jxit.printer.model.JXPrinterStatus;
import com.jxit.printer.utils.BitmapTools;
import com.jxit.printer.utils.GlobalUtil;
import com.jxit.sdkdemo.BaseActivity;
import com.jxit.sdkdemo.MainActivity;
import com.jxit.sdkdemo.PrinterManager;
import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.databinding.FragmentEscBinding;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ESCFragment extends Fragment implements View.OnClickListener {
    private FragmentEscBinding bd;
    private static final String TAG = "ESCFragment";

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (bd == null) {
            bd = FragmentEscBinding.inflate(inflater, container, false);
        }
        bd.setClickHandler(this);
        return bd.getRoot();
    }


    void sdkPrintText(JXPrinter printer) {
        printer.esc_print_text("\n"+getActivity().getString(R.string.TextDemo)+"：\n");
//        drawText(printer);
        printer.esc_reset();
        printer.esc_align(0);
        printer.esc_print_text(getActivity().getString(R.string.TextLeft)+"\n");
        printer.esc_reset();
        printer.esc_align(1);
        printer.esc_print_text(getActivity().getString(R.string.TextCenter)+"\n");
        printer.esc_reset();
        printer.esc_align(2);
        printer.esc_print_text(getActivity().getString(R.string.TextRight)+"\n");
        printer.esc_reset();
        printer.esc_bold(true);
        printer.esc_print_text(getActivity().getString(R.string.TextBlod)+"n");
        printer.esc_reset();
        printer.esc_underline(2);
        printer.esc_print_text(getActivity().getString(R.string.TextUnderLine)+"\n");
        printer.esc_reset();
        printer.esc_print_text(getActivity().getString(R.string.TextFont)+"\n1"+getActivity().getString(R.string.Times));
        printer.esc_character_size(2);
        printer.esc_print_text("2"+getActivity().getString(R.string.Times));
        printer.esc_character_size(3);
        printer.esc_print_text("3"+getActivity().getString(R.string.Times));
        printer.esc_character_size(4);
        printer.esc_print_text("4"+getActivity().getString(R.string.Times)+"\n");
        printer.esc_reset();
        printer.esc_print_text(getActivity().getString(R.string.Zoom1)+"\n");
        printer.esc_character_size(2);
        printer.esc_print_text(getActivity().getString(R.string.Zoom2)+"\n");
        printer.esc_character_size(3);
        printer.esc_print_text(getActivity().getString(R.string.Zoom3)+"\n");
        printer.esc_character_size(4);
        printer.esc_print_text(getActivity().getString(R.string.Zoom4)+"\n");
        printer.esc_reset();
        printer.esc_font(0);
        printer.esc_print_text(getActivity().getString(R.string.FontA)+"\n");
        printer.esc_reset();
        printer.esc_font(1);
        printer.esc_print_text(getActivity().getString(R.string.FontB)+"\n");
        printer.esc_reset();
        printer.esc_rotate(1);
        printer.esc_print_text(getActivity().getString(R.string.TextRotate90)+"ab12\n");
        printer.esc_reset();
        printer.esc_rotate(2);
        printer.esc_print_text(getActivity().getString(R.string.TextRotate180)+"ab12\n");
        printer.esc_reset();
        printer.esc_rotate(3);
        printer.esc_print_text(getActivity().getString(R.string.TextRotate270)+"ab12\n");
        printer.esc_reset();
        printer.esc_black_white_reverse(true);
        printer.esc_print_text(getActivity().getString(R.string.TextReverse)+"\n");
        printer.esc_reset();
    }


    void sdkPrintPicture(JXPrinter printer) {
        try {
            InputStream is = getResources().getAssets().open("logo.jpeg");
            Bitmap bitmap = BitmapFactory.decodeStream(is);
            printer.esc_reset();
            printer.esc_print_formfeed();
            printer.esc_align(1);
            printer.esc_bitmap_mode(1, bitmap);
            printer.esc_reset();
            printer.esc_print_formfeed();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    /**
     * printBarcode1d
     */
    void sdkPrintBarcode1d(JXPrinter printer) {
        printer.esc_reset();
        printer.esc_print_formfeed();
//        printer.esc_align(50);
        printer.esc_left_margin(50);
        printer.esc_barcode_1d(0, 1, 1, 80, 8, "123456789012");
        printer.esc_print_formfeed(100);
        printer.esc_barcode_1d(0, 1, 2, 80, 8, "123456789012");
        printer.esc_print_formfeed(100);
        printer.esc_barcode_1d(0, 1, 3, 80, 8, "123456789012");
        printer.esc_print_formfeed(150);
        printer.esc_reset();
    }

    /**
     * printBarcode2d
     */
    void sdkPrintBarcode2d(JXPrinter printer) {
        printer.esc_reset();
        printer.esc_print_formfeed();
        printer.esc_print_barcode_2d(4, "1234567890");
        printer.esc_print_formfeed();
        printer.esc_reset();
    }


    void sdkPrintCurve(JXPrinter printer) {
        printer.esc_reset();
        byte curveBytes[] = new byte[7];
        byte y1, y1s = 0;
        byte[] sinBytes = new byte[4];


        curveBytes[0] = 0x1D;
        curveBytes[1] = 0x27;
        curveBytes[2] = 1;    //一段
        curveBytes[3] = 0;   //横向起始点低位
        curveBytes[4] = 0;    //横向起始点高位
        curveBytes[5] = (byte) 240;   //横向结束点低位
        curveBytes[6] = 0;  //横线结束点高位
//        开头的竖线
        printer.esc_write_bytes(curveBytes);

        curveBytes[0] = 0x1D;
        curveBytes[1] = 0x27;
        curveBytes[2] = 2;
        curveBytes[3] = (byte) 130;
        curveBytes[4] = 0;
        curveBytes[5] = (byte) 130;
        curveBytes[6] = 0;
        for (int i = 1; i <= 512; i++) {
            double v =  (sin(Math.PI * i / 128) * 100 + 130);
            Log.e(TAG, "sdkPrintCurve: " + v);
            y1 = (byte) v;
            if (i == 1) {
                y1s = y1;
            }
            printer.esc_write_bytes(curveBytes);

            sinBytes[0] = y1s;
            sinBytes[1] = 0;
            sinBytes[2] = y1;
            sinBytes[3] = 0;

            printer.esc_write_bytes(sinBytes);
            y1s = y1;
        }
        printer.esc_write_bytes(new byte[]{0x0D, 0x0A, 0x0D, 0x0A});
    }

    @Override
    public void onClick(View v) {
        JXInterfaceAPI api = PrinterManager.getInstance().getApi();
        if (api == null || !api.isConnected()) {
            ((BaseActivity) getActivity()).toast(R.string.warn_connect_printer);
            return;
        }
        JXPrinter printer = new JXPrinter(api);

        if (bd.btnPageText.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                sdkPrintText(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageBarcode1D.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                sdkPrintBarcode1d(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();
        } else if (bd.btnPageBarcode2D.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                sdkPrintBarcode2d(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageGraphic.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                sdkPrintPicture(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnLineCurve.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                sdkPrintCurve(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageAllCmd.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                sdkPrintText(printer);
                sdkPrintPicture(printer);
                sdkPrintBarcode1d(printer);
                sdkPrintBarcode2d(printer);
                sdkPrintCurve(printer);
                ((BaseActivity) getActivity()).hideProgress();
            }).start();
        } else if (bd.btnTest.equals(v)) {
//            draw();
        }
    }
}
